/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasValue;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.ValueAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseColumnHeaderMetaDataContextMenuTest<M extends HasCellEditorControls & HasListSelectorControl, V, HV extends HasValue<V>> {
    @Mock
    protected HasTypeRef hasTypeRef;
    @Mock
    protected Consumer<HV> clearValueConsumer;
    @Mock
    protected BiConsumer<HV, V> setValueConsumer;
    @Mock
    protected BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    @Mock
    protected TranslationService translationService;
    @Mock
    protected CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    protected ValueAndDataTypePopoverView.Presenter editor;
    @Mock
    protected ListSelectorView.Presenter listSelector;
    @Mock
    protected BiFunction<Integer, Integer, List<HasListSelectorControl.ListSelectorItem>> listSelectorItemsSupplier;
    @Mock
    protected Consumer<HasListSelectorControl.ListSelectorItem> listSelectorItemConsumer;
    @Mock
    protected HasListSelectorControl.ListSelectorItem item;
    protected M headerMetaData;

    @Before
    public void setup() {
        this.headerMetaData = this.getHeaderMetaData();
        Mockito.when((Object)this.translationService.getTranslation((String)Mockito.any())).thenAnswer(i -> i.getArguments()[0]);
    }

    protected abstract M getHeaderMetaData();

    @Test
    public void testGetEditor() {
        Assertions.assertThat((Optional)this.headerMetaData.getEditor()).isEqualTo(Optional.of(this.listSelector));
    }

    @Test
    public void testGetItems() {
        ((HasListSelectorControl)this.headerMetaData).getItems(0, 1);
        ((BiFunction)Mockito.verify(this.listSelectorItemsSupplier)).apply(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1));
    }

    @Test
    public void testOnItemSelected() {
        ((HasListSelectorControl)this.headerMetaData).onItemSelected(this.item);
        ((Consumer)Mockito.verify(this.listSelectorItemConsumer)).accept((HasListSelectorControl.ListSelectorItem)ArgumentMatchers.eq((Object)this.item));
    }
}

