/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.BaseContextUIModelMapperTest;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridCell;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextUIModelMapperTest
extends BaseContextUIModelMapperTest<ContextUIModelMapper> {
    @Override
    protected ContextUIModelMapper getMapper(boolean isOnlyVisualChangeAllowedSupplier) {
        return new ContextUIModelMapper(this.gridWidget, () -> this.uiModel, () -> Optional.of(this.context), () -> isOnlyVisualChangeAllowedSupplier, this.expressionEditorDefinitionsSupplier, this.listSelector, 0);
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.setup(false);
        this.mapper.fromDMNModel(0, 0);
        this.mapper.fromDMNModel(1, 0);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 0).getValue().getValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 0).getSelectionStrategy()).isSameAs((Object)RowSelectionStrategy.INSTANCE);
        Assertions.assertThat((Object)this.uiModel.getCell(1, 0).getValue().getValue()).isNull();
        Assertions.assertThat((Object)this.uiModel.getCell(1, 0).getSelectionStrategy()).isSameAs((Object)RowSelectionStrategy.INSTANCE);
    }

    @Test
    public void testFromDMNModelName() {
        this.setup(false);
        this.mapper.fromDMNModel(0, 1);
        this.mapper.fromDMNModel(1, 1);
        Assert.assertEquals((Object)"ii1", (Object)((InformationItemCell.HasNameCell)this.uiModel.getCell(0, 1).getValue().getValue()).getName().getValue());
        Assert.assertFalse((boolean)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(1, 1).getValue().getValue()).hasData());
        Assert.assertEquals((Object)"<result>", (Object)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(1, 1).getValue().getValue()).getPlaceHolderText());
    }

    @Test
    public void testFromDMNModelExpression() {
        this.setup(false);
        this.mapper.fromDMNModel(0, 2);
        this.mapper.fromDMNModel(1, 2);
        this.assertUndefinedExpressionGridCellEditor(0, this.undefinedExpressionEditor);
        this.assertUndefinedExpressionGridCellEditor(1, (BaseExpressionGrid)this.literalExpressionEditor);
    }

    private void assertUndefinedExpressionGridCellEditor(int uiRowIndex, BaseExpressionGrid editor) {
        Assert.assertTrue((boolean)(this.uiModel.getCell(uiRowIndex, 2) instanceof ContextGridCell));
        ContextGridCell contextGridCell1 = (ContextGridCell)this.uiModel.getCell(uiRowIndex, 2);
        Assert.assertTrue((boolean)contextGridCell1.getEditor().isPresent());
        Assert.assertEquals((Object)this.listSelector, contextGridCell1.getEditor().get());
        Assert.assertTrue((boolean)(contextGridCell1.getValue() instanceof ExpressionCellValue));
        Assert.assertTrue((boolean)(contextGridCell1.getValue().getValue() instanceof Optional));
        Assert.assertEquals((Object)editor, ((Optional)contextGridCell1.getValue().getValue()).get());
    }

    @Test
    public void testFromDMNModelCellTypes() {
        this.setup(false);
        IntStream.range(0, 2).forEach(rowIndex -> {
            this.mapper.fromDMNModel(rowIndex, 0);
            this.mapper.fromDMNModel(rowIndex, 1);
            this.mapper.fromDMNModel(rowIndex, 2);
        });
        Assertions.assertThat((Object)this.uiModel.getCell(0, 0)).isInstanceOf(ContextGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 1)).isInstanceOf(ContextGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 2)).isInstanceOf(ContextGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(1, 0)).isInstanceOf(DMNGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(1, 1)).isInstanceOf(DMNGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(1, 2)).isInstanceOf(DMNGridCell.class);
    }
}

