/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionDefaultValueUtilities;

public class FunctionDefaultValueUtilitiesTest {
    private FunctionDefinition function;

    @Before
    public void setup() {
        this.function = new FunctionDefinition();
    }

    @Test
    public void testGetNewParameterName() {
        InformationItem informationItem1 = new InformationItem();
        this.function.getFormalParameter().add(informationItem1);
        informationItem1.getName().setValue(FunctionDefaultValueUtilities.getNewParameterName((FunctionDefinition)this.function));
        Assertions.assertThat((String)informationItem1.getName().getValue()).isEqualTo("p-1");
        InformationItem informationItem2 = new InformationItem();
        this.function.getFormalParameter().add(informationItem2);
        informationItem2.getName().setValue(FunctionDefaultValueUtilities.getNewParameterName((FunctionDefinition)this.function));
        Assertions.assertThat((String)informationItem2.getName().getValue()).isEqualTo("p-2");
    }

    @Test
    public void testGetNewParameterNameWithExistingParameters() {
        InformationItem informationItem1 = new InformationItem();
        this.function.getFormalParameter().add(informationItem1);
        informationItem1.getName().setValue("parameter");
        InformationItem informationItem2 = new InformationItem();
        this.function.getFormalParameter().add(informationItem2);
        informationItem2.getName().setValue(FunctionDefaultValueUtilities.getNewParameterName((FunctionDefinition)this.function));
        Assertions.assertThat((String)informationItem2.getName().getValue()).isEqualTo("p-1");
    }

    @Test
    public void testGetNewParameterNameWithDeletion() {
        InformationItem informationItem1 = new InformationItem();
        this.function.getFormalParameter().add(informationItem1);
        informationItem1.getName().setValue(FunctionDefaultValueUtilities.getNewParameterName((FunctionDefinition)this.function));
        Assertions.assertThat((String)informationItem1.getName().getValue()).isEqualTo("p-1");
        InformationItem informationItem2 = new InformationItem();
        this.function.getFormalParameter().add(informationItem2);
        informationItem2.getName().setValue(FunctionDefaultValueUtilities.getNewParameterName((FunctionDefinition)this.function));
        Assertions.assertThat((String)informationItem2.getName().getValue()).isEqualTo("p-2");
        this.function.getFormalParameter().remove(informationItem1);
        InformationItem informationItem3 = new InformationItem();
        this.function.getFormalParameter().add(informationItem3);
        informationItem3.getName().setValue(FunctionDefaultValueUtilities.getNewParameterName((FunctionDefinition)this.function));
        Assertions.assertThat((String)informationItem3.getName().getValue()).isEqualTo("p-3");
    }
}

