/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapperHelper;

public class RelationUIModelMapperHelperTest {
    private Relation relation;

    @Before
    public void setup() {
        this.relation = new Relation();
    }

    @Test
    public void testGetSectionNone() {
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.NONE, (Object)RelationUIModelMapperHelper.getSection((Relation)this.relation, (int)2));
    }

    @Test
    public void testGetSectionRowNumberColumn() {
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.ROW_INDEX, (Object)RelationUIModelMapperHelper.getSection((Relation)this.relation, (int)0));
    }

    @Test
    public void testGetSectionRowNumberColumnWhenInformationItemPresent() {
        this.relation.getColumn().add(new InformationItem());
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.ROW_INDEX, (Object)RelationUIModelMapperHelper.getSection((Relation)this.relation, (int)0));
    }

    @Test
    public void testGetSectionNonExistingNegativeIndex() {
        this.relation.getColumn().add(new InformationItem());
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.NONE, (Object)RelationUIModelMapperHelper.getSection((Relation)this.relation, (int)-1));
    }

    @Test
    public void testGetSectionNonExistingIndexEqualToColumnCount() {
        this.relation.getColumn().add(new InformationItem());
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.NONE, (Object)RelationUIModelMapperHelper.getSection((Relation)this.relation, (int)(this.relation.getColumn().size() + 1)));
    }

    @Test
    public void testGetSectionInformationItemColumn() {
        this.relation.getColumn().add(new InformationItem());
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.INFORMATION_ITEM, (Object)RelationUIModelMapperHelper.getSection((Relation)this.relation, (int)1));
    }

    @Test
    public void testGetInformationItemIndex() {
        this.relation.getColumn().add(new InformationItem());
        this.relation.getColumn().add(new InformationItem());
        Assert.assertEquals((long)0L, (long)RelationUIModelMapperHelper.getInformationItemIndex((Relation)this.relation, (int)1));
        Assert.assertEquals((long)1L, (long)RelationUIModelMapperHelper.getInformationItemIndex((Relation)this.relation, (int)2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSectionInformationItemColumnNegativeIndex() {
        this.relation.getColumn().add(new InformationItem());
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.INFORMATION_ITEM, (Object)RelationUIModelMapperHelper.getInformationItemIndex((Relation)this.relation, (int)-1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSectionInformationItemColumnIndexEqualToColumnCount() {
        this.relation.getColumn().add(new InformationItem());
        Assert.assertEquals((Object)RelationUIModelMapperHelper.RelationSection.INFORMATION_ITEM, (Object)RelationUIModelMapperHelper.getInformationItemIndex((Relation)this.relation, (int)(this.relation.getColumn().size() + 1)));
    }
}

