/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsPageStateProvider;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelsPageStateTest {
    @Mock
    private IncludedModelsPageStateProvider pageProvider;
    private IncludedModelsPageState state;

    @Before
    public void setup() {
        this.state = new IncludedModelsPageState();
    }

    @Test
    public void testGetCurrentDiagramNamespaceWhenPageProviderIsPresent() {
        String expectedNamespace = "://namespace";
        Mockito.when((Object)this.pageProvider.getCurrentDiagramNamespace()).thenReturn((Object)"://namespace");
        this.state.init(this.pageProvider);
        String actualNamespace = this.state.getCurrentDiagramNamespace();
        Assert.assertEquals((Object)"://namespace", (Object)actualNamespace);
    }

    @Test
    public void testGetCurrentDiagramNamespaceWhenPageProviderIsNotPresent() {
        String expectedNamespace = "";
        this.state.init(null);
        String actualNamespace = this.state.getCurrentDiagramNamespace();
        Assert.assertEquals((Object)"", (Object)actualNamespace);
    }

    @Test
    public void testGenerateIncludedModelsWhenPageProviderIsNotPresent() {
        this.state.init(null);
        List actualIncludedModels = this.state.generateIncludedModels();
        List expectedIncludedModels = Collections.emptyList();
        Assert.assertEquals(expectedIncludedModels, (Object)actualIncludedModels);
    }

    @Test
    public void testGenerateIncludedModelsWhenPageProviderIsPresent() {
        List<BaseIncludedModelActiveRecord> expectedIncludedModels = Arrays.asList((BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class), (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class));
        Mockito.when((Object)this.pageProvider.generateIncludedModels()).thenReturn(expectedIncludedModels);
        this.state.init(this.pageProvider);
        List actualIncludedModels = this.state.generateIncludedModels();
        Assert.assertEquals((Object)actualIncludedModels, expectedIncludedModels);
    }
}

