/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.ImportFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.included.imports.messages.IncludedModelErrorMessageFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DMNIncludedModelHandler;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DRGElementHandler;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DefinitionsHandler;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ImportRecordEngine;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ItemDefinitionHandler;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.PMMLIncludedModelHandler;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ImportRecordEngineTest {
    @Mock
    private IncludedModelsPageStateProviderImpl stateProvider;
    @Mock
    private IncludedModelsIndex includedModelsIndex;
    @Mock
    private IncludedModelErrorMessageFactory messageFactory;
    @Mock
    private ImportFactory importFactory;
    @Mock
    private EventSourceMock<FlashMessage> flashMessageEvent;
    @Mock
    private DefinitionsHandler definitionsHandler;
    @Mock
    private ItemDefinitionHandler itemDefinitionHandler;
    @Mock
    private DMNIncludedModelHandler dmnIncludedModelHandler;
    @Mock
    private PMMLIncludedModelHandler pmmlIncludedModelHandler;
    private ManagedInstanceStub<DRGElementHandler> drgElementHandlers;
    private ImportRecordEngine recordEngine;

    @Before
    public void setup() {
        this.drgElementHandlers = new ManagedInstanceStub((Object[])new DRGElementHandler[]{this.itemDefinitionHandler, this.dmnIncludedModelHandler, this.pmmlIncludedModelHandler});
        this.recordEngine = (ImportRecordEngine)Mockito.spy((Object)new ImportRecordEngine(this.stateProvider, this.includedModelsIndex, this.messageFactory, this.importFactory, this.flashMessageEvent, this.definitionsHandler, this.drgElementHandlers));
    }

    @Test
    public void testUpdateWhenIncludedModelIsValid() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        ArgumentCaptor nameCaptor = ArgumentCaptor.forClass(Name.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        String name = "name";
        String oldName = "oldName";
        Mockito.when((Object)record.getName()).thenReturn((Object)"name");
        Mockito.when((Object)record.isValid()).thenReturn((Object)true);
        Mockito.when((Object)this.includedModelsIndex.getImport(record)).thenReturn((Object)anImport);
        Mockito.when((Object)anImport.getName()).thenReturn((Object)new Name("oldName"));
        List actualResult = this.recordEngine.update(record);
        List<BaseIncludedModelActiveRecord> expectedResult = Collections.singletonList(record);
        ((Import)Mockito.verify((Object)anImport)).setName((Name)nameCaptor.capture());
        ((ItemDefinitionHandler)Mockito.verify((Object)this.itemDefinitionHandler)).update("oldName", "name");
        ((DMNIncludedModelHandler)Mockito.verify((Object)this.dmnIncludedModelHandler)).update("oldName", "name");
        ((PMMLIncludedModelHandler)Mockito.verify((Object)this.pmmlIncludedModelHandler)).update("oldName", "name");
        Name actualName = (Name)nameCaptor.getValue();
        Name expectedName = new Name("name");
        Assert.assertEquals((Object)expectedName, (Object)actualName);
        Assert.assertEquals(expectedResult, (Object)actualResult);
    }

    @Test
    public void testUpdateWhenIncludedModelIsNotValid() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        Mockito.when((Object)record.isValid()).thenReturn((Object)false);
        Mockito.when((Object)this.includedModelsIndex.getImport(record)).thenReturn((Object)anImport);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.recordEngine.update(record)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("An invalid Included Model cannot be updated.");
    }

    @Test
    public void testDestroy() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        List<Import> expectedImports = Collections.singletonList(import1);
        ArrayList<Import> actualImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        String name = "name";
        Mockito.when((Object)record.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.includedModelsIndex.getImport(record)).thenReturn((Object)import2);
        Mockito.when((Object)this.stateProvider.getImports()).thenReturn(actualImports);
        List actualResult = this.recordEngine.destroy(record);
        List<BaseIncludedModelActiveRecord> expectedResult = Collections.singletonList(record);
        ((DefinitionsHandler)Mockito.verify((Object)this.definitionsHandler)).destroy(record);
        ((ItemDefinitionHandler)Mockito.verify((Object)this.itemDefinitionHandler)).destroy("name");
        ((DMNIncludedModelHandler)Mockito.verify((Object)this.dmnIncludedModelHandler)).destroy("name");
        ((PMMLIncludedModelHandler)Mockito.verify((Object)this.pmmlIncludedModelHandler)).destroy("name");
        Assert.assertEquals(expectedImports, actualImports);
        Assert.assertEquals(expectedResult, (Object)actualResult);
    }

    @Test
    public void testIsValidWhenNameIsUnique() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Name name1 = (Name)Mockito.mock(Name.class);
        Name name2 = (Name)Mockito.mock(Name.class);
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        ArrayList<Import> imports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Mockito.when((Object)name1.getValue()).thenReturn((Object)"file1");
        Mockito.when((Object)name2.getValue()).thenReturn((Object)"file2");
        Mockito.when((Object)record.getName()).thenReturn((Object)"file-new");
        Mockito.when((Object)import1.getName()).thenReturn((Object)name1);
        Mockito.when((Object)import2.getName()).thenReturn((Object)name2);
        Mockito.when((Object)this.includedModelsIndex.getImport(record)).thenReturn((Object)import2);
        Mockito.when((Object)this.stateProvider.getImports()).thenReturn(imports);
        Mockito.when((Object)this.messageFactory.getNameIsNotUniqueFlashMessage(record)).thenReturn((Object)flashMessage);
        boolean valid = this.recordEngine.isValid(record);
        Assert.assertTrue((boolean)valid);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.flashMessageEvent});
    }

    @Test
    public void testIsValidWhenNameIsNotUnique() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Name name1 = (Name)Mockito.mock(Name.class);
        Name name2 = (Name)Mockito.mock(Name.class);
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        ArrayList<Import> imports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Mockito.when((Object)name1.getValue()).thenReturn((Object)"file1");
        Mockito.when((Object)name2.getValue()).thenReturn((Object)"file2");
        Mockito.when((Object)record.getName()).thenReturn((Object)"file1");
        Mockito.when((Object)import1.getName()).thenReturn((Object)name1);
        Mockito.when((Object)import2.getName()).thenReturn((Object)name2);
        Mockito.when((Object)this.includedModelsIndex.getImport(record)).thenReturn((Object)import2);
        Mockito.when((Object)this.stateProvider.getImports()).thenReturn(imports);
        Mockito.when((Object)this.messageFactory.getNameIsNotUniqueFlashMessage(record)).thenReturn((Object)flashMessage);
        boolean valid = this.recordEngine.isValid(record);
        Assert.assertFalse((boolean)valid);
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)flashMessage);
    }

    @Test
    public void testIsValidWhenNameIsBlank() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        Name name = (Name)Mockito.mock(Name.class);
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        ArrayList<Import> imports = new ArrayList<Import>(Collections.singletonList(anImport));
        Mockito.when((Object)name.getValue()).thenReturn((Object)"file");
        Mockito.when((Object)record.getName()).thenReturn((Object)"");
        Mockito.when((Object)anImport.getName()).thenReturn((Object)name);
        Mockito.when((Object)this.includedModelsIndex.getImport(record)).thenReturn((Object)anImport);
        Mockito.when((Object)this.stateProvider.getImports()).thenReturn(imports);
        Mockito.when((Object)this.messageFactory.getNameIsBlankFlashMessage(record)).thenReturn((Object)flashMessage);
        boolean valid = this.recordEngine.isValid(record);
        Assert.assertFalse((boolean)valid);
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)flashMessage);
    }

    @Test
    public void testIsValidWhenNameIsUnchanged() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Name name1 = (Name)Mockito.mock(Name.class);
        Name name2 = (Name)Mockito.mock(Name.class);
        FlashMessage flashMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        ArrayList<Import> imports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Mockito.when((Object)name1.getValue()).thenReturn((Object)"file1");
        Mockito.when((Object)name2.getValue()).thenReturn((Object)"file2");
        Mockito.when((Object)record.getName()).thenReturn((Object)"file2");
        Mockito.when((Object)import1.getName()).thenReturn((Object)name1);
        Mockito.when((Object)import2.getName()).thenReturn((Object)name2);
        Mockito.when((Object)this.includedModelsIndex.getImport(record)).thenReturn((Object)import2);
        Mockito.when((Object)this.stateProvider.getImports()).thenReturn(imports);
        Mockito.when((Object)this.messageFactory.getNameIsNotUniqueFlashMessage(record)).thenReturn((Object)flashMessage);
        boolean valid = this.recordEngine.isValid(record);
        Assert.assertTrue((boolean)valid);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.flashMessageEvent});
    }

    @Test
    public void testCreate() {
        BaseIncludedModelActiveRecord record = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Import import3 = (Import)Mockito.mock(Import.class);
        List<Import> expectedImports = Arrays.asList(import1, import2, import3);
        ArrayList<Import> actualImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Mockito.when((Object)this.importFactory.makeImport(record)).thenReturn((Object)import3);
        Mockito.when((Object)this.stateProvider.getImports()).thenReturn(actualImports);
        List actualResult = this.recordEngine.create(record);
        List<BaseIncludedModelActiveRecord> expectedResult = Collections.singletonList(record);
        ((DefinitionsHandler)Mockito.verify((Object)this.definitionsHandler)).create(record);
        Assert.assertEquals(expectedImports, actualImports);
        Assert.assertEquals(expectedResult, (Object)actualResult);
    }
}

