/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeKind;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.validation.DataTypeNameValidator;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeUtilsTest {
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private TranslationService translationService;
    @Mock
    private ItemDefinitionRecordEngine recordEngine;
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private ManagedInstance<DataTypeManager> dataTypeManagers;
    @Mock
    private DataTypeNameValidator dataTypeNameValidator;
    @Mock
    private DataTypeManagerStackStore typeStack;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    private Definitions definitions = this.makeModelDefinitions();
    private final String STRUCTURE = "STRUCTURE";
    private final String IMPORT_NAME = "MYMODEL";
    private DataTypeManager dataTypeManager;
    private DataTypeUtils utils;

    @Before
    public void setup() {
        this.dataTypeManager = (DataTypeManager)Mockito.spy((Object)new DataTypeManager(this.translationService, this.recordEngine, this.itemDefinitionStore, this.dataTypeStore, this.itemDefinitionUtils, this.dataTypeManagers, this.dataTypeNameValidator, this.typeStack));
        this.utils = (DataTypeUtils)Mockito.spy((Object)new DataTypeUtils(this.dataTypeStore, this.dataTypeManager, this.dmnGraphUtils));
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"STRUCTURE");
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)this.definitions);
    }

    @Test
    public void testDefaultDataTypes() {
        List dataTypes = this.utils.defaultDataTypes();
        Assert.assertEquals((long)10L, (long)dataTypes.size());
        Assert.assertEquals((Object)"Any", (Object)((DataType)dataTypes.get(0)).getType());
        Assert.assertEquals((Object)"boolean", (Object)((DataType)dataTypes.get(1)).getType());
        Assert.assertEquals((Object)"context", (Object)((DataType)dataTypes.get(2)).getType());
        Assert.assertEquals((Object)"date", (Object)((DataType)dataTypes.get(3)).getType());
        Assert.assertEquals((Object)"date and time", (Object)((DataType)dataTypes.get(4)).getType());
        Assert.assertEquals((Object)"days and time duration", (Object)((DataType)dataTypes.get(5)).getType());
        Assert.assertEquals((Object)"number", (Object)((DataType)dataTypes.get(6)).getType());
        Assert.assertEquals((Object)"string", (Object)((DataType)dataTypes.get(7)).getType());
        Assert.assertEquals((Object)"time", (Object)((DataType)dataTypes.get(8)).getType());
        Assert.assertEquals((Object)"years and months duration", (Object)((DataType)dataTypes.get(9)).getType());
    }

    @Test
    public void testCustomDataTypes() {
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> unorderedDataTypes = Arrays.asList(dataType1, dataType2);
        List<DataType> expectedDataTypes = Arrays.asList(dataType2, dataType1);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(unorderedDataTypes);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"z");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"a");
        List actualDataTypes = this.utils.customDataTypes();
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testGetTopLevelParent() {
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        String uuid1 = "0000";
        String uuid2 = "1111";
        String uuid3 = "2222";
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"0000");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"1111");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"2222");
        Mockito.when((Object)dataType1.getParentUUID()).thenReturn((Object)"");
        Mockito.when((Object)dataType2.getParentUUID()).thenReturn((Object)"0000");
        Mockito.when((Object)dataType3.getParentUUID()).thenReturn((Object)"1111");
        Mockito.when((Object)this.dataTypeStore.get("0000")).thenReturn((Object)dataType1);
        Mockito.when((Object)this.dataTypeStore.get("1111")).thenReturn((Object)dataType2);
        Mockito.when((Object)this.dataTypeStore.get("2222")).thenReturn((Object)dataType3);
        DataType topLevelParent = this.utils.getTopLevelParent(dataType3);
        Assert.assertEquals((Object)dataType1, (Object)topLevelParent);
    }

    @Test
    public void testGetDataTypeKindWhenItsBuiltIn() {
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Collections.emptyList());
        DataTypeKind expectedKind = DataTypeKind.BUILT_IN;
        DataTypeKind actualKind = this.utils.getDataTypeKind("number");
        Assert.assertEquals((Object)expectedKind, (Object)actualKind);
    }

    @Test
    public void testGetDataTypeKindWhenItsCustom() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Collections.singletonList(dataType));
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"tUUID");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"string");
        DataTypeKind expectedKind = DataTypeKind.CUSTOM;
        DataTypeKind actualKind = this.utils.getDataTypeKind("tUUID");
        Assert.assertEquals((Object)expectedKind, (Object)actualKind);
    }

    @Test
    public void testGetDataTypeKindWhenItsStructure() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Collections.singletonList(dataType));
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"tPerson");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"STRUCTURE");
        DataTypeKind expectedKind = DataTypeKind.STRUCTURE;
        DataTypeKind actualKind = this.utils.getDataTypeKind("tPerson");
        Assert.assertEquals((Object)expectedKind, (Object)actualKind);
    }

    @Test
    public void testGetDataTypeKindWhenItsIncluded() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String typeName = "MYMODELtPerson";
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"MYMODELtPerson");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"STRUCTURE");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Collections.singletonList(dataType));
        DataTypeKind expectedKind = DataTypeKind.INCLUDED;
        DataTypeKind actualKind = this.utils.getDataTypeKind("MYMODELtPerson");
        Assert.assertEquals((Object)expectedKind, (Object)actualKind);
    }

    private Definitions makeModelDefinitions() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        List<Import> imports = Collections.singletonList(this.makeImport());
        Mockito.when((Object)definitions.getImport()).thenReturn(imports);
        return definitions;
    }

    private Import makeImport() {
        Import anImport = (Import)Mockito.mock(Import.class);
        Name myModelName = new Name("MYMODEL");
        Mockito.when((Object)anImport.getName()).thenReturn((Object)myModelName);
        return anImport;
    }
}

