/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemDefinitionUtilsTest {
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    private ItemDefinitionUtils utils;

    @Before
    public void setup() {
        this.utils = (ItemDefinitionUtils)Mockito.spy((Object)new ItemDefinitionUtils(this.dmnGraphUtils));
    }

    @Test
    public void testFindByName() {
        String name = "item1";
        ItemDefinition item1 = this.makeItem("item1");
        ItemDefinition item2 = this.makeItem("item2");
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        List<ItemDefinition> itemDefinitions = Arrays.asList(item1, item2);
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(itemDefinitions);
        Optional actual = this.utils.findByName("item1");
        Optional<ItemDefinition> expected = Optional.of(item1);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testAddItemDefinitions() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        ItemDefinition itemDefinition1 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition2 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition3 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition4 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<ItemDefinition> newItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition3);
        List<ItemDefinition> expectedItemDefinitions = Arrays.asList(itemDefinition2, itemDefinition4, itemDefinition1, itemDefinition3);
        ArrayList<ItemDefinition> actualItemDefinitions = new ArrayList<ItemDefinition>(Arrays.asList(itemDefinition2, itemDefinition4));
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(actualItemDefinitions);
        this.utils.addItemDefinitions(newItemDefinitions);
        Assert.assertEquals(expectedItemDefinitions, actualItemDefinitions);
    }

    @Test
    public void testGetPrefixForNamespaceURIWhenDefinitionsIsNull() {
        String namespaceURI = DMNModelInstrumentedBase.Namespace.FEEL.getUri();
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn(null);
        Optional prefix = this.utils.getPrefixForNamespaceURI(namespaceURI);
        Assert.assertFalse((boolean)prefix.isPresent());
    }

    @Test
    public void testGetPrefixForNamespaceURIWhenPrefixForNamespaceURIIsNotPresent() {
        String namespaceURI = DMNModelInstrumentedBase.Namespace.FEEL.getUri();
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getPrefixForNamespaceURI(namespaceURI)).thenReturn(Optional.empty());
        Optional prefix = this.utils.getPrefixForNamespaceURI(namespaceURI);
        Assert.assertFalse((boolean)prefix.isPresent());
    }

    @Test
    public void testGetPrefixForNamespaceURIWhenPrefixForNamespaceURIIsPresent() {
        String namespaceURI = DMNModelInstrumentedBase.Namespace.FEEL.getUri();
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Optional<String> expectedPrefix = Optional.of("prefix");
        Mockito.when((Object)this.dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getPrefixForNamespaceURI(namespaceURI)).thenReturn(expectedPrefix);
        Optional actualPrefix = this.utils.getPrefixForNamespaceURI(namespaceURI);
        Assert.assertEquals(expectedPrefix, (Object)actualPrefix);
    }

    @Test
    public void testNormaliseTypeRefWhenPrefixForNamespaceURIIsNotPresent() {
        String expectedNamespace = DMNModelInstrumentedBase.Namespace.FEEL.getUri();
        String expectedLocalPart = "string";
        String expectedPrefix = "";
        QName qName = new QName(expectedNamespace, "string");
        ((ItemDefinitionUtils)Mockito.doReturn(Optional.empty()).when((Object)this.utils)).getPrefixForNamespaceURI(expectedNamespace);
        QName actualQName = this.utils.normaliseTypeRef(qName);
        Assert.assertEquals((Object)"string", (Object)actualQName.getLocalPart());
        Assert.assertEquals((Object)expectedNamespace, (Object)actualQName.getNamespaceURI());
        Assert.assertEquals((Object)"", (Object)actualQName.getPrefix());
    }

    @Test
    public void testNormaliseTypeRefWhenPrefixForNamespaceURIIsPresent() {
        String expectedLocalPart = "string";
        String expectedPrefix = "feel";
        String expectedNamespace = "";
        String namespaceURI = DMNModelInstrumentedBase.Namespace.FEEL.getUri();
        QName qName = new QName(namespaceURI, "string");
        ((ItemDefinitionUtils)Mockito.doReturn(Optional.of("feel")).when((Object)this.utils)).getPrefixForNamespaceURI(namespaceURI);
        QName actualQName = this.utils.normaliseTypeRef(qName);
        Assert.assertEquals((Object)"string", (Object)actualQName.getLocalPart());
        Assert.assertEquals((Object)"", (Object)actualQName.getNamespaceURI());
        Assert.assertEquals((Object)"feel", (Object)actualQName.getPrefix());
    }

    @Test
    public void testGetConstraintTextWhenItemDefinitionDoesNotHaveAllowedValues() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String expectedText = "";
        String actualText = this.utils.getConstraintText(itemDefinition);
        Assert.assertEquals((Object)"", (Object)actualText);
    }

    @Test
    public void testGetConstraintTextWhenItemDefinitionHasAllowedValues() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        UnaryTests allowedValues = (UnaryTests)Mockito.mock(UnaryTests.class);
        String expectedText = "(1..10)";
        Mockito.when((Object)allowedValues.getText()).thenReturn((Object)new Text("(1..10)"));
        Mockito.when((Object)itemDefinition.getAllowedValues()).thenReturn((Object)allowedValues);
        String actualText = this.utils.getConstraintText(itemDefinition);
        Assert.assertEquals((Object)"(1..10)", (Object)actualText);
    }

    private ItemDefinition makeItem(String itemName) {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Name name = (Name)Mockito.mock(Name.class);
        Mockito.when((Object)name.getValue()).thenReturn((Object)itemName);
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)name);
        return itemDefinition;
    }
}

