/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported.treelist;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItemView;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListSubItem;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class TreeListItemViewTest {
    @Mock
    private HTMLDivElement itemHeader;
    @Mock
    private HTMLDivElement itemsContainer;
    @Mock
    private HTMLDivElement itemDetails;
    @Mock
    private HTMLDivElement expandContainer;
    @Mock
    private HTMLElement expand;
    @Mock
    private HTMLInputElement checkbox;
    @Mock
    private HTMLDivElement root;
    private TreeListItemView itemView;

    @Before
    public void setup() {
        this.itemView = (TreeListItemView)Mockito.spy((Object)new TreeListItemView(this.itemHeader, this.itemsContainer, this.itemDetails, this.expandContainer, this.expand, this.checkbox, this.root));
        ((TreeListItemView)Mockito.doNothing().when((Object)this.itemView)).showElement((HTMLElement)ArgumentMatchers.any());
        ((TreeListItemView)Mockito.doNothing().when((Object)this.itemView)).hideElement((HTMLElement)ArgumentMatchers.any());
    }

    @Test
    public void testInit() {
        TreeListItem presenter = (TreeListItem)Mockito.mock(TreeListItem.class);
        this.itemView.init(presenter);
        TreeListItem actual = this.itemView.getPresenter();
        Assert.assertEquals((Object)actual, (Object)presenter);
    }

    @Test
    public void testOnCheckboxChanged() {
        TreeListItem presenter = (TreeListItem)Mockito.mock(TreeListItem.class);
        this.itemView.init(presenter);
        this.checkbox.checked = true;
        this.itemView.onCheckboxChanged(null);
        ((TreeListItem)Mockito.verify((Object)presenter)).setIsSelected(true);
        this.checkbox.checked = false;
        this.itemView.onCheckboxChanged(null);
        ((TreeListItem)Mockito.verify((Object)presenter)).setIsSelected(false);
    }

    @Test
    public void testOnClickCheckbox() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((TreeListItemView)Mockito.doReturn((Object)this.checkbox).when((Object)this.itemView)).getTarget(event);
        this.itemView.onClick(event);
        ((TreeListItemView)Mockito.verify((Object)this.itemView, (VerificationMode)Mockito.never())).showElement((HTMLElement)this.itemsContainer);
        ((TreeListItemView)Mockito.verify((Object)this.itemView, (VerificationMode)Mockito.never())).hideElement((HTMLElement)this.itemsContainer);
    }

    @Test
    public void testPopulate() {
        ArrayList subItems = new ArrayList();
        String itemDescription = "Item Description";
        TreeListItem item = (TreeListItem)Mockito.mock(TreeListItem.class);
        Mockito.when((Object)item.getIsSelected()).thenReturn((Object)true);
        Mockito.when((Object)item.getDescription()).thenReturn((Object)"Item Description");
        Mockito.when((Object)item.getSubItems()).thenReturn(subItems);
        ((TreeListItemView)Mockito.doNothing().when((Object)this.itemView)).setExpandVisibility(item);
        this.itemView.populate(item);
        Assert.assertTrue((boolean)this.checkbox.checked);
        Assert.assertEquals((Object)"Item Description", (Object)this.itemDetails.textContent);
        ((TreeListItemView)Mockito.verify((Object)this.itemView)).addSubItems(item);
        ((TreeListItemView)Mockito.verify((Object)this.itemView)).setExpandVisibility(item);
    }

    @Test
    public void testSetExpandVisibility() {
        TreeListItem item = (TreeListItem)Mockito.mock(TreeListItem.class);
        ArrayList<TreeListSubItem> subItems = new ArrayList<TreeListSubItem>();
        Mockito.when((Object)item.getSubItems()).thenReturn(subItems);
        this.itemView.setExpandVisibility(item);
        ((TreeListItemView)Mockito.verify((Object)this.itemView)).hideElement(this.expand);
        subItems.add((TreeListSubItem)Mockito.mock(TreeListSubItem.class));
        this.itemView.setExpandVisibility(item);
        ((TreeListItemView)Mockito.verify((Object)this.itemView)).showElement(this.expand);
    }

    @Test
    public void testAddSubItems() {
        TreeListItem item = (TreeListItem)Mockito.mock(TreeListItem.class);
        TreeListSubItem subItem1 = (TreeListSubItem)Mockito.mock(TreeListSubItem.class);
        Node element1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)subItem1.getElement()).thenReturn((Object)element1);
        TreeListSubItem subItem2 = (TreeListSubItem)Mockito.mock(TreeListSubItem.class);
        Node element2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)subItem2.getElement()).thenReturn((Object)element2);
        List<TreeListSubItem> subItems = Arrays.asList(subItem1, subItem2);
        Mockito.when((Object)item.getSubItems()).thenReturn(subItems);
        this.itemView.addSubItems(item);
        ((HTMLDivElement)Mockito.verify((Object)this.itemsContainer)).appendChild(element2);
        ((HTMLDivElement)Mockito.verify((Object)this.itemsContainer)).appendChild(element2);
    }
}

