/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.kie.workbench.common.dmn.client.editors.types.imported.ImportDataObjectModal;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListView;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DataTypeListViewTest {
    @Mock
    private HTMLDivElement listItems;
    @Mock
    private HTMLElement element;
    @Mock
    private HTMLButtonElement addButton;
    @Mock
    private HTMLDivElement placeholder;
    @Mock
    private HTMLDivElement searchBarContainer;
    @Mock
    private HTMLAnchorElement expandAll;
    @Mock
    private HTMLAnchorElement collapseAll;
    @Mock
    private HTMLDivElement noDataTypesFound;
    @Mock
    private DataTypeSearchBar searchBar;
    @Mock
    private HTMLElement searchBarElement;
    @Mock
    private HTMLDivElement readOnlyMessage;
    @Mock
    private HTMLButtonElement readOnlyMessageCloseButton;
    @Mock
    private ScrollHelper scrollHelper;
    @Mock
    private DNDListComponent dndListComponent;
    @Mock
    private HTMLElement dndListComponentElement;
    @Mock
    private DataTypeList presenter;
    @Mock
    private HTMLButtonElement importDataObjectButton;
    @Mock
    private ImportDataObjectModal importDataObjectModal;
    @Mock
    private EventSourceMock<FlashMessage> flashMessageEvent;
    @Mock
    private TranslationService translationService;
    @Mock
    private HTMLButtonElement addButtonPlaceholder;
    @Mock
    private HTMLDivElement dataTypeButton;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Captor
    private ArgumentCaptor<FlashMessage> flashMessageCaptor;
    private DataTypeListView view;

    @Before
    public void setup() {
        Mockito.when((Object)this.presenter.getSearchBar()).thenReturn((Object)this.searchBar);
        Mockito.when((Object)this.searchBar.getElement()).thenReturn((Object)this.searchBarElement);
        Mockito.when((Object)this.presenter.getDNDListComponent()).thenReturn((Object)this.dndListComponent);
        Mockito.when((Object)this.dndListComponent.getElement()).thenReturn((Object)this.dndListComponentElement);
        this.placeholder.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.noDataTypesFound.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.listItems.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.dataTypeButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.listItems.childNodes = new NodeList();
        this.view = (DataTypeListView)Mockito.spy((Object)new DataTypeListView(this.listItems, this.addButton, this.addButtonPlaceholder, this.dataTypeButton, this.placeholder, this.searchBarContainer, this.expandAll, this.collapseAll, this.noDataTypesFound, this.readOnlyMessage, this.readOnlyMessageCloseButton, this.scrollHelper, this.importDataObjectButton, this.importDataObjectModal, this.flashMessageEvent, this.translationService, this.readOnlyProvider));
        this.view.init(this.presenter);
        ((DataTypeListView)Mockito.doReturn((Object)this.element).when((Object)this.view)).getElement();
    }

    @Test
    public void testInit() {
        ((HTMLDivElement)Mockito.verify((Object)this.searchBarContainer)).appendChild((Node)this.searchBarElement);
        ((HTMLDivElement)Mockito.verify((Object)this.listItems)).appendChild((Node)this.dndListComponentElement);
        ((DataTypeListView)Mockito.verify((Object)this.view)).setupAddButtonReadOnlyStatus();
    }

    @Test
    public void testSetupAddButtonReadOnlyStatusWhenIsReadOnly() {
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        this.view.setupAddButtonReadOnlyStatus();
        Assert.assertTrue((boolean)this.addButton.disabled);
    }

    @Test
    public void testSetupAddButtonReadOnlyStatusWhenIsNotReadOnly() {
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)false);
        this.view.setupAddButtonReadOnlyStatus();
        Assert.assertFalse((boolean)this.addButton.disabled);
    }

    @Test
    public void testShowOrHideNoCustomItemsMessageWhenListHasCustomDataType() {
        ((DataTypeListView)Mockito.doReturn((Object)true).when((Object)this.view)).hasCustomDataType();
        this.view.showOrHideNoCustomItemsMessage();
        ((DataTypeListView)Mockito.verify((Object)this.view)).showListItems();
        ((DataTypeListView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showPlaceHolder();
    }

    @Test
    public void testShowOrHideNoCustomItemsMessageWhenListDoesNotHaveCustomDataType() {
        ((DataTypeListView)Mockito.doReturn((Object)false).when((Object)this.view)).hasCustomDataType();
        this.view.showOrHideNoCustomItemsMessage();
        ((DataTypeListView)Mockito.verify((Object)this.view)).showPlaceHolder();
        ((DataTypeListView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showListItems();
    }

    @Test
    public void testExpandAll() {
        this.view.expandAll((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeList)Mockito.verify((Object)this.presenter)).expandAll();
    }

    @Test
    public void testCollapseAll() {
        this.view.collapseAll((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeList)Mockito.verify((Object)this.presenter)).collapseAll();
    }

    @Test
    public void testShowNoDataTypesFound() {
        this.view.showNoDataTypesFound();
        ((DOMTokenList)Mockito.verify((Object)this.noDataTypesFound.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.placeholder.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.listItems.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testShowListItems() {
        this.view.showListItems();
        ((DOMTokenList)Mockito.verify((Object)this.noDataTypesFound.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.placeholder.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.listItems.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.dataTypeButton.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testShowPlaceHolder() {
        this.view.showPlaceHolder();
        ((DOMTokenList)Mockito.verify((Object)this.noDataTypesFound.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.placeholder.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.listItems.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.dataTypeButton.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testCleanSubTypesByDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String uuid = "uuid";
        ((DataTypeListView)Mockito.doNothing().when((Object)this.view)).cleanSubTypes((String)Mockito.any());
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        this.view.cleanSubTypes(dataType);
        ((DataTypeListView)Mockito.verify((Object)this.view)).cleanSubTypes("uuid");
    }

    @Test
    public void testCleanSubTypesByUUID() {
        String parentUUID = "parentUUID";
        String child1UUID = "child1UUID";
        String child2UUID = "child2UUID";
        HTMLElement parentElement = this.makeHTMLElement();
        NodeList children = (NodeList)Mockito.spy((Object)new NodeList());
        Element child1 = this.makeElement("child1UUID");
        Element child2 = this.makeElement("child2UUID");
        Element child3NoParent = this.makeElement("child3UUID");
        Node child4Null = null;
        child2.parentNode = parentElement;
        child1.parentNode = parentElement;
        children.length = 4;
        ((NodeList)Mockito.doReturn((Object)child1).when((Object)children)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)child2).when((Object)children)).getAt(1);
        ((NodeList)Mockito.doReturn((Object)child3NoParent).when((Object)children)).getAt(2);
        ((NodeList)Mockito.doReturn(child4Null).when((Object)children)).getAt(3);
        this.mockDOMElementsByParentUUID("parentUUID", (NodeList<Element>)children);
        this.view.cleanSubTypes("parentUUID");
        ((DataTypeList)Mockito.verify((Object)this.presenter)).removeItem("child1UUID");
        ((DataTypeList)Mockito.verify((Object)this.presenter)).removeItem("child2UUID");
        ((Element)Mockito.verify((Object)parentElement)).removeChild((Node)child1);
        ((Element)Mockito.verify((Object)parentElement)).removeChild((Node)child2);
        ((Element)Mockito.verify((Object)parentElement, (VerificationMode)Mockito.never())).removeChild((Node)child3NoParent);
        ((Element)Mockito.verify((Object)parentElement, (VerificationMode)Mockito.never())).removeChild(child4Null);
    }

    @Test
    public void testAddSubItems() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String dataTypeUUID = "dataTypeUUID";
        HTMLElement dataTypeRow = this.makeHTMLElement();
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement listItemElement1 = this.makeHTMLElement();
        HTMLElement listItemElement2 = this.makeHTMLElement();
        List<DataTypeListItem> listItems = Arrays.asList(listItem1, listItem2);
        Mockito.when((Object)this.listItems.querySelector("[data-row-uuid=\"dataTypeUUID\"]")).thenReturn((Object)dataTypeRow);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"dataTypeUUID");
        Mockito.when((Object)listItem1.getDragAndDropElement()).thenReturn((Object)listItemElement1);
        Mockito.when((Object)listItem2.getDragAndDropElement()).thenReturn((Object)listItemElement2);
        ((DataTypeListView)Mockito.doNothing().when((Object)this.view)).cleanSubTypes((String)Mockito.any());
        ((DataTypeListView)Mockito.doNothing().when((Object)this.view)).hideItemElementIfParentIsCollapsed((HTMLElement)ArgumentMatchers.any(), (Element)ArgumentMatchers.any());
        ((DataTypeListView)Mockito.doNothing().when((Object)this.view)).showArrowIconIfDataTypeHasChildren((DataType)ArgumentMatchers.any());
        this.view.addSubItems(dataType, listItems);
        ((DataTypeListView)Mockito.verify((Object)this.view)).hideItemElementIfParentIsCollapsed(listItemElement1, (Element)dataTypeRow);
        ((DataTypeListView)Mockito.verify((Object)this.view)).hideItemElementIfParentIsCollapsed(listItemElement2, (Element)listItemElement1);
        ((DataTypeListView)Mockito.verify((Object)this.view)).showArrowIconIfDataTypeHasChildren(dataType);
        ((Node)Mockito.verify((Object)dataTypeRow.parentNode)).insertBefore((Node)listItemElement1, dataTypeRow.nextSibling);
        ((Node)Mockito.verify((Object)listItemElement1.parentNode)).insertBefore((Node)listItemElement2, listItemElement1.nextSibling);
        ((DataTypeListView)Mockito.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
    }

    @Test
    public void testOnAddClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        this.view.onAddButtonClick(event);
        ((ScrollHelper)Mockito.verify((Object)this.scrollHelper)).animatedScrollToBottom((Element)this.listItems);
        ((DataTypeList)Mockito.verify((Object)this.presenter)).addDataType();
    }

    @Test
    public void testOnReadOnlyMessageCloseButtonClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        this.readOnlyMessage.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.onReadOnlyMessageCloseButtonClick(event);
        ((DOMTokenList)Mockito.verify((Object)this.readOnlyMessage.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testHideItemElementIfParentIsCollapsedWhenParentIsCollapsed() {
        HTMLElement itemElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element parent = (Element)Mockito.mock(Element.class);
        Element arrow = (Element)Mockito.mock(Element.class);
        DOMTokenList itemElementClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList parentClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList arrowClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        itemElement.classList = itemElementClassList;
        parent.classList = parentClassList;
        arrow.classList = arrowClassList;
        Mockito.when((Object)arrowClassList.contains("fa-chevron-right")).thenReturn((Object)true);
        Mockito.when((Object)parentClassList.contains("hidden")).thenReturn((Object)false);
        Mockito.when((Object)parent.querySelector("[data-type-field=\"arrow-button\"]")).thenReturn((Object)arrow);
        this.view.hideItemElementIfParentIsCollapsed(itemElement, parent);
        ((DOMTokenList)Mockito.verify((Object)itemElementClassList)).add(new String[]{"hidden"});
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).setInitialHiddenPositionY(itemElement);
    }

    @Test
    public void testHideItemElementIfParentIsCollapsedWhenParentIsCollapsedByAnotherParent() {
        HTMLElement itemElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element parent = (Element)Mockito.mock(Element.class);
        Element arrow = (Element)Mockito.mock(Element.class);
        DOMTokenList itemElementClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList parentClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList arrowClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        itemElement.classList = itemElementClassList;
        parent.classList = parentClassList;
        arrow.classList = arrowClassList;
        Mockito.when((Object)arrowClassList.contains("fa-chevron-right")).thenReturn((Object)false);
        Mockito.when((Object)parentClassList.contains("hidden")).thenReturn((Object)true);
        Mockito.when((Object)parent.querySelector("[data-type-field=\"arrow-button\"]")).thenReturn((Object)arrow);
        this.view.hideItemElementIfParentIsCollapsed(itemElement, parent);
        ((DOMTokenList)Mockito.verify((Object)itemElementClassList)).add(new String[]{"hidden"});
    }

    @Test
    public void testHideItemElementIfParentIsCollapsedWhenParentIsNotCollapsed() {
        HTMLElement itemElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element parent = (Element)Mockito.mock(Element.class);
        Element arrow = (Element)Mockito.mock(Element.class);
        DOMTokenList itemElementClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList parentClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        DOMTokenList arrowClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        itemElement.classList = itemElementClassList;
        parent.classList = parentClassList;
        arrow.classList = arrowClassList;
        Mockito.when((Object)arrowClassList.contains("fa-chevron-right")).thenReturn((Object)false);
        Mockito.when((Object)parentClassList.contains("hidden")).thenReturn((Object)false);
        Mockito.when((Object)parent.querySelector("[data-type-field=\"arrow-button\"]")).thenReturn((Object)arrow);
        this.view.hideItemElementIfParentIsCollapsed(itemElement, parent);
        ((DOMTokenList)Mockito.verify((Object)itemElementClassList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testShowArrowIconIfDataTypeHasChildrenWhenDataTypeHasChildren() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        NodeList elementNodeList = new NodeList();
        Element dataTypeRow = (Element)Mockito.mock(Element.class);
        Element dataTypeRowArrow = (Element)Mockito.mock(Element.class);
        DOMTokenList arrowClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        String uuid = "uuid";
        dataTypeRowArrow.classList = arrowClassList;
        elementNodeList.length = 1;
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.listItems.querySelectorAll("[data-parent-row-uuid=\"uuid\"]")).thenReturn((Object)elementNodeList);
        Mockito.when((Object)this.listItems.querySelector("[data-row-uuid=\"uuid\"]")).thenReturn((Object)dataTypeRow);
        Mockito.when((Object)dataTypeRow.querySelector("[data-type-field=\"arrow-button\"]")).thenReturn((Object)dataTypeRowArrow);
        this.view.showArrowIconIfDataTypeHasChildren(dataType);
        ((DOMTokenList)Mockito.verify((Object)arrowClassList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testShowArrowIconIfDataTypeHasChildrenWhenDataTypeDoesNotHaveChildren() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        NodeList elementNodeList = new NodeList();
        Element dataTypeRow = (Element)Mockito.mock(Element.class);
        Element dataTypeRowArrow = (Element)Mockito.mock(Element.class);
        DOMTokenList arrowClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        String uuid = "uuid";
        dataTypeRowArrow.classList = arrowClassList;
        elementNodeList.length = 0;
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.listItems.querySelectorAll("[data-parent-row-uuid=\"uuid\"]")).thenReturn((Object)elementNodeList);
        Mockito.when((Object)this.listItems.querySelector("[data-row-uuid=\"uuid\"]")).thenReturn((Object)dataTypeRow);
        Mockito.when((Object)dataTypeRow.querySelector("[data-type-field=\"arrow-button\"]")).thenReturn((Object)dataTypeRowArrow);
        this.view.showArrowIconIfDataTypeHasChildren(dataType);
        ((DOMTokenList)Mockito.verify((Object)arrowClassList)).add(new String[]{"hidden"});
    }

    @Test
    public void testRemoveItem() {
        String uuid = "uuid";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Node parentNode = (Node)Mockito.mock(Node.class);
        Element dataTypeElement = this.makeElement("uuid");
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        ((DataTypeListView)Mockito.doReturn((Object)dataTypeElement).when((Object)this.view)).getDataTypeRow(dataType);
        ((DataTypeListView)Mockito.doNothing().when((Object)this.view)).cleanSubTypes((String)Mockito.any());
        dataTypeElement.parentNode = parentNode;
        this.view.removeItem(dataType);
        ((DataTypeList)Mockito.verify((Object)this.presenter)).removeItem("uuid");
        ((DataTypeListView)Mockito.verify((Object)this.view)).cleanSubTypes("uuid");
        ((Node)Mockito.verify((Object)parentNode)).removeChild((Node)dataTypeElement);
        ((DataTypeListView)Mockito.verify((Object)this.view)).showOrHideNoCustomItemsMessage();
    }

    @Test
    public void testInsertBelow() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        HTMLElement listItemElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element lastElement = (Element)Mockito.spy((Object)new Element());
        Element parentElement = (Element)Mockito.mock(Element.class);
        Element siblingElement = (Element)Mockito.mock(Element.class);
        lastElement.parentNode = parentElement;
        lastElement.nextSibling = siblingElement;
        Mockito.when((Object)listItem.getDragAndDropElement()).thenReturn((Object)listItemElement);
        ((DataTypeListView)Mockito.doReturn((Object)lastElement).when((Object)this.view)).getLastSubDataTypeElement(reference);
        this.view.insertBelow(listItem, reference);
        ((Element)Mockito.verify((Object)parentElement)).insertBefore((Node)listItemElement, (Node)siblingElement);
        ((DataTypeListView)Mockito.verify((Object)this.view)).setNewElementYPosition(lastElement, (Element)listItemElement);
    }

    @Test
    public void testInsertAbove() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        HTMLElement listItemElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element element = (Element)Mockito.spy((Object)new Element());
        Element parentElement = (Element)Mockito.mock(Element.class);
        element.parentNode = parentElement;
        Mockito.when((Object)listItem.getDragAndDropElement()).thenReturn((Object)listItemElement);
        ((DataTypeListView)Mockito.doReturn((Object)element).when((Object)this.view)).getDataTypeRow(reference);
        this.view.insertAbove(listItem, reference);
        ((Element)Mockito.verify((Object)parentElement)).insertBefore((Node)listItemElement, (Node)element);
        ((DataTypeListView)Mockito.verify((Object)this.view)).setNewElementYPosition(element, (Element)listItemElement);
    }

    @Test
    public void testGetLastSubDataTypeElementWithElement() {
        String parentUUID = "parentUUID";
        Element parentElement = this.makeElement("parentUUID");
        NodeList children = (NodeList)Mockito.spy((Object)new NodeList());
        Element child1 = this.makeElement("uuid1");
        Element child2 = this.makeElement("uuid2");
        Element child3 = this.makeElement("uuid3");
        child1.parentNode = parentElement;
        child2.parentNode = parentElement;
        Mockito.when((Object)this.dndListComponent.getPositionY(child1)).thenReturn((Object)0);
        Mockito.when((Object)this.dndListComponent.getPositionY(child2)).thenReturn((Object)0);
        Mockito.when((Object)this.dndListComponent.getPositionY(child3)).thenReturn((Object)-1);
        ((NodeList)Mockito.doReturn((Object)child1).when((Object)children)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)child2).when((Object)children)).getAt(1);
        ((NodeList)Mockito.doReturn((Object)child3).when((Object)children)).getAt(2);
        children.length = 3;
        this.mockDOMElementsByParentUUID("parentUUID", (NodeList<Element>)children);
        Element lastElement = this.view.getLastSubDataTypeElement(parentElement);
        Assert.assertEquals((Object)child2, (Object)lastElement);
    }

    @Test
    public void testGetLastSubDataTypeElementWithDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Element element = (Element)Mockito.mock(Element.class);
        Element expectedElement = (Element)Mockito.mock(Element.class);
        ((DataTypeListView)Mockito.doReturn((Object)element).when((Object)this.view)).getDataTypeRow(dataType);
        ((DataTypeListView)Mockito.doReturn((Object)expectedElement).when((Object)this.view)).getLastSubDataTypeElement(element);
        Element actualElement = this.view.getLastSubDataTypeElement(dataType);
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testShowReadOnlyMessageWhenShowIsTrue() {
        this.readOnlyMessage.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showReadOnlyMessage(true);
        ((DOMTokenList)Mockito.verify((Object)this.readOnlyMessage.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testShowReadOnlyMessageWhenShowIsFalse() {
        this.readOnlyMessage.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showReadOnlyMessage(false);
        ((DOMTokenList)Mockito.verify((Object)this.readOnlyMessage.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testImportDataObjectsWhenListIsEmpty() {
        List imported = (List)Mockito.mock(List.class);
        Mockito.when((Object)imported.isEmpty()).thenReturn((Object)true);
        this.view.importDataObjects(imported);
        ((DataTypeList)Mockito.verify((Object)this.presenter)).importDataObjects(imported);
    }

    @Test
    public void testImportDataObjectsWhenListIsNotEmpty() {
        List imported = (List)Mockito.mock(List.class);
        ((DataTypeListView)Mockito.doNothing().when((Object)this.view)).fireSuccessfullyImportedData();
        Mockito.when((Object)imported.isEmpty()).thenReturn((Object)false);
        this.view.importDataObjects(imported);
        ((DataTypeList)Mockito.verify((Object)this.presenter)).importDataObjects(imported);
        ((DataTypeListView)Mockito.verify((Object)this.view)).fireSuccessfullyImportedData();
    }

    @Test
    public void testFireSuccessfullyImportedData() {
        String translated = "translated";
        Mockito.when((Object)this.translationService.getTranslation("DataTypeSuccessfullyImportedMessage.RegularMessage")).thenReturn((Object)"translated");
        this.view.fireSuccessfullyImportedData();
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)((FlashMessage)this.flashMessageCaptor.capture()));
        FlashMessage flashMessage = (FlashMessage)this.flashMessageCaptor.getValue();
        Assert.assertEquals((Object)FlashMessage.Type.SUCCESS, (Object)flashMessage.getType());
        Assert.assertEquals((Object)"translated", (Object)flashMessage.getStrongMessage());
        Assert.assertEquals((Object)"", (Object)flashMessage.getRegularMessage());
    }

    @Test
    public void testSetNewElementYPosition() {
        HTMLElement elementReference = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement newElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dndListComponent.getPositionY((Element)elementReference)).thenReturn((Object)1);
        this.view.setNewElementYPosition((Element)elementReference, (Element)newElement);
        ((DNDListComponent)Mockito.verify((Object)this.dndListComponent)).setPositionY((Element)newElement, 1.0);
    }

    @Test
    public void testShowImportDataObjectButton() {
        DOMTokenList classList;
        this.importDataObjectButton.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showImportDataObjectButton();
        ((DOMTokenList)Mockito.verify((Object)classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideImportDataObjectButton() {
        DOMTokenList classList;
        this.importDataObjectButton.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideImportDataObjectButton();
        ((DOMTokenList)Mockito.verify((Object)classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testOnImportDataObjectClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        List list = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.presenter.getExistingDataTypesNames()).thenReturn((Object)list);
        this.view.onImportDataObjectClick(event);
        ((ImportDataObjectModal)Mockito.verify((Object)this.importDataObjectModal)).show(list);
    }

    private HTMLElement makeHTMLElement() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.parentNode = (Node)Mockito.mock(Node.class);
        element.nextSibling = (Node)Mockito.mock(Node.class);
        return element;
    }

    public Element makeElement(String uuid) {
        Element element = (Element)Mockito.mock(Element.class);
        this.mockDOMElementsByParentUUID(uuid, (NodeList<Element>)new NodeList());
        Mockito.when((Object)element.getAttribute("data-row-uuid")).thenReturn((Object)uuid);
        return element;
    }

    private void mockDOMElementsByParentUUID(String parentUUID, NodeList<Element> rowElements) {
        Mockito.when((Object)this.listItems.querySelectorAll("[data-parent-row-uuid=\"" + parentUUID + "\"]")).thenReturn(rowElements);
    }
}

