/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import java.util.function.BiConsumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintParserWarningEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DataTypeConstraintEnumeration;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.expression.DataTypeConstraintExpression;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range.DataTypeConstraintRange;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeShortcuts;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintModalTest {
    @Mock
    private DataTypeConstraintModal.View view;
    @Mock
    private DataTypeShortcuts dataTypeShortcuts;
    @Mock
    private DataTypeConstraintEnumeration constraintEnumeration;
    @Mock
    private DataTypeConstraintExpression constraintExpression;
    @Mock
    private DataTypeConstraintRange constraintRange;
    @Mock
    private Element element;
    private DataTypeConstraintModal modal;

    @Before
    public void setup() {
        this.modal = (DataTypeConstraintModal)Mockito.spy((Object)new DataTypeConstraintModal(this.view, this.dataTypeShortcuts, this.constraintEnumeration, this.constraintExpression, this.constraintRange));
    }

    @Test
    public void testSetup() {
        ((DataTypeConstraintModal)Mockito.doNothing().when((Object)this.modal)).superSetup();
        ((DataTypeConstraintModal)Mockito.doNothing().when((Object)this.modal)).setWidth("550px");
        this.modal.setup();
        ((DataTypeConstraintRange)Mockito.verify((Object)this.constraintRange)).setModal(this.modal);
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).superSetup();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).setWidth("550px");
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).init((Object)this.modal);
    }

    @Test
    public void testSave() {
        DataTypeConstraintComponent constrainComponent = (DataTypeConstraintComponent)Mockito.mock(DataTypeConstraintComponent.class);
        String value = "value";
        ((DataTypeConstraintModal)Mockito.doNothing().when((Object)this.modal)).doSave((String)Mockito.any());
        ((DataTypeConstraintModal)Mockito.doReturn((Object)constrainComponent).when((Object)this.modal)).getCurrentComponent();
        Mockito.when((Object)constrainComponent.getValue()).thenReturn((Object)"value");
        this.modal.save();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).doSave("value");
    }

    @Test
    public void testClearAll() {
        ((DataTypeConstraintModal)Mockito.doNothing().when((Object)this.modal)).doSave((String)Mockito.any());
        this.modal.clearAll();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).doSave("");
    }

    @Test
    public void testDoSave() {
        String expectedConstraint = "1,2,3";
        ConstraintType expectedConstraintType = ConstraintType.ENUMERATION;
        BiConsumer onSave = (BiConsumer)Mockito.mock(BiConsumer.class);
        ((DataTypeConstraintModal)Mockito.doNothing().when((Object)this.modal)).hide();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)onSave).when((Object)this.modal)).getOnSave();
        this.modal.setConstraintType(expectedConstraintType);
        this.modal.doSave("1,2,3");
        String actualConstraint = this.modal.getConstraintValue();
        Assert.assertEquals((Object)"1,2,3", (Object)actualConstraint);
        ((BiConsumer)Mockito.verify((Object)onSave)).accept("1,2,3", expectedConstraintType);
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).hide();
    }

    @Test
    public void testLoadWhenConstraintTypeIsNone() {
        String expectedConstraintValueType = "string";
        String expectedConstraintValue = "1,2,3";
        ConstraintType expectedConstraintType = ConstraintType.RANGE;
        ((DataTypeConstraintModal)Mockito.doReturn((Object)expectedConstraintType).when((Object)this.modal)).inferComponentType("1,2,3");
        this.modal.load("string", "1,2,3", ConstraintType.NONE);
        String actualConstraintValueType = this.modal.getConstraintValueType();
        String actualConstraintValue = this.modal.getConstraintValue();
        ConstraintType actualConstraintType = this.modal.getConstraintType();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).prepareView();
        Assert.assertEquals((Object)"string", (Object)actualConstraintValueType);
        Assert.assertEquals((Object)"1,2,3", (Object)actualConstraintValue);
        Assert.assertEquals((Object)expectedConstraintType, (Object)actualConstraintType);
    }

    @Test
    public void testLoadWhenConstraintTypeIsNotNone() {
        String expectedConstraintValueType = "string";
        String expectedConstraintValue = "1,2,3";
        ConstraintType expectedConstraintType = ConstraintType.ENUMERATION;
        this.modal.load("string", "1,2,3", expectedConstraintType);
        String actualConstraintValueType = this.modal.getConstraintValueType();
        String actualConstraintValue = this.modal.getConstraintValue();
        ConstraintType actualConstraintType = this.modal.getConstraintType();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).prepareView();
        Assert.assertEquals((Object)"string", (Object)actualConstraintValueType);
        Assert.assertEquals((Object)"1,2,3", (Object)actualConstraintValue);
        Assert.assertEquals((Object)expectedConstraintType, (Object)actualConstraintType);
    }

    @Test
    public void testPrepareView() {
        String type = "string";
        String constraint = "1,2,3";
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"string").when((Object)this.modal)).getConstraintValueType();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)ConstraintType.ENUMERATION).when((Object)this.modal)).getConstraintType();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"1,2,3").when((Object)this.modal)).getConstraintValue();
        this.modal.prepareView();
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).setType("string");
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).loadComponent(ConstraintType.ENUMERATION);
    }

    @Test
    public void testPrepareViewWhenConstraintValueIsBlank() {
        String type = "string";
        String constraint = "";
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"string").when((Object)this.modal)).getConstraintValueType();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"").when((Object)this.modal)).getConstraintValue();
        this.modal.prepareView();
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).setType("string");
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).setupEmptyContainer();
    }

    @Test
    public void testSetupComponentWhenConstraintTypeIsExpression() {
        ConstraintType type = ConstraintType.EXPRESSION;
        String constraint = "expression";
        String constraintValueType = "string";
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"expression").when((Object)this.modal)).getConstraintValue();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"string").when((Object)this.modal)).getConstraintValueType();
        Mockito.when((Object)this.constraintExpression.getElement()).thenReturn((Object)this.element);
        this.modal.setupComponent(type);
        Assert.assertEquals((Object)this.constraintExpression, (Object)this.modal.getCurrentComponent());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.constraintExpression});
        ((DataTypeConstraintExpression)inOrder.verify((Object)this.constraintExpression)).setConstraintValueType("string");
        ((DataTypeConstraintExpression)inOrder.verify((Object)this.constraintExpression)).setValue("expression");
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).enableOkButton();
        ((Element)Mockito.verify((Object)this.element)).setAttribute("class", "kie-string");
    }

    @Test
    public void testSetupComponentWhenConstraintTypeIsRange() {
        ConstraintType type = ConstraintType.RANGE;
        String constraint = "(1..2)";
        String constraintValueType = "number";
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"(1..2)").when((Object)this.modal)).getConstraintValue();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"number").when((Object)this.modal)).getConstraintValueType();
        Mockito.when((Object)this.constraintRange.getElement()).thenReturn((Object)this.element);
        this.modal.setupComponent(type);
        Assert.assertEquals((Object)this.constraintRange, (Object)this.modal.getCurrentComponent());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.constraintRange});
        ((DataTypeConstraintRange)inOrder.verify((Object)this.constraintRange)).setConstraintValueType("number");
        ((DataTypeConstraintRange)inOrder.verify((Object)this.constraintRange)).setValue("(1..2)");
        ((Element)Mockito.verify((Object)this.element)).setAttribute("class", "kie-number");
    }

    @Test
    public void testSetupComponentWhenConstraintTypeIsRangeAndValueIsEmpty() {
        ConstraintType type = ConstraintType.RANGE;
        String constraint = "";
        String constraintValueType = "number";
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"").when((Object)this.modal)).getConstraintValue();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"number").when((Object)this.modal)).getConstraintValueType();
        Mockito.when((Object)this.constraintRange.getElement()).thenReturn((Object)this.element);
        this.modal.setupComponent(type);
        Assert.assertEquals((Object)this.constraintRange, (Object)this.modal.getCurrentComponent());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.constraintRange});
        ((DataTypeConstraintRange)inOrder.verify((Object)this.constraintRange)).setConstraintValueType("number");
        ((DataTypeConstraintRange)inOrder.verify((Object)this.constraintRange)).setValue("");
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal, (VerificationMode)Mockito.never())).enableOkButton();
        ((Element)Mockito.verify((Object)this.element)).setAttribute("class", "kie-number");
    }

    @Test
    public void testSetupComponentWhenConstraintTypeIsNone() {
        ConstraintType type = ConstraintType.NONE;
        String constraint = "(1..2)";
        String constraintValueType = "number";
        ((DataTypeConstraintModal)Mockito.doReturn((Object)ConstraintType.ENUMERATION).when((Object)this.modal)).inferComponentType("(1..2)");
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"(1..2)").when((Object)this.modal)).getConstraintValue();
        ((DataTypeConstraintModal)Mockito.doReturn((Object)"number").when((Object)this.modal)).getConstraintValueType();
        Mockito.when((Object)this.constraintEnumeration.getElement()).thenReturn((Object)this.element);
        this.modal.setupComponent(type);
        Assert.assertEquals((Object)this.constraintEnumeration, (Object)this.modal.getCurrentComponent());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.constraintEnumeration});
        ((DataTypeConstraintEnumeration)inOrder.verify((Object)this.constraintEnumeration)).setConstraintValueType("number");
        ((DataTypeConstraintEnumeration)inOrder.verify((Object)this.constraintEnumeration)).setValue("(1..2)");
        ((Element)Mockito.verify((Object)this.element)).setAttribute("class", "kie-number");
    }

    @Test
    public void testIsNoneWhenConstraintTypeIsENUMERATION() {
        Assert.assertFalse((boolean)this.modal.isNone(ConstraintType.ENUMERATION));
    }

    @Test
    public void testIsNoneWhenConstraintTypeIsNONE() {
        Assert.assertTrue((boolean)this.modal.isNone(ConstraintType.NONE));
    }

    @Test
    public void testIsNoneWhenConstraintTypeIsNull() {
        Assert.assertTrue((boolean)this.modal.isNone(null));
    }

    @Test
    public void testInferComponentTypeWhenItReturnsRange() {
        ConstraintType expectedType = ConstraintType.RANGE;
        ConstraintType actualType = this.modal.inferComponentType("(1..3]");
        Assert.assertEquals((Object)expectedType, (Object)actualType);
    }

    @Test
    public void testInferComponentTypeWhenItReturnsEnumeration() {
        ConstraintType expectedType = ConstraintType.ENUMERATION;
        ConstraintType actualType = this.modal.inferComponentType("1,2,3");
        Assert.assertEquals((Object)expectedType, (Object)actualType);
    }

    @Test
    public void testInferComponentTypeWhenItReturnsExpression() {
        ConstraintType expectedType = ConstraintType.EXPRESSION;
        ConstraintType actualType = this.modal.inferComponentType("expression");
        Assert.assertEquals((Object)expectedType, (Object)actualType);
    }

    @Test
    public void testShow() {
        BiConsumer<String, ConstraintType> expectedOnSave = (s, c) -> {};
        ArgumentCaptor onHide = ArgumentCaptor.forClass(Command.class);
        ((DataTypeConstraintModal)Mockito.doNothing().when((Object)this.modal)).superShow();
        this.modal.show(expectedOnSave);
        BiConsumer actualOnSave = this.modal.getOnSave();
        Assert.assertEquals(expectedOnSave, (Object)actualOnSave);
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).superShow();
        ((DataTypeShortcuts)Mockito.verify((Object)this.dataTypeShortcuts)).disable();
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).onShow();
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).setupOnHideHandler((Command)onHide.capture());
        ((Command)onHide.getValue()).execute();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).onHide();
    }

    @Test
    public void testHide() {
        ((DataTypeConstraintModal)Mockito.doNothing().when((Object)this.modal)).superHide();
        this.modal.hide();
        ((DataTypeConstraintModal)Mockito.verify((Object)this.modal)).superHide();
        ((DataTypeShortcuts)Mockito.verify((Object)this.dataTypeShortcuts)).enable();
    }

    @Test
    public void testOnDataTypeConstraintParserWarningEvent() {
        this.modal.onDataTypeConstraintParserWarningEvent((DataTypeConstraintParserWarningEvent)Mockito.mock(DataTypeConstraintParserWarningEvent.class));
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).showConstraintWarningMessage();
    }

    @Test
    public void testEnableOkButton() {
        this.modal.enableOkButton();
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).enableOkButton();
    }

    @Test
    public void testDisableOkButton() {
        this.modal.disableOkButton();
        ((DataTypeConstraintModal.View)Mockito.verify((Object)this.view)).disableOkButton();
    }
}

