/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.ConstraintPlaceholderHelper;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConstraintPlaceholderHelperTest {
    @Mock
    private TranslationService translationService;
    private ConstraintPlaceholderHelper placeholderHelper;

    @Before
    public void setup() {
        this.placeholderHelper = new ConstraintPlaceholderHelper(this.translationService);
    }

    @Test
    public void testGetPlaceholderSentenceWhenTypeIsBuiltInTypeWithDefinedSentence() {
        String expectedPlaceholder = "Example expression for a \"number\" data type: (1..10)";
        Mockito.when((Object)this.translationService.getTranslation("ConstraintPlaceholderHelper.SentenceNumber")).thenReturn((Object)"Example expression for a \"number\" data type: (1..10)");
        String actualPlaceholder = this.placeholderHelper.getPlaceholderSentence("number");
        Assert.assertEquals((Object)"Example expression for a \"number\" data type: (1..10)", (Object)actualPlaceholder);
    }

    @Test
    public void testGetPlaceholderSentenceWhenTypeIsBuiltInTypeWithoutDefinedSentence() {
        String expectedPlaceholder = "Enter a valid expression";
        Mockito.when((Object)this.translationService.format("ConstraintPlaceholderHelper.SentenceDefault", new Object[0])).thenReturn((Object)"Enter a valid expression");
        String actualPlaceholder = this.placeholderHelper.getPlaceholderSentence("context");
        Assert.assertEquals((Object)"Enter a valid expression", (Object)actualPlaceholder);
    }

    @Test
    public void testGetPlaceholderSentenceWhenTypeIsNotBuiltInType() {
        String expectedPlaceholder = "Enter a valid expression";
        Mockito.when((Object)this.translationService.format("ConstraintPlaceholderHelper.SentenceDefault", new Object[0])).thenReturn((Object)"Enter a valid expression");
        String actualPlaceholder = this.placeholderHelper.getPlaceholderSentence("Structure");
        Assert.assertEquals((Object)"Enter a valid expression", (Object)actualPlaceholder);
    }

    @Test
    public void testGetPlaceholderSampleWhenTypeIsBuiltInTypeWithDefinedSample() {
        String expectedPlaceholder = "123";
        Mockito.when((Object)this.translationService.getTranslation("ConstraintPlaceholderHelper.SampleNumber")).thenReturn((Object)"123");
        String actualPlaceholder = this.placeholderHelper.getPlaceholderSample("number");
        Assert.assertEquals((Object)"123", (Object)actualPlaceholder);
    }

    @Test
    public void testGetPlaceholderSampleWhenTypeIsBuiltInTypeWithoutDefinedSample() {
        String expectedPlaceholder = "Insert a value";
        Mockito.when((Object)this.translationService.format("ConstraintPlaceholderHelper.SampleDefault", new Object[0])).thenReturn((Object)"Insert a value");
        String actualPlaceholder = this.placeholderHelper.getPlaceholderSample("context");
        Assert.assertEquals((Object)"Insert a value", (Object)actualPlaceholder);
    }

    @Test
    public void testGetPlaceholderSampleWhenTypeIsNotBuiltInType() {
        String expectedPlaceholder = "Insert a value";
        Mockito.when((Object)this.translationService.format("ConstraintPlaceholderHelper.SampleDefault", new Object[0])).thenReturn((Object)"Insert a value");
        String actualPlaceholder = this.placeholderHelper.getPlaceholderSample("Structure");
        Assert.assertEquals((Object)"Insert a value", (Object)actualPlaceholder);
    }
}

