/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLElement;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateValueFormatter;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DateSelectorTest {
    @Mock
    private DateSelector.View view;
    @Mock
    private DateValueFormatter valueFormatter;
    @Mock
    private Consumer<Event> onValueChanged;
    @Mock
    private Consumer<BlurEvent> onValueInputBlur;
    private DateSelector dateSelector;

    @Before
    public void setup() {
        this.dateSelector = (DateSelector)Mockito.spy((Object)new DateSelector(this.view, this.valueFormatter));
    }

    @Test
    public void testGetValue() {
        String expectedValue = "value";
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"value");
        String actualValue = this.dateSelector.getValue();
        Assert.assertEquals((Object)"value", (Object)actualValue);
    }

    @Test
    public void testSetValue() {
        String value = "value";
        this.dateSelector.setValue("value");
        ((DateSelector.View)Mockito.verify((Object)this.view)).setValue("value");
    }

    @Test
    public void testSetPlaceholder() {
        String placeholder = "placeholder";
        this.dateSelector.setPlaceholder("placeholder");
        ((DateSelector.View)Mockito.verify((Object)this.view)).setPlaceholder("placeholder");
    }

    @Test
    public void testGetElement() {
        HTMLElement expected = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expected);
        Element actual = this.dateSelector.getElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSetOnInputChangeCallback() {
        this.dateSelector.setOnInputChangeCallback(this.onValueChanged);
        ((DateSelector.View)Mockito.verify((Object)this.view)).onValueChanged(this.onValueChanged);
    }

    @Test
    public void testSetOnInputBlurCallback() {
        this.dateSelector.setOnInputBlurCallback(this.onValueInputBlur);
        ((DateSelector.View)Mockito.verify((Object)this.view)).onValueInputBlur(this.onValueInputBlur);
    }

    @Test
    public void testSelect() {
        this.dateSelector.select();
        ((DateSelector.View)Mockito.verify((Object)this.view)).select();
    }

    @Test
    public void testIsChildren() {
        Object object = Mockito.mock(Object.class);
        this.dateSelector.isChild(object);
        ((DateSelector.View)Mockito.verify((Object)this.view)).isChildOfView(object);
    }
}

