/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.string;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.BaseSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.string.StringSelector;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class StringSelectorTest {
    @Mock
    private BaseSelector.View view;
    private StringSelector stringSelector;

    @Before
    public void setup() {
        this.stringSelector = new StringSelector(this.view);
    }

    @Test
    public void testSetValue() {
        this.stringSelector.setValue("\"value\"");
        ((BaseSelector.View)Mockito.verify((Object)this.view)).setValue("value");
    }

    @Test
    public void testGetValueWithRawValue() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"value");
        String expected = "\"value\"";
        String actual = this.stringSelector.getValue();
        Assert.assertEquals((Object)"\"value\"", (Object)actual);
    }

    @Test
    public void testGetValueWithQuotedValue() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"\"value\"");
        String expected = "\"value\"";
        String actual = this.stringSelector.getValue();
        Assert.assertEquals((Object)"\"value\"", (Object)actual);
    }

    @Test
    public void testGetValueWithBlankValue() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"");
        String expected = "";
        String actual = this.stringSelector.getValue();
        Assert.assertEquals((Object)"", (Object)actual);
    }
}

