/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValueFormatter;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeZoneProvider;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class TimeValueFormatterTest {
    @Mock
    private TimeZoneProvider provider;
    private TimeValueFormatter formatter;

    @Before
    public void setup() {
        this.formatter = new TimeValueFormatter(this.provider);
    }

    @Test
    public void testToRawSimpleTime() {
        String expected = "time(\"22:30:10\")";
        String input = "22:30:10";
        String actual = this.formatter.toRaw("22:30:10");
        Assert.assertEquals((Object)"time(\"22:30:10\")", (Object)actual);
    }

    @Test
    public void testToRawTimeWithNegativeTimeOffSet() {
        String expected = "time(\"22:30:10-03:00\")";
        String input = "22:30:10 UTC -03:00";
        String actual = this.formatter.toRaw("22:30:10 UTC -03:00");
        Assert.assertEquals((Object)"time(\"22:30:10-03:00\")", (Object)actual);
    }

    @Test
    public void testToRawTimeWithPositiveTimeOffSet() {
        String expected = "time(\"22:30:10+03:00\")";
        String input = "22:30:10 UTC +03:00";
        String actual = this.formatter.toRaw("22:30:10 UTC +03:00");
        Assert.assertEquals((Object)"time(\"22:30:10+03:00\")", (Object)actual);
    }

    @Test
    public void testToRawTimeWithUTCTimeZone() {
        Mockito.when((Object)this.provider.isTimeZone("UTC")).thenReturn((Object)false);
        String expected = "time(\"22:30:10Z\")";
        String input = "22:30:10 UTC";
        String actual = this.formatter.toRaw("22:30:10 UTC");
        Assert.assertEquals((Object)"time(\"22:30:10Z\")", (Object)actual);
    }

    @Test
    public void testToRawTimeWithTimeZone() {
        Mockito.when((Object)this.provider.isTimeZone("America/Sao_Paulo")).thenReturn((Object)true);
        String expected = "time(\"22:30:10@America/Sao_Paulo\")";
        String input = "22:30:10 America/Sao_Paulo";
        String actual = this.formatter.toRaw("22:30:10 America/Sao_Paulo");
        Assert.assertEquals((Object)"time(\"22:30:10@America/Sao_Paulo\")", (Object)actual);
    }

    @Test
    public void testToRawTimeWithTimeZoneWithDash() {
        Mockito.when((Object)this.provider.isTimeZone((String)ArgumentMatchers.any())).thenReturn((Object)true);
        String expected = "time(\"22:30:10@US/Pacific-New\")";
        String input = "22:30:10 US/Pacific-New";
        String actual = this.formatter.toRaw("22:30:10 US/Pacific-New");
        Assert.assertEquals((Object)"time(\"22:30:10@US/Pacific-New\")", (Object)actual);
    }

    @Test
    public void testToDisplaySimpleTime() {
        String input = "time(\"22:30:10\")";
        String expected = "22:30:10";
        String actual = this.formatter.toDisplay("time(\"22:30:10\")");
        Assert.assertEquals((Object)"22:30:10", (Object)actual);
    }

    @Test
    public void testToDisplayTimeWithNegativeTimeOffSet() {
        String input = "time(\"22:30:10-03:00\")";
        String expected = "22:30:10 UTC -03:00";
        String actual = this.formatter.toDisplay("time(\"22:30:10-03:00\")");
        Assert.assertEquals((Object)"22:30:10 UTC -03:00", (Object)actual);
    }

    @Test
    public void testToDisplayTimeWithPositiveTimeOffSet() {
        String input = "time(\"22:30:10+03:00\")";
        String expected = "22:30:10 UTC +03:00";
        String actual = this.formatter.toDisplay("time(\"22:30:10+03:00\")");
        Assert.assertEquals((Object)"22:30:10 UTC +03:00", (Object)actual);
    }

    @Test
    public void testToDisplayTimeWithUTCTimeOffSet() {
        String input = "time(\"22:30:10Z\")";
        String expected = "22:30:10 UTC";
        String actual = this.formatter.toDisplay("time(\"22:30:10Z\")");
        Assert.assertEquals((Object)"22:30:10 UTC", (Object)actual);
    }

    @Test
    public void testToDisplayTimeWithTimeZone1() {
        String input = "time(\"22:30:10@America/Sao_Paulo\")";
        String expected = "22:30:10 America/Sao_Paulo";
        String actual = this.formatter.toDisplay("time(\"22:30:10@America/Sao_Paulo\")");
        Assert.assertEquals((Object)"22:30:10 America/Sao_Paulo", (Object)actual);
    }

    @Test
    public void testToDisplayTimeWithTimeZoneWithDash() {
        String input = "time(\"22:30:10@Etc/GMT-0\")";
        String expected = "22:30:10 Etc/GMT-0";
        String actual = this.formatter.toDisplay("time(\"22:30:10@Etc/GMT-0\")");
        Assert.assertEquals((Object)"22:30:10 Etc/GMT-0", (Object)actual);
    }
}

