/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.ConstraintPlaceholderHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DataTypeConstraintEnumeration;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item.DataTypeConstraintEnumerationItem;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintEnumerationItemTest {
    @Mock
    private DataTypeConstraintEnumerationItem.View view;
    @Mock
    private ConstraintPlaceholderHelper placeholderHelper;
    @Mock
    private DataTypeConstraintEnumeration dataTypeConstraintEnumeration;
    private DataTypeConstraintEnumerationItem enumerationItem;

    @Before
    public void setup() {
        this.enumerationItem = (DataTypeConstraintEnumerationItem)Mockito.spy((Object)new DataTypeConstraintEnumerationItem(this.view, this.placeholderHelper));
        this.enumerationItem.setDataTypeConstraintEnumeration(this.dataTypeConstraintEnumeration);
    }

    @Test
    public void testSetup() {
        this.enumerationItem.setup();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).init((Object)this.enumerationItem);
    }

    @Test
    public void testSetValue() {
        String value = "123";
        this.enumerationItem.setValue("123");
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).setValue("123");
        Assert.assertEquals((Object)"123", (Object)this.enumerationItem.getValue());
    }

    @Test
    public void testSetValueWhenValueIsEmpty() {
        String value = "";
        this.enumerationItem.setValue("");
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).setValue("null");
        Assert.assertEquals((Object)"null", (Object)this.enumerationItem.getValue());
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        Element actualElement = this.enumerationItem.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testEnableEditMode() {
        String value = "123";
        ((DataTypeConstraintEnumerationItem)Mockito.doReturn((Object)"123").when((Object)this.enumerationItem)).getValue();
        this.enumerationItem.enableEditMode();
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.enumerationItem)).setOldValue("123");
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).showValueInput();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).focusValueInput();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).enableHighlight();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).showSaveButton();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).showClearButton();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).hideDeleteButton();
    }

    @Test
    public void testDiscardEditMode() {
        String value = "123";
        ((DataTypeConstraintEnumerationItem)Mockito.doReturn((Object)"123").when((Object)this.enumerationItem)).getOldValue();
        this.enumerationItem.discardEditMode();
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.enumerationItem)).setValue("123");
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.enumerationItem)).disableEditMode();
    }

    @Test
    public void testDisableEditMode() {
        this.enumerationItem.disableEditMode();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).showValueText();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).disableHighlight();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).hideSaveButton();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).hideClearButton();
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).showDeleteButton();
    }

    @Test
    public void testSave() {
        String value = "123";
        this.enumerationItem.save("123");
        String actual = this.enumerationItem.getValue();
        String expected = "123";
        Assert.assertEquals((Object)"123", (Object)actual);
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.enumerationItem)).disableEditMode();
    }

    @Test
    public void testSaveWhenTheValueIsBlank() {
        String value = "";
        this.enumerationItem.save("");
        String actual = this.enumerationItem.getValue();
        String expected = "null";
        Assert.assertEquals((Object)"null", (Object)actual);
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.enumerationItem)).disableEditMode();
    }

    @Test
    public void testGetScrollToThisItemCallback() {
        int order = 42;
        Mockito.when((Object)this.enumerationItem.getOrder()).thenReturn((Object)42);
        this.enumerationItem.getScrollToThisItemCallback().execute();
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.dataTypeConstraintEnumeration)).scrollToPosition(42);
    }

    @Test
    public void testRemove() {
        List enumerationItems = (List)Mockito.spy(new ArrayList());
        Mockito.when((Object)this.dataTypeConstraintEnumeration.getEnumerationItems()).thenReturn((Object)enumerationItems);
        this.enumerationItem.remove();
        ((List)Mockito.verify((Object)enumerationItems)).remove(this.enumerationItem);
        ((DataTypeConstraintEnumeration)Mockito.verify((Object)this.dataTypeConstraintEnumeration)).refreshView();
    }

    @Test
    public void testSetConstraintValueType() {
        String type = "string";
        String placeholder = "placeholder";
        Mockito.when((Object)this.placeholderHelper.getPlaceholderSample("string")).thenReturn((Object)"placeholder");
        this.enumerationItem.setConstraintValueType("string");
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).setPlaceholder("placeholder");
        ((DataTypeConstraintEnumerationItem.View)Mockito.verify((Object)this.view)).setComponentSelector("string");
    }

    @Test
    public void testGetOrder() {
        boolean expected = true;
        Mockito.when((Object)this.view.getOrder()).thenReturn((Object)1);
        int actual = this.enumerationItem.getOrder();
        Assert.assertEquals((long)1L, (long)actual);
    }
}

