/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.NodeList;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandler;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandlerContext;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandlerShiftStrategy;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DNDDataTypesHandlerContextTest {
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DNDListComponent dndListComponent;
    @Mock
    private DNDDataTypesHandler dndDataTypesHandler;
    @Mock
    private Element currentElement;
    @Mock
    private Element hoverElement;
    private DNDDataTypesHandlerContext context;

    @Before
    public void setup() {
        Mockito.when((Object)this.dndDataTypesHandler.getDataTypeStore()).thenReturn((Object)this.dataTypeStore);
        Mockito.when((Object)this.dndDataTypesHandler.getDndListComponent()).thenReturn((Object)this.dndListComponent);
        this.context = new DNDDataTypesHandlerContext(this.dndDataTypesHandler, this.currentElement, this.hoverElement);
    }

    @Test
    public void testGetReferenceWhenHoveredDataTypeIsPresent() {
        Optional<DataType> hoverDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        String uuid = "0000-1111-2222-3333";
        Mockito.when((Object)this.hoverElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)hoverDataType.get());
        Optional reference = this.context.getReference();
        Assert.assertEquals(hoverDataType, (Object)reference);
    }

    @Test
    public void testGetReferenceWhenHoveredDataTypeIsPresentButHoveredDataTypeIsReadOnly() {
        Element previousElement = (Element)Mockito.mock(Element.class);
        Optional<DataType> hoverDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        Optional<DataType> previousDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        String hoverUUID = "0000-0000-0000-0000";
        String previousUUID = "1111-1111-1111-1111";
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.dataTypeStore.get("1111-1111-1111-1111")).thenReturn((Object)previousDataType.get());
        Mockito.when((Object)this.dataTypeStore.get("0000-0000-0000-0000")).thenReturn((Object)hoverDataType.get());
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"1111-1111-1111-1111");
        Mockito.when((Object)this.hoverElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-0000-0000-0000");
        Mockito.when((Object)hoverDataType.get().isReadOnly()).thenReturn((Object)true);
        Optional reference = this.context.getReference();
        Assert.assertEquals(previousDataType, (Object)reference);
    }

    @Test
    public void testGetReferenceWhenPreviousDataTypeIsPresent() {
        Element previousElement = (Element)Mockito.mock(Element.class);
        Optional<DataType> previousDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        String uuid = "0000-1111-2222-3333";
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)previousDataType.get());
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        Optional reference = this.context.getReference();
        Assert.assertEquals(previousDataType, (Object)reference);
    }

    @Test
    public void testGetReferenceWhenCurrentDataTypeIsPresent() {
        Element firstElement = (Element)Mockito.mock(Element.class);
        Element hiddenElement = (Element)Mockito.mock(Element.class);
        Element wrongFirstElement = (Element)Mockito.mock(Element.class);
        HTMLElement dragArea = (HTMLElement)Mockito.mock(HTMLElement.class);
        Optional<DataType> currentDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        Optional<DataType> firstDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        String currentUUID = "0000-0000-0000-0000";
        String firstUUID = "1111-1111-1111-1111";
        dragArea.childNodes = (NodeList)Mockito.spy((Object)new NodeList());
        dragArea.childNodes.length = 4;
        this.currentElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        wrongFirstElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        firstElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((NodeList)Mockito.doReturn((Object)hiddenElement).when((Object)dragArea.childNodes)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)this.currentElement).when((Object)dragArea.childNodes)).getAt(1);
        ((NodeList)Mockito.doReturn((Object)wrongFirstElement).when((Object)dragArea.childNodes)).getAt(2);
        ((NodeList)Mockito.doReturn((Object)firstElement).when((Object)dragArea.childNodes)).getAt(3);
        Mockito.when((Object)hiddenElement.getAttribute("data-y-position")).thenReturn((Object)"-1");
        Mockito.when((Object)this.currentElement.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)wrongFirstElement.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)firstElement.getAttribute("data-y-position")).thenReturn((Object)"2");
        Mockito.when((Object)hiddenElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)this.currentElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)wrongFirstElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)firstElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)this.dndListComponent.getDragArea()).thenReturn((Object)dragArea);
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.dataTypeStore.get("0000-0000-0000-0000")).thenReturn((Object)currentDataType.get());
        Mockito.when((Object)this.dataTypeStore.get("1111-1111-1111-1111")).thenReturn((Object)firstDataType.get());
        Mockito.when((Object)currentDataType.get().getName()).thenReturn((Object)"Current Data Type");
        Mockito.when((Object)firstDataType.get().getName()).thenReturn((Object)"First Data Type");
        Mockito.when((Object)this.currentElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-0000-0000-0000");
        Mockito.when((Object)firstElement.getAttribute("data-row-uuid")).thenReturn((Object)"1111-1111-1111-1111");
        Mockito.when((Object)wrongFirstElement.classList.contains("kie-dnd-current-dragging")).thenReturn((Object)true);
        Mockito.when((Object)firstElement.classList.contains("kie-dnd-current-dragging")).thenReturn((Object)false);
        DNDDataTypesHandlerContext context = new DNDDataTypesHandlerContext(this.dndDataTypesHandler, this.currentElement, this.hoverElement);
        Optional reference = context.getReference();
        Assert.assertEquals(firstDataType, (Object)reference);
    }

    @Test
    public void testGetReferenceWhenItIsNotPresent() {
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Assert.assertFalse((boolean)this.context.getReference().isPresent());
    }

    @Test
    public void testGetStrategyInsertIntoHoveredDataType() {
        Optional<DataType> hoverDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        String uuid = "0000-1111-2222-3333";
        Mockito.when((Object)this.hoverElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)hoverDataType.get());
        this.loadReferenceContext();
        DNDDataTypesHandlerShiftStrategy actualShiftStrategy = this.context.getStrategy();
        DNDDataTypesHandlerShiftStrategy expectedShiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_INTO_HOVERED_DATA_TYPE;
        Assert.assertEquals((Object)expectedShiftStrategy, (Object)actualShiftStrategy);
    }

    @Test
    public void testGetStrategyInsertIntoHoveredDataTypeWhenHoveredDataTypeIsReadOnly() {
        Optional<DataType> hoverDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        String uuid = "0000-1111-2222-3333";
        Mockito.when((Object)hoverDataType.get().isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.hoverElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)hoverDataType.get());
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.empty());
        this.loadReferenceContext();
        DNDDataTypesHandlerShiftStrategy actualShiftStrategy = this.context.getStrategy();
        DNDDataTypesHandlerShiftStrategy expectedShiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE_AT_THE_TOP;
        Assert.assertEquals((Object)expectedShiftStrategy, (Object)actualShiftStrategy);
    }

    @Test
    public void testGetStrategyInsertTopLevelDataTypeAtTheTop() {
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.empty());
        this.loadReferenceContext();
        DNDDataTypesHandlerShiftStrategy actualShiftStrategy = this.context.getStrategy();
        DNDDataTypesHandlerShiftStrategy expectedShiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE_AT_THE_TOP;
        Assert.assertEquals((Object)expectedShiftStrategy, (Object)actualShiftStrategy);
    }

    @Test
    public void testGetStrategyInsertTopLevelDataType() {
        Element previousElement = (Element)Mockito.mock(Element.class);
        String uuid = "0000-1111-2222-3333";
        Optional<DataType> previousDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)previousDataType.get());
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.currentElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)previousElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        this.loadReferenceContext();
        DNDDataTypesHandlerShiftStrategy actualShiftStrategy = this.context.getStrategy();
        DNDDataTypesHandlerShiftStrategy expectedShiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE;
        Assert.assertEquals((Object)expectedShiftStrategy, (Object)actualShiftStrategy);
    }

    @Test
    public void testGetStrategyInsertNestedDataType() {
        Element previousElement = (Element)Mockito.mock(Element.class);
        String uuid = "0000-1111-2222-3333";
        Optional<DataType> previousDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)previousDataType.get());
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.currentElement.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)previousElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        this.loadReferenceContext();
        DNDDataTypesHandlerShiftStrategy actualShiftStrategy = this.context.getStrategy();
        DNDDataTypesHandlerShiftStrategy expectedShiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_NESTED_DATA_TYPE;
        Assert.assertEquals((Object)expectedShiftStrategy, (Object)actualShiftStrategy);
    }

    @Test
    public void testGetStrategyInsertNestedDataTypeWhenPreviousDataTypeIsReadOnly() {
        Element previousElement = (Element)Mockito.mock(Element.class);
        String uuid = "0000-1111-2222-3333";
        Optional<DataType> previousDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)previousDataType.get().isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)previousDataType.get());
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.currentElement.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)previousElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        this.loadReferenceContext();
        DNDDataTypesHandlerShiftStrategy actualShiftStrategy = this.context.getStrategy();
        DNDDataTypesHandlerShiftStrategy expectedShiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_SIBLING_DATA_TYPE;
        Assert.assertEquals((Object)expectedShiftStrategy, (Object)actualShiftStrategy);
    }

    @Test
    public void testGetStrategyInsertSiblingDataType() {
        Element previousElement = (Element)Mockito.mock(Element.class);
        String uuid = "0000-1111-2222-3333";
        Optional<DataType> previousDataType = Optional.of((DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.dataTypeStore.get("0000-1111-2222-3333")).thenReturn((Object)previousDataType.get());
        Mockito.when((Object)this.dndListComponent.getPreviousElement((Element)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any())).thenReturn(Optional.of(previousElement));
        Mockito.when((Object)this.currentElement.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)previousElement.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)previousElement.getAttribute("data-row-uuid")).thenReturn((Object)"0000-1111-2222-3333");
        this.loadReferenceContext();
        DNDDataTypesHandlerShiftStrategy actualShiftStrategy = this.context.getStrategy();
        DNDDataTypesHandlerShiftStrategy expectedShiftStrategy = DNDDataTypesHandlerShiftStrategy.INSERT_SIBLING_DATA_TYPE;
        Assert.assertEquals((Object)expectedShiftStrategy, (Object)actualShiftStrategy);
    }

    private void loadReferenceContext() {
        this.context.getReference();
    }
}

