/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DNDListComponentTest {
    @Mock
    private DNDListComponent.View view;
    @Mock
    private DataTypeList dataTypeList;
    private DNDListComponent dndListComponent;

    @Before
    public void setup() {
        this.dndListComponent = (DNDListComponent)Mockito.spy((Object)new DNDListComponent(this.view, this.dataTypeList));
    }

    @Test
    public void testInit() {
        this.dndListComponent.init();
        ((DNDListComponent.View)Mockito.verify((Object)this.view)).init((Object)this.dndListComponent);
    }

    @Test
    public void testRefreshItemsPosition() {
        this.dndListComponent.refreshItemsPosition();
        ((DNDListComponent.View)Mockito.verify((Object)this.view)).refreshItemsPosition();
    }

    @Test
    public void testRefreshItemsCSSAndHTMLPosition() {
        this.dndListComponent.refreshItemsCSSAndHTMLPosition();
        ((DNDListComponent.View)Mockito.verify((Object)this.view)).consolidateHierarchicalLevel(false);
        ((DNDListComponent.View)Mockito.verify((Object)this.view)).refreshItemsPosition();
    }

    @Test
    public void testRegisterNewItem() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.registerItem(htmlElement)).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.dndListComponent.registerNewItem(htmlElement);
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.dndListComponent.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testClear() {
        this.dndListComponent.clear();
        ((DNDListComponent.View)Mockito.verify((Object)this.view)).clear();
    }

    @Test
    public void testConsolidateYPosition() {
        this.dndListComponent.consolidateYPosition();
        ((DNDListComponent.View)Mockito.verify((Object)this.view)).consolidateYPosition();
    }

    @Test
    public void testGetItemHeight() {
        Assert.assertEquals((long)DNDListComponent.DEFAULT_ITEM_HEIGHT, (long)this.dndListComponent.getItemHeight());
    }

    @Test
    public void testGetIndentationSize() {
        Assert.assertEquals((long)DNDListComponent.DEFAULT_INDENTATION_SIZE, (long)this.dndListComponent.getIndentationSize());
    }

    @Test
    public void testSetPositionX() {
        Element element = (Element)Mockito.mock(Element.class);
        boolean positionX = true;
        this.dndListComponent.setPositionX(element, 1.0);
        ((Element)Mockito.verify((Object)element)).setAttribute("data-x-position", 1.0);
    }

    @Test
    public void testSetPositionY() {
        Element element = (Element)Mockito.mock(Element.class);
        boolean positionY = true;
        this.dndListComponent.setPositionY(element, 1.0);
        ((Element)Mockito.verify((Object)element)).setAttribute("data-y-position", 1.0);
    }

    @Test
    public void testGetPositionY() {
        Element element = (Element)Mockito.mock(Element.class);
        boolean expectedPositionY = true;
        Mockito.when((Object)element.getAttribute("data-y-position")).thenReturn((Object)"1");
        int actualPositionY = this.dndListComponent.getPositionY(element);
        Assert.assertEquals((long)1L, (long)actualPositionY);
    }

    @Test
    public void testOnDropItem() {
        HTMLElement current = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement hover = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.dndListComponent.setOnDropItem((c, h) -> {
            Assert.assertEquals((Object)current, (Object)c);
            Assert.assertEquals((Object)hover, (Object)h);
        });
        this.dndListComponent.executeOnDropItemCallback((Element)current, (Element)hover);
    }

    @Test
    public void testGetPreviousElement() {
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getPreviousElement((Element)element0)).thenReturn(Optional.of(element1));
        Mockito.when((Object)this.view.getPreviousElement((Element)element1)).thenReturn(Optional.of(element2));
        Optional actual = this.dndListComponent.getPreviousElement((Element)element0, element -> element == element2);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)element2, actual.get());
    }

    @Test
    public void testGetPreviousElementWhenReferenceIsNull() {
        Assert.assertFalse((boolean)this.dndListComponent.getPreviousElement(null, null).isPresent());
    }

    @Test
    public void testRefreshDragAreaSize() {
        this.dndListComponent.refreshDragAreaSize();
        ((DNDListComponent.View)Mockito.verify((Object)this.view)).refreshDragAreaSize();
    }

    @Test
    public void testSetInitialPositionY() {
        HTMLElement dragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        String parentPosition = "4";
        HTMLElement child0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement child1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement child2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> children = Arrays.asList(child0, child1, child2);
        Mockito.when((Object)dragAndDropElement.getAttribute("data-y-position")).thenReturn((Object)"4");
        this.dndListComponent.setInitialPositionY(dragAndDropElement, children);
        ((HTMLElement)Mockito.verify((Object)child0)).setAttribute("data-y-position", 4.001);
        ((HTMLElement)Mockito.verify((Object)child1)).setAttribute("data-y-position", 4.002);
        ((HTMLElement)Mockito.verify((Object)child2)).setAttribute("data-y-position", 4.003);
    }

    @Test
    public void testSetInitialHiddenPositionY() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.dndListComponent.setInitialHiddenPositionY(element);
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("data-y-position", -1.0);
    }

    @Test
    public void testHighlightLevel() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.dndListComponent.highlightLevel(htmlElement);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel((Element)htmlElement);
    }
}

