/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.DOMRect;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.MouseEvent;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponentView;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListDOMHelper;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DNDListComponentViewTest {
    @Mock
    private HTMLDivElement dragArea;
    @Mock
    private DNDListComponent presenter;
    private DNDListComponentView view;

    @Before
    public void setup() {
        this.view = (DNDListComponentView)Mockito.spy((Object)new DNDListComponentView(this.dragArea));
        this.view.init(this.presenter);
    }

    @Test
    public void testInit() {
        ((DNDListComponentView)Mockito.verify((Object)this.view)).setupDragAreaHandlers();
    }

    @Test
    public void testRegisterItem() {
        HTMLElement expectedItem = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DNDListComponentView)Mockito.doReturn((Object)expectedItem).when((Object)this.view)).createItem(htmlElement);
        ((DNDListComponentView)Mockito.doReturn((Object)2).when((Object)this.view)).getMaxPositionY();
        HTMLElement actualItem = this.view.registerItem(htmlElement);
        ((HTMLElement)Mockito.verify((Object)actualItem)).setAttribute("data-y-position", 3.0);
        ((HTMLElement)Mockito.verify((Object)actualItem)).setAttribute("data-x-position", 0.0);
        ((HTMLDivElement)Mockito.verify((Object)this.dragArea)).appendChild((Node)actualItem);
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    @Test
    public void testGetMaxPositionY() {
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"2");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"4");
        Mockito.when((Object)element2.getAttribute("data-y-position")).thenReturn((Object)"8");
        this.mockDragAreaWithChildren(element0, element1, element2);
        int expectedMaxPosition = 8;
        int actualMaxPosition = this.view.getMaxPositionY();
        Assert.assertEquals((long)8L, (long)actualMaxPosition);
    }

    @Test
    public void testRefreshItemsPosition() {
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        element0.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element1.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element2.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)this.presenter.getIndentationSize()).thenReturn((Object)75);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)element2.getAttribute("data-y-position")).thenReturn((Object)"2");
        Mockito.when((Object)element0.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)element1.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)element2.getAttribute("data-x-position")).thenReturn((Object)"1");
        this.mockDragAreaWithChildren(element0, element1, element2);
        this.view.refreshItemsPosition();
        ((CSSStyleDeclaration)Mockito.verify((Object)element0.style)).setProperty("top", "0px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element1.style)).setProperty("top", "50px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element2.style)).setProperty("top", "100px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element0.style)).setProperty("padding-left", "0px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element1.style)).setProperty("padding-left", "75px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element2.style)).setProperty("padding-left", "75px");
        ((CSSStyleDeclaration)Mockito.verify((Object)element0.style)).setProperty("width", "calc(100% - 0px)");
        ((CSSStyleDeclaration)Mockito.verify((Object)element1.style)).setProperty("width", "calc(100% - 0px)");
        ((CSSStyleDeclaration)Mockito.verify((Object)element2.style)).setProperty("width", "calc(100% - 0px)");
        ((CSSStyleDeclaration)Mockito.verify((Object)this.dragArea.style)).setProperty("height", "151px");
    }

    @Test
    public void testRefreshItemsHTML() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.dragArea.firstChild = element;
        this.mockDragAreaWithChildren(element);
        Mockito.when((Object)this.dragArea.removeChild((Node)element)).then(a -> {
            this.dragArea.firstChild = null;
            return element;
        });
        this.view.refreshItemsHTML();
        ((HTMLDivElement)Mockito.verify((Object)this.dragArea)).removeChild((Node)element);
        ((HTMLDivElement)Mockito.verify((Object)this.dragArea)).appendChild((Node)element);
    }

    @Test
    public void testConsolidateHierarchicalLevelWhenIsDraggedByUser() {
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        element0.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element1.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element2.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"2");
        Mockito.when((Object)element2.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)element0.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)element1.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)element2.getAttribute("data-x-position")).thenReturn((Object)"3");
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"0\"]")).thenReturn((Object)element0);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"2\"]")).thenReturn((Object)element1);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"1\"]")).thenReturn((Object)element2);
        this.mockDragAreaWithChildren(element0, element1, element2);
        this.view.consolidateHierarchicalLevel(true);
        ((HTMLElement)Mockito.verify((Object)element0)).setAttribute("data-y-position", 0.0);
        ((HTMLElement)Mockito.verify((Object)element2, (VerificationMode)Mockito.times((int)2))).setAttribute("data-y-position", 1.0);
        ((HTMLElement)Mockito.verify((Object)element1)).setAttribute("data-y-position", 2.0);
        ((HTMLElement)Mockito.verify((Object)element0)).setAttribute("data-x-position", 0.0);
        ((HTMLElement)Mockito.verify((Object)element2)).setAttribute("data-x-position", 1.0);
        ((HTMLElement)Mockito.verify((Object)element1, (VerificationMode)Mockito.never())).setAttribute((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testConsolidateHierarchicalLevelWhenIsNotDraggedByUser() {
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        element0.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element1.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element2.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"2");
        Mockito.when((Object)element2.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)element0.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)element1.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)element2.getAttribute("data-x-position")).thenReturn((Object)"3");
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"0\"]")).thenReturn((Object)element0);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"2\"]")).thenReturn((Object)element1);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"1\"]")).thenReturn((Object)element2);
        this.mockDragAreaWithChildren(element0, element1, element2);
        this.view.consolidateHierarchicalLevel(false);
        ((HTMLElement)Mockito.verify((Object)element0)).setAttribute("data-y-position", 0.0);
        ((HTMLElement)Mockito.verify((Object)element2, (VerificationMode)Mockito.times((int)2))).setAttribute("data-y-position", 1.0);
        ((HTMLElement)Mockito.verify((Object)element1)).setAttribute("data-y-position", 2.0);
        ((HTMLElement)Mockito.verify((Object)element0, (VerificationMode)Mockito.never())).setAttribute("data-x-position", 0.0);
        ((HTMLElement)Mockito.verify((Object)element2)).setAttribute("data-x-position", 1.0);
        ((HTMLElement)Mockito.verify((Object)element1, (VerificationMode)Mockito.never())).setAttribute((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testConsolidateHierarchicalLevelWhenListHasOneInvalidItem() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)element.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element.getAttribute("data-x-position")).thenReturn((Object)"9");
        this.mockDragAreaWithChildren(element);
        this.view.consolidateHierarchicalLevel(true);
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("data-x-position", 0.0);
    }

    @Test
    public void testConsolidateHierarchicalLevelWhenListHasOneValidItem() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)element.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element.getAttribute("data-x-position")).thenReturn((Object)"1");
        this.mockDragAreaWithChildren(element);
        this.view.consolidateHierarchicalLevel(true);
        ((HTMLElement)Mockito.verify((Object)element, (VerificationMode)Mockito.never())).setAttribute((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testConsolidateYPosition() {
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        element0.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        element1.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"2");
        this.mockDragAreaWithChildren(element0, element1);
        this.view.consolidateYPosition();
        ((HTMLElement)Mockito.verify((Object)element0)).setAttribute("data-y-position", 0.0);
        ((HTMLElement)Mockito.verify((Object)element1)).setAttribute("data-y-position", 1.0);
    }

    @Test
    public void testClear() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.dragArea.firstChild = element;
        this.mockDragAreaWithChildren(element);
        Mockito.when((Object)this.dragArea.removeChild((Node)element)).then(a -> {
            this.dragArea.firstChild = null;
            return element;
        });
        this.view.clear();
        ((HTMLDivElement)Mockito.verify((Object)this.dragArea)).removeChild((Node)element);
    }

    @Test
    public void testGetPreviousElementWhenElementIsFound() {
        HTMLElement current = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement expectedPrevious = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)expectedPrevious.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)current.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"0\"]")).thenReturn((Object)expectedPrevious);
        Optional actualPrevious = this.view.getPreviousElement((Element)current);
        Assert.assertTrue((boolean)actualPrevious.isPresent());
        Assert.assertEquals((Object)expectedPrevious, actualPrevious.get());
    }

    @Test
    public void testGetPreviousElementWhenElementIsNotFound() {
        HTMLElement current = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)current.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"0\"]")).thenReturn(null);
        Optional actualPrevious = this.view.getPreviousElement((Element)current);
        Assert.assertFalse((boolean)actualPrevious.isPresent());
    }

    @Test
    public void testCreateItem() {
        HTMLDocument document = (HTMLDocument)Mockito.mock(HTMLDocument.class);
        HTMLElement expectedItem = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement grip = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement i0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement i1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        DNDListDOMHelper.Factory.DOCUMENT = document;
        expectedItem.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        grip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        i0.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        i1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)document.createElement("div")).thenReturn((Object)expectedItem, (Object[])new Element[]{grip});
        Mockito.when((Object)document.createElement("i")).thenReturn((Object)i0, (Object[])new Element[]{i1});
        HTMLElement actualItem = this.view.createItem(htmlElement);
        ((HTMLElement)Mockito.verify((Object)actualItem)).appendChild((Node)grip);
        ((HTMLElement)Mockito.verify((Object)actualItem)).appendChild((Node)htmlElement);
        ((DOMTokenList)Mockito.verify((Object)actualItem.classList)).add(new String[]{"kie-dnd-draggable"});
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    @Test
    public void testSetupDragAreaHandlers() {
        Event event = (Event)Mockito.mock(Event.class);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).onStartDrag((Event)ArgumentMatchers.any());
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).onDrag((Event)ArgumentMatchers.any());
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).onDrop();
        this.dragArea.onmousedown.onInvoke(event);
        this.dragArea.onmousemove.onInvoke(event);
        this.dragArea.onmouseup.onInvoke(event);
        this.dragArea.onmouseout.onInvoke(event);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.view});
        ((DNDListComponentView)inOrder.verify((Object)this.view)).onStartDrag(event);
        ((DNDListComponentView)inOrder.verify((Object)this.view)).onDrag(event);
        ((DNDListComponentView)inOrder.verify((Object)this.view, Mockito.times((int)2))).onDrop();
    }

    @Test
    public void testOnStartDragWhenTargetIsGrip() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement parent = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement target = (HTMLElement)Mockito.mock(HTMLElement.class);
        event.target = target;
        target.parentNode = parent;
        target.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)target.classList.contains("kie-dnd-grip")).thenReturn((Object)true);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).holdDraggingElement((HTMLElement)ArgumentMatchers.any());
        this.view.onStartDrag(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).holdDraggingElement(parent);
    }

    @Test
    public void testOnStartDragWhenTargetIsNotGrip() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement parent = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement target = (HTMLElement)Mockito.mock(HTMLElement.class);
        event.target = target;
        target.parentNode = parent;
        target.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)target.classList.contains("kie-dnd-grip")).thenReturn((Object)false);
        this.view.onStartDrag(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).holdDraggingElement(parent);
    }

    @Test
    public void testOnDragWhenUserIsDragging() {
        Event event = (Event)Mockito.mock(Event.class);
        ((DNDListComponentView)Mockito.doReturn((Object)false).when((Object)this.view)).isNotDragging();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).updateDraggingElementY(event);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).updateDraggingElementX(event);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).updateHoverElement();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).updateDependentsPosition();
        this.view.onDrag(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).updateDraggingElementY(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).updateDraggingElementX(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).updateHoverElement();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).updateDependentsPosition();
    }

    @Test
    public void testOnDragWhenUserIsNotDragging() {
        Event event = (Event)Mockito.mock(Event.class);
        ((DNDListComponentView)Mockito.doReturn((Object)true).when((Object)this.view)).isNotDragging();
        this.view.onDrag(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).updateDraggingElementY(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).updateDraggingElementX(event);
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).updateHoverElement();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).updateDependentsPosition();
    }

    @Test
    public void testOnDropWhenUserIsDragging() {
        ((DNDListComponentView)Mockito.doReturn((Object)false).when((Object)this.view)).isNotDragging();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).updateDraggingElementsPosition();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).executeOnDropItemCallback();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).releaseDraggingElement();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).consolidateHierarchicalLevel(true);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).refreshItemsPosition();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).refreshItemsHTML();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).clearHover();
        this.view.onDrop();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).updateDraggingElementsPosition();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).executeOnDropItemCallback();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).releaseDraggingElement();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).consolidateHierarchicalLevel(true);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).refreshItemsPosition();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).refreshItemsHTML();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).clearHover();
    }

    @Test
    public void testOnDropWhenUserIsNotDragging() {
        ((DNDListComponentView)Mockito.doReturn((Object)true).when((Object)this.view)).isNotDragging();
        this.view.onDrop();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).updateDraggingElementsPosition();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).executeOnDropItemCallback();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).releaseDraggingElement();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).consolidateHierarchicalLevel(true);
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).refreshItemsPosition();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).refreshItemsHTML();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).clearHover();
    }

    @Test
    public void testUpdateDraggingElementsPositionWhenPreviousElementHasChildren() {
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement previousElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> dependentElements = Arrays.asList(getDependentElement0, getDependentElement1, getDependentElement2);
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        getDependentElement0.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        getDependentElement1.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        getDependentElement2.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        ((DNDListComponentView)Mockito.doReturn(Optional.of(previousElement)).when((Object)this.view)).getPreviousElement((Element)draggingElement);
        ((DNDListComponentView)Mockito.doReturn(dependentElements).when((Object)this.view)).getDependentElements();
        ((DNDListComponentView)Mockito.doReturn((Object)true).when((Object)this.view)).hasChildren((Element)previousElement);
        Mockito.when((Object)this.presenter.getIndentationSize()).thenReturn((Object)50);
        Mockito.when((Object)draggingElement.style.getPropertyValue("padding-left")).thenReturn((Object)"100px");
        Mockito.when((Object)getDependentElement0.style.getPropertyValue("padding-left")).thenReturn((Object)"150px");
        Mockito.when((Object)getDependentElement1.style.getPropertyValue("padding-left")).thenReturn((Object)"200px");
        Mockito.when((Object)getDependentElement2.style.getPropertyValue("padding-left")).thenReturn((Object)"250px");
        this.view.updateDraggingElementsPosition();
        ((HTMLElement)Mockito.verify((Object)draggingElement)).setAttribute("data-x-position", 3.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement0)).setAttribute("data-x-position", 4.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement1)).setAttribute("data-x-position", 5.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement2)).setAttribute("data-x-position", 6.0);
    }

    @Test
    public void testUpdateDraggingElementsPositionWhenPreviousElementDoesNotHaveChildren() {
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement previousElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> dependentElements = Arrays.asList(dependentElement0, dependentElement1, dependentElement2);
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        dependentElement0.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        dependentElement1.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        dependentElement2.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        ((DNDListComponentView)Mockito.doReturn(Optional.of(previousElement)).when((Object)this.view)).getPreviousElement((Element)draggingElement);
        ((DNDListComponentView)Mockito.doReturn(dependentElements).when((Object)this.view)).getDependentElements();
        ((DNDListComponentView)Mockito.doReturn((Object)false).when((Object)this.view)).hasChildren((Element)previousElement);
        Mockito.when((Object)this.presenter.getIndentationSize()).thenReturn((Object)50);
        Mockito.when((Object)draggingElement.style.getPropertyValue("padding-left")).thenReturn((Object)"100px");
        Mockito.when((Object)dependentElement0.style.getPropertyValue("padding-left")).thenReturn((Object)"150px");
        Mockito.when((Object)dependentElement1.style.getPropertyValue("padding-left")).thenReturn((Object)"200px");
        Mockito.when((Object)dependentElement2.style.getPropertyValue("padding-left")).thenReturn((Object)"250px");
        this.view.updateDraggingElementsPosition();
        ((HTMLElement)Mockito.verify((Object)draggingElement)).setAttribute("data-x-position", 2.0);
        ((HTMLElement)Mockito.verify((Object)dependentElement0)).setAttribute("data-x-position", 3.0);
        ((HTMLElement)Mockito.verify((Object)dependentElement1)).setAttribute("data-x-position", 4.0);
        ((HTMLElement)Mockito.verify((Object)dependentElement2)).setAttribute("data-x-position", 5.0);
    }

    @Test
    public void testExecuteOnDropItemCallbackWhenHoverElementIsPresent() {
        HTMLElement hoverElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> dependentElements = Arrays.asList(dependentElement0, dependentElement1, dependentElement2);
        List<HTMLElement> expectedChildren = Arrays.asList(dependentElement0, dependentElement1, dependentElement2, draggingElement);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        ((DNDListComponentView)Mockito.doReturn(dependentElements).when((Object)this.view)).getDependentElements();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).fixChildrenPosition(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyListOf(HTMLElement.class));
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-hover")).thenReturn((Object)hoverElement);
        Mockito.when((Object)hoverElement.getAttribute("data-x-position")).thenReturn((Object)"3");
        Mockito.when((Object)draggingElement.getAttribute("data-x-position")).thenReturn((Object)"4");
        this.view.executeOnDropItemCallback();
        ((HTMLElement)Mockito.verify((Object)draggingElement)).setAttribute("data-x-position", 4.0);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).fixChildrenPosition(4, 0, expectedChildren);
        ((DNDListComponent)Mockito.verify((Object)this.presenter)).executeOnDropItemCallback((Element)draggingElement, (Element)hoverElement);
    }

    @Test
    public void testExecuteOnDropItemCallbackWhenHoverElementIsNotPresent() {
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-hover")).thenReturn(null);
        this.view.executeOnDropItemCallback();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{draggingElement});
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).fixChildrenPosition(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyListOf(HTMLElement.class));
        ((DNDListComponent)Mockito.verify((Object)this.presenter)).executeOnDropItemCallback((Element)draggingElement, null);
    }

    @Test
    public void testFixChildrenPosition() {
        HTMLElement dependentElement0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        int minimalXPosition = 4;
        int numberOfExtraLevels = 6;
        List<HTMLElement> children = Arrays.asList(dependentElement0, dependentElement1, dependentElement2);
        Mockito.when((Object)dependentElement0.getAttribute("data-x-position")).thenReturn((Object)"8");
        Mockito.when((Object)dependentElement1.getAttribute("data-x-position")).thenReturn((Object)"2");
        Mockito.when((Object)dependentElement2.getAttribute("data-x-position")).thenReturn((Object)"5");
        this.view.fixChildrenPosition(4, 6, children);
        ((HTMLElement)Mockito.verify((Object)dependentElement0)).setAttribute("data-x-position", 4.0);
        ((HTMLElement)Mockito.verify((Object)dependentElement1)).setAttribute("data-x-position", 4.0);
    }

    @Test
    public void testUpdateHoverElementWhenPositionIsInNotTheRange() {
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        draggingElement.offsetTop = 75;
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).hover(ArgumentMatchers.anyInt());
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)draggingElement.getAttribute("data-y-position")).thenReturn((Object)"1");
        this.view.updateHoverElement();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).hover(2);
    }

    @Test
    public void testUpdateHoverElementWhenPositionIsInTheRange() {
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        draggingElement.offsetTop = 45;
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).hover(ArgumentMatchers.anyInt());
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)draggingElement.getAttribute("data-y-position")).thenReturn((Object)"1");
        this.view.updateHoverElement();
        ((DNDListComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hover(ArgumentMatchers.anyInt());
    }

    @Test
    public void testHoverWhenHoverElementIsBeingDragged() {
        HTMLElement hoverElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        hoverElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)hoverElement.classList.contains("kie-dnd-current-dragging")).thenReturn((Object)true);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"42\"]")).thenReturn((Object)hoverElement);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).clearHover();
        this.view.hover(42);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).clearHover();
        ((DOMTokenList)Mockito.verify((Object)hoverElement.classList, (VerificationMode)Mockito.never())).add(new String[]{"kie-dnd-hover"});
        ((DNDListComponent)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).highlightLevel(hoverElement);
    }

    @Test
    public void testHoverWhenHoverElementIsNotBeingDragged() {
        HTMLElement hoverElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        hoverElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)hoverElement.classList.contains("kie-dnd-current-dragging")).thenReturn((Object)false);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"42\"]")).thenReturn((Object)hoverElement);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).clearHover();
        this.view.hover(42);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).clearHover();
        ((DOMTokenList)Mockito.verify((Object)hoverElement.classList)).add(new String[]{"kie-dnd-hover"});
        ((DNDListComponent)Mockito.verify((Object)this.presenter)).highlightLevel(hoverElement);
    }

    @Test
    public void testClearHover() {
        HTMLElement hoverElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        hoverElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-hover")).thenReturn((Object)hoverElement);
        this.view.clearHover();
        ((DOMTokenList)Mockito.verify((Object)hoverElement.classList)).remove(new String[]{"kie-dnd-hover"});
    }

    @Test
    public void testUpdateDependentsPosition() {
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement dependentElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> dependentElements = Arrays.asList(dependentElement0, dependentElement1, dependentElement2);
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        dependentElement0.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        dependentElement1.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        dependentElement2.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)this.presenter.getIndentationSize()).thenReturn((Object)50);
        Mockito.when((Object)draggingElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)dependentElement0.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)dependentElement1.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)dependentElement2.getAttribute("data-x-position")).thenReturn((Object)"2");
        Mockito.when((Object)draggingElement.style.getPropertyValue("top")).thenReturn((Object)"50px");
        Mockito.when((Object)draggingElement.style.getPropertyValue("width")).thenReturn((Object)"calc(100% - 100px)");
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        ((DNDListComponentView)Mockito.doReturn(dependentElements).when((Object)this.view)).getDependentElements();
        this.view.updateDependentsPosition();
        ((CSSStyleDeclaration)Mockito.verify((Object)dependentElement0.style)).setProperty("top", "100px");
        ((CSSStyleDeclaration)Mockito.verify((Object)dependentElement1.style)).setProperty("top", "150px");
        ((CSSStyleDeclaration)Mockito.verify((Object)dependentElement2.style)).setProperty("top", "200px");
        ((CSSStyleDeclaration)Mockito.verify((Object)dependentElement0.style)).setProperty("width", "calc(100% - 100px)");
        ((CSSStyleDeclaration)Mockito.verify((Object)dependentElement1.style)).setProperty("width", "calc(100% - 100px)");
        ((CSSStyleDeclaration)Mockito.verify((Object)dependentElement2.style)).setProperty("width", "calc(100% - 100px)");
    }

    @Test
    public void testHasChildrenWhenElementHasChildren() {
        HTMLElement currentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement nextElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"1\"]")).thenReturn((Object)draggingElement);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"2\"]")).thenReturn((Object)nextElement);
        Mockito.when((Object)currentElement.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)draggingElement.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)nextElement.getAttribute("data-y-position")).thenReturn((Object)"2");
        Mockito.when((Object)currentElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)draggingElement.getAttribute("data-x-position")).thenReturn((Object)"1");
        Mockito.when((Object)nextElement.getAttribute("data-x-position")).thenReturn((Object)"1");
        Assert.assertTrue((boolean)this.view.hasChildren((Element)currentElement));
    }

    @Test
    public void testHasChildrenWhenElementDoesNotHaveChildren() {
        HTMLElement currentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement nextElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"1\"]")).thenReturn((Object)nextElement);
        Mockito.when((Object)currentElement.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)nextElement.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)currentElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Mockito.when((Object)nextElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Assert.assertFalse((boolean)this.view.hasChildren((Element)currentElement));
    }

    @Test
    public void testHasChildrenWhenNextElementIsNull() {
        HTMLElement currentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"1\"]")).thenReturn(null);
        Mockito.when((Object)currentElement.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)currentElement.getAttribute("data-x-position")).thenReturn((Object)"0");
        Assert.assertFalse((boolean)this.view.hasChildren((Element)currentElement));
    }

    @Test
    public void testUpdateDraggingElementYWhenDraggingYPositionIsLessThanMin() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement siblingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> dependentElements = Arrays.asList(getDependentElement0, getDependentElement1, getDependentElement2);
        int newDraggingYPosition = 10;
        draggingElement.offsetTop = 130;
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)draggingElement.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"6\"]")).thenReturn((Object)siblingElement);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).clearHover();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).refreshItemsPosition();
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        ((DNDListComponentView)Mockito.doReturn((Object)10).when((Object)this.view)).getNewDraggingYPosition(event);
        ((DNDListComponentView)Mockito.doReturn(dependentElements).when((Object)this.view)).getDependentElements();
        this.view.updateDraggingElementY(event);
        ((HTMLElement)Mockito.verify((Object)siblingElement)).setAttribute("data-y-position", 1.0);
        ((HTMLElement)Mockito.verify((Object)draggingElement)).setAttribute("data-y-position", 3.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement0)).setAttribute("data-y-position", 4.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement1)).setAttribute("data-y-position", 5.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement2)).setAttribute("data-y-position", 6.0);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).clearHover();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).refreshItemsPosition();
        ((CSSStyleDeclaration)Mockito.verify((Object)draggingElement.style)).setProperty("top", "10px");
    }

    @Test
    public void testUpdateDraggingElementYWhenDraggingYPositionIsGreaterThanMin() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement siblingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement getDependentElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> dependentElements = Arrays.asList(getDependentElement0, getDependentElement1, getDependentElement2);
        int newDraggingYPosition = 10;
        draggingElement.offsetTop = 30;
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)draggingElement.getAttribute("data-y-position")).thenReturn((Object)"2");
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)this.dragArea.querySelector(".kie-dnd-draggable[data-y-position=\"1\"]")).thenReturn((Object)siblingElement);
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).clearHover();
        ((DNDListComponentView)Mockito.doNothing().when((Object)this.view)).refreshItemsPosition();
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        ((DNDListComponentView)Mockito.doReturn((Object)10).when((Object)this.view)).getNewDraggingYPosition(event);
        ((DNDListComponentView)Mockito.doReturn(dependentElements).when((Object)this.view)).getDependentElements();
        this.view.updateDraggingElementY(event);
        ((HTMLElement)Mockito.verify((Object)siblingElement)).setAttribute("data-y-position", 5.0);
        ((HTMLElement)Mockito.verify((Object)draggingElement)).setAttribute("data-y-position", 1.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement0)).setAttribute("data-y-position", 2.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement1)).setAttribute("data-y-position", 3.0);
        ((HTMLElement)Mockito.verify((Object)getDependentElement2)).setAttribute("data-y-position", 4.0);
        ((DNDListComponentView)Mockito.verify((Object)this.view)).clearHover();
        ((DNDListComponentView)Mockito.verify((Object)this.view)).refreshItemsPosition();
        ((CSSStyleDeclaration)Mockito.verify((Object)draggingElement.style)).setProperty("top", "10px");
    }

    @Test
    public void testUpdateDraggingElementX() {
        MouseEvent event = (MouseEvent)Mockito.mock(MouseEvent.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect rect = (DOMRect)Mockito.mock(DOMRect.class);
        event.x = 100.0;
        rect.left = 25.0;
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.offsetWidth = 300;
        Mockito.when((Object)this.presenter.getIndentationSize()).thenReturn((Object)50);
        Mockito.when((Object)this.dragArea.getBoundingClientRect()).thenReturn((Object)rect);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        this.view.updateDraggingElementX((Event)event);
        ((CSSStyleDeclaration)Mockito.verify((Object)draggingElement.style)).setProperty("width", "calc(100% - 65px)");
    }

    @Test
    public void testUpdateDraggingElementXWhenNewDraggingXPositionIsGreaterThanMax() {
        MouseEvent event = (MouseEvent)Mockito.mock(MouseEvent.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect rect = (DOMRect)Mockito.mock(DOMRect.class);
        event.x = 1000.0;
        rect.left = 25.0;
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.offsetWidth = 300;
        Mockito.when((Object)this.presenter.getIndentationSize()).thenReturn((Object)50);
        Mockito.when((Object)this.dragArea.getBoundingClientRect()).thenReturn((Object)rect);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        this.view.updateDraggingElementX((Event)event);
        ((CSSStyleDeclaration)Mockito.verify((Object)draggingElement.style)).setProperty("width", "calc(100% - 250px)");
    }

    @Test
    public void testUpdateDraggingElementXWhenNewDraggingXPositionIsLessThanZero() {
        MouseEvent event = (MouseEvent)Mockito.mock(MouseEvent.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect rect = (DOMRect)Mockito.mock(DOMRect.class);
        event.x = -1000.0;
        rect.left = 25.0;
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.offsetWidth = 300;
        Mockito.when((Object)this.presenter.getIndentationSize()).thenReturn((Object)50);
        Mockito.when((Object)this.dragArea.getBoundingClientRect()).thenReturn((Object)rect);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        this.view.updateDraggingElementX((Event)event);
        ((CSSStyleDeclaration)Mockito.verify((Object)draggingElement.style)).setProperty("width", "calc(100% - 0px)");
    }

    @Test
    public void testGetNewDraggingYPosition() {
        MouseEvent event = (MouseEvent)Mockito.mock(MouseEvent.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect rect = (DOMRect)Mockito.mock(DOMRect.class);
        event.y = 100.0;
        rect.top = 25.0;
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.offsetHeight = 300;
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)this.dragArea.getBoundingClientRect()).thenReturn((Object)rect);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        int actualYPosition = this.view.getNewDraggingYPosition((Event)event);
        int expectedYPosition = 50;
        Assert.assertEquals((long)50L, (long)actualYPosition);
    }

    @Test
    public void testGetNewDraggingYPositionWhenNewYPositionIsGreaterThanMax() {
        MouseEvent event = (MouseEvent)Mockito.mock(MouseEvent.class);
        HTMLElement draggingElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMRect rect = (DOMRect)Mockito.mock(DOMRect.class);
        event.y = 1000.0;
        rect.top = 25.0;
        draggingElement.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        this.dragArea.offsetHeight = 300;
        Mockito.when((Object)this.presenter.getItemHeight()).thenReturn((Object)50);
        Mockito.when((Object)this.dragArea.getBoundingClientRect()).thenReturn((Object)rect);
        ((DNDListComponentView)Mockito.doReturn((Object)draggingElement).when((Object)this.view)).getDragging();
        int actualYPosition = this.view.getNewDraggingYPosition((Event)event);
        int expectedYPosition = 325;
        Assert.assertEquals((long)325L, (long)actualYPosition);
    }

    @Test
    public void testIsNotDraggingWhenItsDragging() {
        ((DNDListComponentView)Mockito.doReturn((Object)Mockito.mock(HTMLElement.class)).when((Object)this.view)).getDragging();
        Assert.assertFalse((boolean)this.view.isNotDragging());
    }

    @Test
    public void testIsNotDraggingWhenItsNotDragging() {
        ((DNDListComponentView)Mockito.doReturn(null).when((Object)this.view)).getDragging();
        Assert.assertTrue((boolean)this.view.isNotDragging());
    }

    @Test
    public void testHoldDraggingElement() {
        HTMLElement expectedDragging = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> expectedDependentElements = Arrays.asList(element0, element1, element2);
        expectedDragging.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element0.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DNDListComponentView)Mockito.doReturn(expectedDependentElements).when((Object)this.view)).getDependentElements(expectedDragging);
        this.view.holdDraggingElement(expectedDragging);
        HTMLElement actualDragging = this.view.getDragging();
        List actualDependentElements = this.view.getDependentElements();
        expectedDragging.classList.add(new String[]{"kie-dnd-current-dragging"});
        element0.classList.add(new String[]{"kie-dnd-current-dragging"});
        element1.classList.add(new String[]{"kie-dnd-current-dragging"});
        element2.classList.add(new String[]{"kie-dnd-current-dragging"});
        Assert.assertEquals((Object)expectedDragging, (Object)actualDragging);
        Assert.assertEquals(expectedDependentElements, (Object)actualDependentElements);
    }

    @Test
    public void testReleaseDraggingElement() {
        HTMLElement dragging = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<HTMLElement> dependentElements = Arrays.asList(element0, element1, element2);
        dragging.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element0.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DNDListComponentView)Mockito.doReturn(dependentElements).when((Object)this.view)).getDependentElements(dragging);
        this.view.holdDraggingElement(dragging);
        this.view.releaseDraggingElement();
        HTMLElement actualDragging = this.view.getDragging();
        List actualDependentElements = this.view.getDependentElements();
        dragging.classList.remove(new String[]{"kie-dnd-current-dragging"});
        element0.classList.remove(new String[]{"kie-dnd-current-dragging"});
        element1.classList.remove(new String[]{"kie-dnd-current-dragging"});
        element2.classList.remove(new String[]{"kie-dnd-current-dragging"});
        Assert.assertNull((Object)actualDragging);
        Assert.assertEquals(Collections.emptyList(), (Object)actualDependentElements);
    }

    private void mockDragAreaWithChildren(HTMLElement ... children) {
        NodeList nodeList = (NodeList)Mockito.spy((Object)new NodeList());
        nodeList.length = children.length;
        for (int i = 0; i < children.length; ++i) {
            ((NodeList)Mockito.doReturn((Object)children[i]).when((Object)nodeList)).getAt(i);
        }
        Mockito.when((Object)this.dragArea.querySelectorAll((String)ArgumentMatchers.any())).thenReturn((Object)nodeList);
    }
}

