/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.persistence.RecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeRecordEngine;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeActiveRecordTest {
    @Test
    public void testCreate() {
        DataTypeRecordEngine engine = this.makeRecordEngine();
        DataType record = (DataType)Mockito.spy((Object)new DataType((RecordEngine)engine));
        DataType reference = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        CreationType creationType = (CreationType)Mockito.mock(CreationType.class);
        ((DataTypeRecordEngine)Mockito.doReturn(expectedDataTypes).when((Object)engine)).create(record, reference, creationType);
        List actualDataTypes = record.create(reference, creationType);
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testDestroyWithoutDependentTypes() {
        DataTypeRecordEngine engine = this.makeRecordEngine();
        DataType record = (DataType)Mockito.spy((Object)new DataType((RecordEngine)engine));
        List<DataType> expectedDataTypes = Collections.singletonList((DataType)Mockito.mock(DataType.class));
        ((DataTypeRecordEngine)Mockito.doReturn(expectedDataTypes).when((Object)engine)).destroyWithoutDependentTypes(record);
        List actualDataTypes = record.destroyWithoutDependentTypes();
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    private DataTypeRecordEngine makeRecordEngine() {
        return (DataTypeRecordEngine)Mockito.spy((Object)new DataTypeRecordEngine(){

            public List<DataType> update(DataType record) {
                return null;
            }

            public List<DataType> destroy(DataType record) {
                return null;
            }

            public List<DataType> create(DataType record) {
                return null;
            }

            public boolean isValid(DataType record) {
                return false;
            }

            public List<DataType> create(DataType record, DataType reference, CreationType creationType) {
                return null;
            }

            public List<DataType> destroyWithoutDependentTypes(DataType record) {
                return null;
            }
        });
    }
}

