/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DataTypeStoreTest {
    private DataTypeStore store;
    @Mock
    private DataType dataType;
    private String uuid = "123";

    @Before
    public void setup() {
        this.store = new DataTypeStore();
        this.store.index(this.uuid, this.dataType);
    }

    @Test
    public void testGetWhenItReturnsNull() {
        Assert.assertNull((Object)this.store.get("456"));
    }

    @Test
    public void testGetWhenItDoesNotReturnNull() {
        Assert.assertNotNull((Object)this.store.get(this.uuid));
        Assert.assertEquals((Object)this.dataType, (Object)this.store.get(this.uuid));
    }

    @Test
    public void testIndex() {
        Assert.assertEquals((long)1L, (long)this.store.size());
        DataType secondDataType = (DataType)Mockito.mock(DataType.class);
        String secondUUID = "789";
        this.store.index("789", secondDataType);
        Assert.assertEquals((long)2L, (long)this.store.size());
        Assert.assertEquals((Object)this.dataType, (Object)this.store.get(this.uuid));
        Assert.assertEquals((Object)secondDataType, (Object)this.store.get("789"));
    }

    @Test
    public void testClear() {
        this.store.clear();
        Assert.assertEquals((long)0L, (long)this.store.size());
    }

    @Test
    public void testGetTopLevelDataTypes() {
        String secondUUID = "789";
        String thirdUUID = "012";
        DataType secondDataType = (DataType)Mockito.mock(DataType.class);
        DataType thirdDataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)secondDataType.isTopLevel()).thenReturn((Object)true);
        this.store.index("789", secondDataType);
        this.store.index("012", thirdDataType);
        List topLevelDataTypes = this.store.getTopLevelDataTypes();
        Assert.assertEquals((Object)topLevelDataTypes, Collections.singletonList(secondDataType));
    }

    @Test
    public void testUnIndex() {
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        DataType dataType4 = (DataType)Mockito.mock(DataType.class);
        DataType dataType5 = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"345");
        Mockito.when((Object)dataType2.getUUID()).thenReturn((Object)"678");
        Mockito.when((Object)dataType3.getUUID()).thenReturn((Object)"901");
        Mockito.when((Object)dataType4.getUUID()).thenReturn((Object)"234");
        Mockito.when((Object)dataType5.getUUID()).thenReturn((Object)"567");
        Mockito.when((Object)dataType0.getParentUUID()).thenReturn((Object)"");
        Mockito.when((Object)dataType1.getParentUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType2.getParentUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType3.getParentUUID()).thenReturn((Object)"678");
        Mockito.when((Object)dataType4.getParentUUID()).thenReturn((Object)"678");
        Mockito.when((Object)dataType5.getParentUUID()).thenReturn((Object)"");
        this.store.index(dataType0.getUUID(), dataType0);
        this.store.index(dataType1.getUUID(), dataType1);
        this.store.index(dataType2.getUUID(), dataType2);
        this.store.index(dataType3.getUUID(), dataType3);
        this.store.index(dataType4.getUUID(), dataType4);
        this.store.index(dataType5.getUUID(), dataType5);
        this.store.unIndex("012");
        Assert.assertNull((Object)this.store.get("012"));
        Assert.assertNull((Object)this.store.get("345"));
        Assert.assertNull((Object)this.store.get("678"));
        Assert.assertNull((Object)this.store.get("901"));
        Assert.assertNull((Object)this.store.get("234"));
        Assert.assertNotNull((Object)this.store.get("567"));
    }

    @Test
    public void testAll() {
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        this.store.index("0", dataType0);
        this.store.index("1", dataType1);
        List all = this.store.all();
        Assert.assertEquals((long)3L, (long)all.size());
        Assert.assertTrue((boolean)all.contains(this.dataType));
        Assert.assertTrue((boolean)all.contains(dataType0));
        Assert.assertTrue((boolean)all.contains(dataType1));
    }
}

