/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeHandler;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeHandlerTest {
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private DataTypeManager dataTypeManager;
    private DataTypeHandler handler;

    @Before
    public void setup() {
        this.handler = (DataTypeHandler)Mockito.spy((Object)new DataTypeHandler(this.dataTypeStore, this.dataTypeManager));
    }

    @Test
    public void testInit() {
        ItemDefinitionRecordEngine expectedRecordEngine = (ItemDefinitionRecordEngine)Mockito.mock(ItemDefinitionRecordEngine.class);
        this.handler.init(expectedRecordEngine);
        ItemDefinitionRecordEngine actualRecordEngine = this.handler.getRecordEngine();
        Assert.assertEquals((Object)expectedRecordEngine, (Object)actualRecordEngine);
    }

    @Test
    public void testGetClosestTopLevelDataType() {
        DataType dataType0 = this.makeDataType("name", "Text", false, new DataType[0]);
        DataType dataType1 = this.makeDataType("name", "Text", false, new DataType[0]);
        DataType dataType2 = this.makeDataType("name", "Text", false, new DataType[0]);
        DataType dataType3 = this.makeDataType("city", "tCity", false, new DataType[0]);
        DataType dataType5 = this.makeDataType("street", "Structure", false, dataType1);
        DataType dataType4 = this.makeDataType("tCity", "Structure", true, dataType0, dataType5);
        DataType dataType6 = this.makeDataType("tPerson", "Structure", true, dataType2, dataType3);
        ((DataTypeHandler)Mockito.doReturn((Object)dataType4).when((Object)this.handler)).parent(dataType0);
        ((DataTypeHandler)Mockito.doReturn((Object)dataType4).when((Object)this.handler)).parent(dataType5);
        ((DataTypeHandler)Mockito.doReturn((Object)dataType5).when((Object)this.handler)).parent(dataType1);
        ((DataTypeHandler)Mockito.doReturn((Object)dataType6).when((Object)this.handler)).parent(dataType2);
        ((DataTypeHandler)Mockito.doReturn((Object)dataType6).when((Object)this.handler)).parent(dataType3);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType4, dataType6));
        DataType closestTopLevelDataTypeForDataType1 = (DataType)this.handler.getClosestTopLevelDataType(dataType1).orElseThrow(UnsupportedOperationException::new);
        DataType closestTopLevelDataTypeForDataType3 = (DataType)this.handler.getClosestTopLevelDataType(dataType3).orElseThrow(UnsupportedOperationException::new);
        Assert.assertEquals((Object)dataType4, (Object)closestTopLevelDataTypeForDataType1);
        Assert.assertEquals((Object)dataType6, (Object)closestTopLevelDataTypeForDataType3);
    }

    @Test
    public void testGetClosestTopLevelDataTypeWhenDataTypeParentCannotBeFound() {
        DataType dataType = this.makeDataType();
        ((DataTypeHandler)Mockito.doReturn(null).when((Object)this.handler)).parent(dataType);
        Optional closestTopLevelDataType = this.handler.getClosestTopLevelDataType(dataType);
        Assert.assertFalse((boolean)closestTopLevelDataType.isPresent());
    }

    @Test
    public void testGetSubDataTypesByType() {
        String type = "tCity";
        DataType dataType0 = this.makeDataType("tPerson", "Structure");
        DataType dataType1 = this.makeDataType("tCity", "Structure");
        DataType dataType2 = this.makeDataType("city1", "tCity");
        DataType dataType3 = this.makeDataType("city2", "tCity");
        DataType dataType4 = this.makeDataType("tCompany", "Structure");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType0, dataType1, dataType2, dataType3, dataType4));
        List<DataType> expectedDataTypes = Arrays.asList(dataType2, dataType3);
        List actualDataTypes = this.handler.getSubDataTypesByType("tCity");
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testForEachSubDataTypesByType() {
        String type = "tCity";
        DataType dataType0 = this.makeDataType("tPerson", "Structure");
        DataType dataType1 = this.makeDataType("tCity", "Structure");
        DataType dataType2 = this.makeDataType("city1", "tCity");
        DataType dataType3 = this.makeDataType("city2", "tCity");
        DataType dataType4 = this.makeDataType("tCompany", "Structure");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType0, dataType1, dataType2, dataType3, dataType4));
        ArrayList actualDataTypes = new ArrayList();
        List<DataType> expectedDataTypes = Arrays.asList(dataType2, dataType3);
        List forEachSubDataTypesByType = this.handler.forEachSubDataTypesByType("tCity", actualDataTypes::add);
        Assert.assertEquals(expectedDataTypes, actualDataTypes);
        Assert.assertEquals(expectedDataTypes, (Object)forEachSubDataTypesByType);
    }

    @Test
    public void testForEachSubDataTypesByTypeOrName() {
        String type = "tCompany";
        DataType dataType0 = this.makeDataType("RedHat", "tCompany");
        DataType dataType1 = this.makeDataType("tPerson", "Structure");
        DataType dataType2 = this.makeDataType("tCity", "Structure");
        DataType dataType3 = this.makeDataType("city1", "tCity");
        DataType dataType4 = this.makeDataType("city2", "tCity");
        DataType dataType5 = this.makeDataType("tCompany", "Structure");
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(Arrays.asList(dataType0, dataType1, dataType2, dataType3, dataType4, dataType5));
        ArrayList actualDataTypes = new ArrayList();
        List<DataType> expectedDataTypes = Arrays.asList(dataType0, dataType5);
        List forEachSubDataTypesByType = this.handler.forEachSubDataTypesByTypeOrName("tCompany", actualDataTypes::add);
        Assert.assertEquals(expectedDataTypes, actualDataTypes);
        Assert.assertEquals(expectedDataTypes, (Object)forEachSubDataTypesByType);
    }

    @Test
    public void testParent() {
        DataType dataType = this.makeDataType();
        DataType expectedParent = this.makeDataType();
        String parentUUID = "parentUUID";
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.dataTypeStore.get("parentUUID")).thenReturn((Object)expectedParent);
        DataType actualParent = this.handler.parent(dataType);
        Assert.assertEquals((Object)expectedParent, (Object)actualParent);
    }

    @Test
    public void testIsStructureWhenItReturnsTrue() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String structure = "Structure";
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"Structure");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"Structure");
        Assert.assertTrue((boolean)this.handler.isStructure(dataType));
    }

    @Test
    public void testIsStructureWhenItReturnsFalse() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.dataTypeManager.structure()).thenReturn((Object)"Structure");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"tCity");
        Assert.assertFalse((boolean)this.handler.isStructure(dataType));
    }

    private DataType makeDataType(String name, String type, boolean isTopLevel, DataType ... dataTypes) {
        DataType dataType = this.makeDataType(name, type);
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)isTopLevel);
        Mockito.when((Object)dataType.getSubDataTypes()).thenReturn(Arrays.asList(dataTypes));
        return dataType;
    }

    private DataType makeDataType(String name, String type) {
        DataType dataType = this.makeDataType();
        Mockito.when((Object)dataType.getName()).thenReturn((Object)name);
        Mockito.when((Object)dataType.getType()).thenReturn((Object)type);
        return dataType;
    }

    private DataType makeDataType() {
        return (DataType)Mockito.mock(DataType.class);
    }
}

