/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.validation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsBlankErrorMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsDefaultTypeMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsNotUniqueErrorMessage;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.validation.DataTypeNameValidator;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeNameValidatorTest {
    @Mock
    private EventSourceMock<FlashMessage> flashMessageEvent;
    @Mock
    private DataTypeNameIsBlankErrorMessage blankErrorMessage;
    @Mock
    private DataTypeNameIsNotUniqueErrorMessage notUniqueErrorMessage;
    @Mock
    private DataTypeNameIsDefaultTypeMessage nameIsDefaultTypeMessage;
    @Mock
    private DataTypeStore dataTypeStore;
    private DataTypeNameValidator validator;

    @Before
    public void setup() {
        this.validator = (DataTypeNameValidator)Mockito.spy((Object)new DataTypeNameValidator(this.flashMessageEvent, this.blankErrorMessage, this.notUniqueErrorMessage, this.nameIsDefaultTypeMessage, this.dataTypeStore));
    }

    @Test
    public void testIsValidWhenDataTypeNameIsBlank() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        FlashMessage blankMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        ((DataTypeNameValidator)Mockito.doReturn((Object)true).when((Object)this.validator)).isBlank(dataType);
        ((DataTypeNameValidator)Mockito.doReturn((Object)true).when((Object)this.validator)).isNotUnique(dataType);
        Mockito.when((Object)this.blankErrorMessage.getFlashMessage(dataType)).thenReturn((Object)blankMessage);
        boolean isValid = this.validator.isValid(dataType);
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)blankMessage);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testIsValidWhenDataTypeNameIsNotUnique() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        FlashMessage notUniqueMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        ((DataTypeNameValidator)Mockito.doReturn((Object)false).when((Object)this.validator)).isBlank(dataType);
        ((DataTypeNameValidator)Mockito.doReturn((Object)true).when((Object)this.validator)).isNotUnique(dataType);
        Mockito.when((Object)this.notUniqueErrorMessage.getFlashMessage(dataType)).thenReturn((Object)notUniqueMessage);
        boolean isValid = this.validator.isValid(dataType);
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)notUniqueMessage);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testIsValidWhenDataTypeNameIsDefault() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        FlashMessage nameIsDefaultMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        ((DataTypeNameValidator)Mockito.doReturn((Object)false).when((Object)this.validator)).isBlank(dataType);
        ((DataTypeNameValidator)Mockito.doReturn((Object)false).when((Object)this.validator)).isNotUnique(dataType);
        ((DataTypeNameValidator)Mockito.doReturn((Object)true).when((Object)this.validator)).isDefault(dataType);
        Mockito.when((Object)this.nameIsDefaultTypeMessage.getFlashMessage(dataType)).thenReturn((Object)nameIsDefaultMessage);
        boolean isValid = this.validator.isValid(dataType);
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)nameIsDefaultMessage);
        Assert.assertFalse((boolean)isValid);
    }

    @Test
    public void testIsValid() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeNameValidator)Mockito.doReturn((Object)false).when((Object)this.validator)).isBlank(dataType);
        ((DataTypeNameValidator)Mockito.doReturn((Object)false).when((Object)this.validator)).isNotUnique(dataType);
        ((DataTypeNameValidator)Mockito.doReturn((Object)false).when((Object)this.validator)).isDefault(dataType);
        boolean isValid = this.validator.isValid(dataType);
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent, (VerificationMode)Mockito.never())).fire((Object)((FlashMessage)ArgumentMatchers.any()));
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent, (VerificationMode)Mockito.never())).fire((Object)((FlashMessage)ArgumentMatchers.any()));
        Assert.assertTrue((boolean)isValid);
    }

    @Test
    public void testIsNotUniqueWhenNameIsUnique() {
        DataType dataType = this.makeDataType("uuid1", "tCompany");
        ((DataTypeNameValidator)Mockito.doReturn(Arrays.asList(this.makeDataType("uuid2", "tPerson"), this.makeDataType("uuid3", "tCity"))).when((Object)this.validator)).siblings(dataType);
        Assert.assertFalse((boolean)this.validator.isNotUnique(dataType));
    }

    @Test
    public void testIsNotUniqueWhenNameIsNotUnique() {
        DataType dataType = this.makeDataType("uuid1", "tCity");
        ((DataTypeNameValidator)Mockito.doReturn(Arrays.asList(this.makeDataType("uuid2", "tPerson"), this.makeDataType("uuid3", "tCity"))).when((Object)this.validator)).siblings(dataType);
        Assert.assertTrue((boolean)this.validator.isNotUnique(dataType));
    }

    @Test
    public void testIsNotBlankWhenNameIsBlank() {
        DataType dataType = this.makeDataType("uuid", "");
        Assert.assertTrue((boolean)this.validator.isBlank(dataType));
    }

    @Test
    public void testIsNotBlankWhenNameIsNull() {
        DataType dataType = this.makeDataType("uuid", null);
        Assert.assertTrue((boolean)this.validator.isBlank(dataType));
    }

    @Test
    public void testIsNotBlankWhenNameIsNotBlank() {
        DataType dataType = this.makeDataType("uuid", "tCity");
        Assert.assertFalse((boolean)this.validator.isBlank(dataType));
    }

    @Test
    public void testIsDefaultWhenItReturnsTrue() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"string");
        Assert.assertTrue((boolean)this.validator.isDefault(dataType));
    }

    @Test
    public void testIsDefaultWhenItReturnsFalse() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"tCity");
        Assert.assertFalse((boolean)this.validator.isDefault(dataType));
    }

    @Test
    public void testSiblingsWhenDataTypeDoesNotHaveParent() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        List<DataType> expectedSiblings = Collections.singletonList((DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(expectedSiblings);
        List actualSiblings = this.validator.siblings(dataType);
        Assert.assertEquals(expectedSiblings, (Object)actualSiblings);
    }

    @Test
    public void testSiblingsWhenDataTypeHasParent() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType parent = (DataType)Mockito.mock(DataType.class);
        String parentUUID = "parentUUID";
        List<DataType> expectedSiblings = Collections.singletonList((DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)parent.getSubDataTypes()).thenReturn(expectedSiblings);
        Mockito.when((Object)this.dataTypeStore.get("parentUUID")).thenReturn((Object)parent);
        List actualSiblings = this.validator.siblings(dataType);
        Assert.assertEquals(expectedSiblings, (Object)actualSiblings);
    }

    private DataType makeDataType(String uuid, String name) {
        DataType dataType = (DataType)Mockito.spy((Object)new DataType(null));
        ((DataType)Mockito.doReturn((Object)uuid).when((Object)dataType)).getUUID();
        ((DataType)Mockito.doReturn((Object)name).when((Object)dataType)).getName();
        return dataType;
    }
}

