/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchEngine;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSearchEngineTest {
    private DataTypeStore dataTypeStore;
    private DataTypeSearchEngine searchEngine;

    @Before
    public void setup() {
        this.dataTypeStore = (DataTypeStore)Mockito.spy((Object)new DataTypeStore());
        this.searchEngine = new DataTypeSearchEngine(this.dataTypeStore);
    }

    @Test
    public void testSearch() {
        DataType tCity = this.makeDataType("001", "tCity", "");
        DataType tCityId = this.makeDataType("002", "id", "001");
        DataType tCityName = this.makeDataType("003", "name", "001");
        DataType tPerson = this.makeDataType("004", "tPerson", "");
        DataType tPersonId = this.makeDataType("005", "id", "004");
        DataType tPersonName = this.makeDataType("006", "name", "004");
        DataType tPersonCity = this.makeDataType("007", "city", "004");
        DataType tPersonCityId = this.makeDataType("008", "id", "007");
        DataType tPersonCityName = this.makeDataType("009", "name", "007");
        this.index(tCity, tCityId, tCityName, tPerson, tPersonId, tPersonName, tPersonCity, tPersonCityId, tPersonCityName);
        List results = this.searchEngine.search("name");
        Assert.assertTrue((boolean)results.contains(tCity));
        Assert.assertFalse((boolean)results.contains(tCityId));
        Assert.assertTrue((boolean)results.contains(tCityName));
        Assert.assertTrue((boolean)results.contains(tPerson));
        Assert.assertFalse((boolean)results.contains(tPersonId));
        Assert.assertTrue((boolean)results.contains(tPersonName));
        Assert.assertTrue((boolean)results.contains(tPersonCity));
        Assert.assertFalse((boolean)results.contains(tPersonCityId));
        Assert.assertTrue((boolean)results.contains(tPersonCityName));
    }

    @Test
    public void testSearchWhenKeywordIsEmpty() {
        List results = this.searchEngine.search("");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.dataTypeStore});
        Assert.assertTrue((boolean)results.isEmpty());
    }

    private void index(DataType ... dataTypes) {
        for (DataType dataType : dataTypes) {
            this.dataTypeStore.index(dataType.getUUID(), dataType);
        }
    }

    private DataType makeDataType(String uuid, String name, String parentUUID) {
        DataType dataType = (DataType)Mockito.spy((Object)new DataType(null));
        ((DataType)Mockito.doReturn((Object)uuid).when((Object)dataType)).getUUID();
        ((DataType)Mockito.doReturn((Object)name).when((Object)dataType)).getName();
        ((DataType)Mockito.doReturn((Object)parentUUID).when((Object)dataType)).getParentUUID();
        return dataType;
    }
}

