/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.shortcuts;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeListShortcuts;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeListShortcutsView;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeListShortcutsTest {
    @Mock
    private DataTypeList dataTypeList;
    @Mock
    private DataTypeListShortcutsView view;
    @Mock
    private DataTypeListItem listItem;
    @Mock
    private DataTypeUtils dataTypeUtils;
    @Captor
    private ArgumentCaptor<Consumer<DataTypeListItem>> onDataTypeListItemUpdateArgumentCaptor;
    private DataTypeListShortcuts shortcuts;

    @Before
    public void setup() {
        Mockito.when((Object)this.view.getCurrentDataTypeListItem()).thenReturn(Optional.of(this.listItem));
        this.shortcuts = (DataTypeListShortcuts)Mockito.spy((Object)new DataTypeListShortcuts((DataTypeListShortcuts.View)this.view, this.dataTypeUtils));
        this.shortcuts.init(this.dataTypeList);
    }

    @Test
    public void testInit() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DataTypeList actualDataTypeList = this.shortcuts.getDataTypeList();
        DataTypeList expectedDataTypeList = this.shortcuts.getDataTypeList();
        Mockito.when((Object)listItem.getDragAndDropElement()).thenReturn((Object)htmlElement);
        Assert.assertEquals((Object)expectedDataTypeList, (Object)actualDataTypeList);
        ((DataTypeList)Mockito.verify((Object)expectedDataTypeList)).registerDataTypeListItemUpdateCallback((Consumer)this.onDataTypeListItemUpdateArgumentCaptor.capture());
        ((Consumer)this.onDataTypeListItemUpdateArgumentCaptor.getValue()).accept(listItem);
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).highlight((Element)htmlElement);
    }

    @Test
    public void testOnArrowDown() {
        Element nextDataTypeRow = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.view.getNextDataTypeRow()).thenReturn(Optional.of(nextDataTypeRow));
        this.shortcuts.onArrowDown();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).highlight(nextDataTypeRow);
    }

    @Test
    public void testOnArrowUp() {
        Element prevDataTypeRow = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.view.getPrevDataTypeRow()).thenReturn(Optional.of(prevDataTypeRow));
        this.shortcuts.onArrowUp();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).highlight(prevDataTypeRow);
    }

    @Test
    public void testOnTab() {
        Element firstDataTypeRow = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.view.getFirstDataTypeRow()).thenReturn(Optional.of(firstDataTypeRow));
        this.shortcuts.onTab();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).highlight(firstDataTypeRow);
    }

    @Test
    public void testOnArrowLeft() {
        this.shortcuts.onArrowLeft();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).collapse();
    }

    @Test
    public void testOnArrowRight() {
        this.shortcuts.onArrowRight();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).expand();
    }

    @Test
    public void testOnCtrlE() {
        this.shortcuts.onCtrlE();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).enableEditMode();
    }

    @Test
    public void testOnEscapeWhenCurrentDataTypeListItemIsPresent() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.listItem.getDragAndDropElement()).thenReturn((Object)htmlElement);
        this.shortcuts.onEscape();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).disableEditMode();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.shortcuts)).highlight((Element)htmlElement);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.shortcuts, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testOnEscapeWhenCurrentDataTypeListItemIsNotPresent() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataTypeListItem> items = Arrays.asList(listItem1, listItem2);
        Mockito.when((Object)this.view.getCurrentDataTypeListItem()).thenReturn(Optional.empty());
        Mockito.when((Object)this.view.getVisibleDataTypeListItems()).thenReturn(items);
        this.shortcuts.onEscape();
        ((DataTypeListItem)Mockito.verify((Object)listItem1)).disableEditMode();
        ((DataTypeListItem)Mockito.verify((Object)listItem2)).disableEditMode();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.shortcuts, (VerificationMode)Mockito.never())).highlight((Element)ArgumentMatchers.any());
        ((DataTypeListShortcuts)Mockito.verify((Object)this.shortcuts)).reset();
    }

    @Test
    public void testOnBackspace() {
        this.shortcuts.onCtrlBackspace();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).remove();
    }

    @Test
    public void testOnCtrlS() {
        this.shortcuts.onCtrlS();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).saveAndCloseEditMode();
    }

    @Test
    public void testOnCtrlB() {
        this.shortcuts.onCtrlB();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).addDataTypeRow();
    }

    @Test
    public void testOnCtrlU() {
        this.shortcuts.onCtrlU();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).insertFieldAbove();
    }

    @Test
    public void testOnCtrlD() {
        this.shortcuts.onCtrlD();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).insertFieldBelow();
    }

    @Test
    public void testReset() {
        this.shortcuts.reset();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).reset();
    }

    @Test
    public void testFocusIn() {
        this.shortcuts.focusIn();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).focusIn();
    }

    @Test
    public void testHighlight() {
        Element element = (Element)Mockito.mock(Element.class);
        this.shortcuts.highlight(element);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlight(element);
    }

    @Test
    public void testHighlightLevel() {
        Element element = (Element)Mockito.mock(Element.class);
        this.shortcuts.highlightLevel(element);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel(element);
    }

    @Test
    public void testCleanLevelHighlightClass() {
        this.shortcuts.cleanLevelHighlightClass();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).cleanLevelHighlightClass();
    }

    @Test
    public void testCleanHighlightClass() {
        this.shortcuts.cleanHighlightClass();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).cleanHighlightClass();
    }

    @Test
    public void testOnCtrlEWhenDataTypeIsReadOnly() {
        Mockito.when((Object)this.listItem.isReadOnly()).thenReturn((Object)true);
        this.shortcuts.onCtrlE();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).enableEditMode();
    }

    @Test
    public void testOnCtrlBackspaceWhenDataTypeIsReadOnly() {
        Mockito.when((Object)this.listItem.isReadOnly()).thenReturn((Object)true);
        this.shortcuts.onCtrlBackspace();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).remove();
    }

    @Test
    public void testOnCtrlSWhenDataTypeIsReadOnly() {
        Mockito.when((Object)this.listItem.isReadOnly()).thenReturn((Object)true);
        this.shortcuts.onCtrlS();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).saveAndCloseEditMode();
    }

    @Test
    public void testOnCtrlBWhenDataTypeIsReadOnly() {
        Mockito.when((Object)this.listItem.isReadOnly()).thenReturn((Object)true);
        this.shortcuts.onCtrlB();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).insertNestedField();
    }

    @Test
    public void testOnCtrlUWhenDataTypeIsReadOnly() {
        Mockito.when((Object)this.listItem.isReadOnly()).thenReturn((Object)true);
        this.shortcuts.onCtrlU();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).insertFieldAbove();
    }

    @Test
    public void testOnCtrlDWhenDataTypeIsReadOnly() {
        Mockito.when((Object)this.listItem.isReadOnly()).thenReturn((Object)true);
        this.shortcuts.onCtrlD();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).insertFieldBelow();
    }

    @Test
    public void testGetTopLevelParent() {
        DataType expectedDataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.dataTypeUtils.getTopLevelParent(expectedDataType)).thenReturn((Object)expectedDataType);
        DataType actualDataType = this.shortcuts.getTopLevelParent(expectedDataType);
        Assert.assertEquals((Object)expectedDataType, (Object)actualDataType);
    }
}

