/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.shortcuts;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeListShortcuts;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeListShortcutsView;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.selectpicker.JQueryList;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeListShortcutsViewTest {
    @Mock
    private DataTypeListShortcuts presenter;
    @Mock
    private ScrollHelper scrollHelper;
    private DataTypeListShortcutsView view;

    @Before
    public void setup() {
        this.view = (DataTypeListShortcutsView)Mockito.spy((Object)new DataTypeListShortcutsView(this.scrollHelper));
        this.view.init(this.presenter);
    }

    @Test
    public void testGetFirstDataTypeRowWhenFirstRowExists() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        jQueryList.length = 3;
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        Mockito.when((Object)((Element)jQueryList.get(0))).thenReturn((Object)dataTypeRow1);
        Mockito.when((Object)((Element)jQueryList.get(1))).thenReturn((Object)dataTypeRow2);
        Mockito.when((Object)((Element)jQueryList.get(2))).thenReturn((Object)dataTypeRow3);
        Element actual = (Element)this.view.getFirstDataTypeRow().orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)dataTypeRow1, (Object)actual);
    }

    @Test
    public void testGetFirstDataTypeRowWhenFirstRowDoesNotExist() {
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        jQueryList.length = 0;
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        Assert.assertFalse((boolean)this.view.getFirstDataTypeRow().isPresent());
    }

    @Test
    public void testGetNextDataTypeRowWhenElementIsNotTheLastOne() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        jQueryList.length = 3;
        Mockito.when((Object)((Element)jQueryList.get(0))).thenReturn((Object)dataTypeRow1);
        Mockito.when((Object)((Element)jQueryList.get(1))).thenReturn((Object)dataTypeRow2);
        Mockito.when((Object)((Element)jQueryList.get(2))).thenReturn((Object)dataTypeRow3);
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"456").when((Object)this.view)).getCurrentUUID();
        Element actual = (Element)this.view.getNextDataTypeRow().orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)dataTypeRow3, (Object)actual);
    }

    @Test
    public void testGetNextDataTypeRowWhenElementIsTheLastOne() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        jQueryList.length = 3;
        Mockito.when((Object)((Element)jQueryList.get(0))).thenReturn((Object)dataTypeRow1);
        Mockito.when((Object)((Element)jQueryList.get(1))).thenReturn((Object)dataTypeRow2);
        Mockito.when((Object)((Element)jQueryList.get(2))).thenReturn((Object)dataTypeRow3);
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"789").when((Object)this.view)).getCurrentUUID();
        Element actual = (Element)this.view.getNextDataTypeRow().orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)dataTypeRow1, (Object)actual);
    }

    @Test
    public void testGetPrevDataTypeRowWhenElementIsNotTheFirstOne() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        jQueryList.length = 3;
        Mockito.when((Object)((Element)jQueryList.get(0))).thenReturn((Object)dataTypeRow1);
        Mockito.when((Object)((Element)jQueryList.get(1))).thenReturn((Object)dataTypeRow2);
        Mockito.when((Object)((Element)jQueryList.get(2))).thenReturn((Object)dataTypeRow3);
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"456").when((Object)this.view)).getCurrentUUID();
        Element actual = (Element)this.view.getPrevDataTypeRow().orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)dataTypeRow1, (Object)actual);
    }

    @Test
    public void testGetPrevDataTypeRowWhenElementIsTheFirstOne() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        jQueryList.length = 3;
        Mockito.when((Object)((Element)jQueryList.get(0))).thenReturn((Object)dataTypeRow1);
        Mockito.when((Object)((Element)jQueryList.get(1))).thenReturn((Object)dataTypeRow2);
        Mockito.when((Object)((Element)jQueryList.get(2))).thenReturn((Object)dataTypeRow3);
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"123").when((Object)this.view)).getCurrentUUID();
        Element actual = (Element)this.view.getPrevDataTypeRow().orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)dataTypeRow3, (Object)actual);
    }

    @Test
    public void testGetCurrentDataTypeListItem() {
        DataTypeList dataTypeList = (DataTypeList)Mockito.mock(DataTypeList.class);
        DataTypeListItem item = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = this.fakeDataType("123");
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        List<DataTypeListItem> items = Collections.singletonList(item);
        Mockito.when((Object)item.getDataType()).thenReturn((Object)dataType);
        Mockito.when((Object)dataTypeList.getItems()).thenReturn(items);
        Mockito.when((Object)this.presenter.getDataTypeList()).thenReturn((Object)dataTypeList);
        jQueryList.length = 3;
        Mockito.when((Object)((Element)jQueryList.get(0))).thenReturn((Object)dataTypeRow1);
        Mockito.when((Object)((Element)jQueryList.get(1))).thenReturn((Object)dataTypeRow2);
        Mockito.when((Object)((Element)jQueryList.get(2))).thenReturn((Object)dataTypeRow3);
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"123").when((Object)this.view)).getCurrentUUID();
        DataTypeListItem actual = (DataTypeListItem)this.view.getCurrentDataTypeListItem().orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)item, (Object)actual);
    }

    @Test
    public void testGetVisibleDataTypeListItems() {
        DataTypeList dataTypeList = (DataTypeList)Mockito.mock(DataTypeList.class);
        DataTypeListItem item1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem item2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem item3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType1 = this.fakeDataType("123");
        DataType dataType2 = this.fakeDataType("456");
        DataType dataType3 = this.fakeDataType("789");
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        List<DataTypeListItem> items = Arrays.asList(item1, item2, item3);
        JQueryList jQueryList = (JQueryList)Mockito.mock(JQueryList.class);
        Mockito.when((Object)item1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)item2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)item3.getDataType()).thenReturn((Object)dataType3);
        Mockito.when((Object)dataTypeList.getItems()).thenReturn(items);
        Mockito.when((Object)this.presenter.getDataTypeList()).thenReturn((Object)dataTypeList);
        jQueryList.length = 3;
        Mockito.when((Object)((Element)jQueryList.get(0))).thenReturn((Object)dataTypeRow1);
        Mockito.when((Object)((Element)jQueryList.get(1))).thenReturn((Object)dataTypeRow2);
        Mockito.when((Object)((Element)jQueryList.get(2))).thenReturn((Object)dataTypeRow3);
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)jQueryList).when((Object)this.view)).filterVisible();
        List actual = this.view.getVisibleDataTypeListItems();
        List<DataTypeListItem> expected = Arrays.asList(item1, item2, item3);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testHighlight() {
        String uuid = "uuid";
        Element element = this.fakeDataTypeRow("uuid");
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).cleanCurrentHighlight();
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).setCurrentUUID((String)Mockito.any());
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).addHighlightClass((Element)ArgumentMatchers.any());
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).scrollTo((Element)ArgumentMatchers.any());
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).highlightLevel((Element)ArgumentMatchers.any());
        this.view.highlight(element);
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).setCurrentUUID("uuid");
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).addHighlightClass(element);
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).scrollTo(element);
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).highlightLevel(element);
    }

    @Test
    public void testReset() {
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).cleanCurrentHighlight();
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).setCurrentUUID((String)Mockito.any());
        this.view.reset();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).cleanCurrentHighlight();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).setCurrentUUID("");
    }

    @Test
    public void testHighlightLevel() {
        Element element = (Element)Mockito.mock(Element.class);
        this.view.highlightLevel(element);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.presenter)).highlightLevel(element);
    }

    @Test
    public void testCleanCurrentHighlight() {
        this.view.cleanCurrentHighlight();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.presenter)).cleanLevelHighlightClass();
        ((DataTypeListShortcuts)Mockito.verify((Object)this.presenter)).cleanHighlightClass();
    }

    @Test
    public void testAddHighlightClass() {
        Element element = (Element)Mockito.mock(Element.class);
        this.view.addHighlightClass(element);
        ((DataTypeListShortcuts)Mockito.verify((Object)this.presenter)).highlight(element);
    }

    @Test
    public void testScrollTo() {
        Element element = (Element)Mockito.mock(Element.class);
        HTMLElement container = (HTMLElement)Mockito.mock(HTMLElement.class);
        DataTypeList dataTypeList = (DataTypeList)Mockito.mock(DataTypeList.class);
        Mockito.when((Object)this.presenter.getDataTypeList()).thenReturn((Object)dataTypeList);
        Mockito.when((Object)dataTypeList.getListItems()).thenReturn((Object)container);
        this.view.scrollTo(element);
        ((ScrollHelper)Mockito.verify((Object)this.scrollHelper)).scrollTo(element, (Element)container, 20);
    }

    @Test
    public void testSetCurrentUUID() {
        String expectedPreviousUUID = "123";
        String expectedCurrentUUID = "456";
        this.view.setCurrentUUID("123");
        this.view.setCurrentUUID("456");
        String actualPreviousUUID = this.view.getPreviousUUID();
        String actualCurrentUUID = this.view.getCurrentUUID();
        Assert.assertEquals((Object)"123", (Object)actualPreviousUUID);
        Assert.assertEquals((Object)"456", (Object)actualCurrentUUID);
    }

    @Test
    public void testSetCurrentDataTypeRowWhenCurrentUUIDIsBlank() {
        Element element1 = this.fakeDataTypeRow("uuid1");
        Element element2 = this.fakeDataTypeRow("uuid2");
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"uuid1").when((Object)this.view)).getCurrentUUID();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"something").when((Object)this.view)).getPreviousUUID();
        Optional actualElement = this.view.getCurrentDataTypeRow(Arrays.asList(element1, element2));
        Assert.assertEquals((Object)element1, actualElement.get());
    }

    @Test
    public void testSetCurrentDataTypeRowWhenCurrentUUIDIsNotBlank() {
        Element element1 = this.fakeDataTypeRow("uuid1");
        Element element2 = this.fakeDataTypeRow("uuid2");
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"").when((Object)this.view)).getCurrentUUID();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"uuid1").when((Object)this.view)).getPreviousUUID();
        Optional actualElement = this.view.getCurrentDataTypeRow(Arrays.asList(element1, element2));
        Assert.assertEquals((Object)element1, actualElement.get());
    }

    @Test
    public void testFocusInWhenCurrentUUIDIsBlank() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)listItem.getDragAndDropElement()).thenReturn((Object)element);
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"").when((Object)this.view)).getCurrentUUID();
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"uuid").when((Object)this.view)).getPreviousUUID();
        ((DataTypeListShortcutsView)Mockito.doReturn(Optional.of(listItem)).when((Object)this.view)).getDataTypeListItem("uuid");
        ((DataTypeListShortcutsView)Mockito.doNothing().when((Object)this.view)).highlight((Element)ArgumentMatchers.any());
        this.view.focusIn();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view)).highlight((Element)element);
    }

    @Test
    public void testFocusInWhenCurrentUUIDIsNotBlank() {
        ((DataTypeListShortcutsView)Mockito.doReturn((Object)"something").when((Object)this.view)).getCurrentUUID();
        this.view.focusIn();
        ((DataTypeListShortcutsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).highlight((Element)ArgumentMatchers.any());
    }

    @Test
    public void testListsNextWhenItReturnsEmpty() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        List<Element> elements = Arrays.asList(dataTypeRow1, dataTypeRow2, dataTypeRow3);
        Optional actual = this.view.utils.next(elements, dataTypeRow3);
        Assert.assertFalse((boolean)actual.isPresent());
    }

    @Test
    public void testListsNextWhenItReturnsNextElement() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        List<Element> elements = Arrays.asList(dataTypeRow1, dataTypeRow2, dataTypeRow3);
        Optional actual = this.view.utils.next(elements, dataTypeRow2);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)dataTypeRow3, actual.get());
    }

    @Test
    public void testListsPrevWhenItReturnsEmpty() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        List<Element> elements = Arrays.asList(dataTypeRow1, dataTypeRow2, dataTypeRow3);
        Optional actual = this.view.utils.prev(elements, dataTypeRow1);
        Assert.assertFalse((boolean)actual.isPresent());
    }

    @Test
    public void testListsPrevWhenItReturnsPreviousElement() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        List<Element> elements = Arrays.asList(dataTypeRow1, dataTypeRow2, dataTypeRow3);
        Optional actual = this.view.utils.prev(elements, dataTypeRow2);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)dataTypeRow1, actual.get());
    }

    @Test
    public void testListsFirstWhenItReturnsEmpty() {
        Optional actual = this.view.utils.first(Collections.emptyList());
        Assert.assertFalse((boolean)actual.isPresent());
    }

    @Test
    public void testListsFirstWhenItReturnsFirstElement() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        List<Element> elements = Arrays.asList(dataTypeRow1, dataTypeRow2, dataTypeRow3);
        Optional actual = this.view.utils.first(elements);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)dataTypeRow1, actual.get());
    }

    @Test
    public void testListsLastWhenItReturnsEmpty() {
        Optional actual = this.view.utils.last(Collections.emptyList());
        Assert.assertFalse((boolean)actual.isPresent());
    }

    @Test
    public void testListsLastWhenItReturnsLastElement() {
        Element dataTypeRow1 = this.fakeDataTypeRow("123");
        Element dataTypeRow2 = this.fakeDataTypeRow("456");
        Element dataTypeRow3 = this.fakeDataTypeRow("789");
        List<Element> elements = Arrays.asList(dataTypeRow1, dataTypeRow2, dataTypeRow3);
        Optional actual = this.view.utils.last(elements);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)dataTypeRow3, actual.get());
    }

    private DataType fakeDataType(String uuid) {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)uuid);
        return dataType;
    }

    private Element fakeDataTypeRow(String uuid) {
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)element.getAttribute("data-row-uuid")).thenReturn((Object)uuid);
        return element;
    }
}

