/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters.dd;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.styling.StylingSet;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.FontStylingSetPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIColor;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNStyle;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class FontStylingSetPropertyConverterTest {
    @Test
    public void testWbFromDMN() {
        JSIDMNStyle jsiDmnStyle = (JSIDMNStyle)Mockito.mock(JSIDMNStyle.class);
        JSIColor fontColor = (JSIColor)Mockito.mock(JSIColor.class);
        Mockito.when((Object)fontColor.getRed()).thenReturn((Object)10);
        Mockito.when((Object)fontColor.getGreen()).thenReturn((Object)20);
        Mockito.when((Object)fontColor.getBlue()).thenReturn((Object)30);
        String fontFamily = "Arial";
        double fontSize = 11.0;
        Mockito.when((Object)jsiDmnStyle.getFontColor()).thenReturn((Object)fontColor);
        Mockito.when((Object)jsiDmnStyle.getFontFamily()).thenReturn((Object)"Arial");
        Mockito.when((Object)jsiDmnStyle.getFontSize()).thenReturn((Object)11.0);
        StylingSet convertedResult = FontStylingSetPropertyConverter.wbFromDMN((JSIDMNStyle)jsiDmnStyle);
        Assertions.assertThat((String)convertedResult.getFontColour().getValue()).isEqualTo("#0a141e");
        Assertions.assertThat((String)convertedResult.getFontFamily().getValue()).isEqualTo("Arial");
        Assertions.assertThat((Double)convertedResult.getFontSize().getValue()).isEqualTo(11.0);
    }
}

