/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeConnector;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIBounds;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=LienzoMockitoTestRunner.class)
public class NodeConnectorTest {
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private JSITDMNElement jsiDMNElement;
    @Mock
    private JSITDMNElementReference jsiDMNElementReference;
    @Mock
    private NodeEntry nodeEntry;
    @Mock
    private Node currentNode;
    @Mock
    private Node requiredNode;
    private NodeConnector nodeConnector;
    private String connectorTypeId = BindableAdapterUtils.getDefinitionId(InformationRequirement.class);
    private Map<String, List<NodeEntry>> entriesById = new HashMap<String, List<NodeEntry>>();
    private List<JSIDMNEdge> edges = new ArrayList<JSIDMNEdge>();
    private String diagramId = "diagramId";
    private boolean isDMNDIPresent = false;

    @Before
    public void setup() {
        this.nodeConnector = (NodeConnector)Mockito.spy((Object)new NodeConnector(this.factoryManager));
    }

    @Test
    public void testConnectEdgeToNodesWhenDMNDIIsNotPresent() {
        JSIDMNEdge newEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        Mockito.when((Object)this.jsiDMNElement.getId()).thenReturn((Object)"789");
        Mockito.when((Object)this.nodeEntry.getNode()).thenReturn((Object)this.requiredNode);
        View view = (View)Mockito.mock(View.class);
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        Mockito.when((Object)bounds.getHeight()).thenReturn((Object)50.0);
        Mockito.when((Object)bounds.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)this.requiredNode.getContent()).thenReturn((Object)view);
        ((NodeConnector)Mockito.doReturn((Object)"456").when((Object)this.nodeConnector)).uuid();
        ((NodeConnector)Mockito.doReturn((Object)newEdge).when((Object)this.nodeConnector)).newEdge(50.0, 25.0);
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.entriesById.put("123", Collections.singletonList(this.nodeEntry));
        this.isDMNDIPresent = false;
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.eq((Object)this.connectorTypeId), (String)ArgumentMatchers.eq((Object)this.diagramId), (Node)ArgumentMatchers.eq((Object)this.currentNode), (Node)ArgumentMatchers.eq((Object)this.requiredNode), (JSIDMNEdge)ArgumentMatchers.eq((Object)newEdge), (String)ArgumentMatchers.eq((Object)"456"));
    }

    @Test
    public void testConnectEdgeToNodesWhenDMNDIIsPresent() {
        JSIDMNEdge existingEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        String id = "789";
        String contentDefinitionId = "123";
        List<NodeEntry> list = Collections.singletonList(this.nodeEntry);
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        Mockito.when((Object)this.jsiDMNElement.getId()).thenReturn((Object)"789");
        Mockito.when((Object)existingEdge.getDmnElementRef()).thenReturn((Object)new QName("", "789"));
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)this.currentNode.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)drgElement.getContentDefinitionId()).thenReturn((Object)"123");
        ((NodeConnector)Mockito.doReturn((Object)true).when((Object)this.nodeConnector)).isEdgeConnectedWithNode((JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (Node)ArgumentMatchers.eq((Object)this.currentNode), (List)ArgumentMatchers.eq(list));
        ((NodeConnector)Mockito.doReturn(Optional.of(this.requiredNode)).when((Object)this.nodeConnector)).getSourceNode((JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (List)ArgumentMatchers.any());
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.entriesById.put("123", list);
        this.edges.add(existingEdge);
        this.isDMNDIPresent = true;
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.eq((Object)this.connectorTypeId), (String)ArgumentMatchers.eq((Object)this.diagramId), (Node)ArgumentMatchers.eq((Object)this.currentNode), (Node)ArgumentMatchers.eq((Object)this.requiredNode), (JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (String)ArgumentMatchers.eq((Object)"789"));
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).isEdgeConnectedWithNode((JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (Node)ArgumentMatchers.eq((Object)this.currentNode), (List)ArgumentMatchers.eq(list));
    }

    @Test
    public void testConnectEdgeToNodesWhenDMNDIIsPresentAndNodeIsNotConnectedWithEdge() {
        JSIDMNEdge existingEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        String id = "789";
        String contentDefinitionId = "123";
        List<NodeEntry> list = Collections.singletonList(this.nodeEntry);
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        Mockito.when((Object)this.jsiDMNElement.getId()).thenReturn((Object)"789");
        Mockito.when((Object)existingEdge.getDmnElementRef()).thenReturn((Object)new QName("", "789"));
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)this.currentNode.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)drgElement.getContentDefinitionId()).thenReturn((Object)"123");
        ((NodeConnector)Mockito.doReturn((Object)false).when((Object)this.nodeConnector)).isEdgeConnectedWithNode((JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (Node)ArgumentMatchers.eq((Object)this.currentNode), (List)ArgumentMatchers.eq(list));
        ((NodeConnector)Mockito.doReturn(Optional.of(this.requiredNode)).when((Object)this.nodeConnector)).getSourceNode((JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (List)ArgumentMatchers.any());
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.entriesById.put("123", list);
        this.edges.add(existingEdge);
        this.isDMNDIPresent = true;
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector, (VerificationMode)Mockito.never())).connectWbEdge((String)ArgumentMatchers.eq((Object)this.connectorTypeId), (String)ArgumentMatchers.eq((Object)this.diagramId), (Node)ArgumentMatchers.eq((Object)this.currentNode), (Node)ArgumentMatchers.eq((Object)this.requiredNode), (JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (String)ArgumentMatchers.eq((Object)"789"));
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).isEdgeConnectedWithNode((JSIDMNEdge)ArgumentMatchers.eq((Object)existingEdge), (Node)ArgumentMatchers.eq((Object)this.currentNode), (List)ArgumentMatchers.eq(list));
    }

    @Test
    public void testConnectEdgeToNodesWhenDMNDIIsPresentButExistingNodeIsNotPresent() {
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        Mockito.when((Object)this.jsiDMNElement.getId()).thenReturn((Object)"789");
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.entriesById.put("123", Collections.singletonList(this.nodeEntry));
        this.isDMNDIPresent = true;
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector, (VerificationMode)Mockito.never())).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testConnectEdgeToNodesWhenNodeEntriesIsEmpty() {
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#123");
        this.entriesById.put("123", new ArrayList());
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector, (VerificationMode)Mockito.never())).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testConnectEdgeToNodesWhenNodeEntriesIsNull() {
        Mockito.when((Object)this.jsiDMNElementReference.getHref()).thenReturn((Object)"#456");
        this.nodeConnector.connectEdgeToNodes(this.connectorTypeId, this.jsiDMNElement, this.jsiDMNElementReference, this.entriesById, this.diagramId, this.edges, this.isDMNDIPresent, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector, (VerificationMode)Mockito.never())).connectWbEdge((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testConnectWbEdge() {
        JSIDMNEdge edge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Element element = (Element)Mockito.mock(Element.class);
        String id = "123";
        Edge wbEdge = (Edge)Mockito.mock(Edge.class);
        ViewConnector viewConnector = (ViewConnector)Mockito.mock(ViewConnector.class);
        Mockito.when((Object)this.factoryManager.newElement("diagramId#123", this.connectorTypeId)).thenReturn((Object)element);
        Mockito.when((Object)element.asEdge()).thenReturn((Object)wbEdge);
        Mockito.when((Object)wbEdge.getContent()).thenReturn((Object)viewConnector);
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).connectEdge((Edge)ArgumentMatchers.any(), (Node)ArgumentMatchers.any(), (Node)ArgumentMatchers.any());
        ((NodeConnector)Mockito.doNothing().when((Object)this.nodeConnector)).setConnectionMagnets((Edge)ArgumentMatchers.any(), (ViewConnector)ArgumentMatchers.any(), (JSIDMNEdge)ArgumentMatchers.any());
        this.nodeConnector.connectWbEdge(this.connectorTypeId, this.diagramId, this.currentNode, this.requiredNode, edge, "123");
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).connectEdge(wbEdge, this.requiredNode, this.currentNode);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).setConnectionMagnets(wbEdge, viewConnector, edge);
    }

    @Test
    public void testSetConnectionMagnets() {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        ViewConnector viewConnector = (ViewConnector)Mockito.mock(ViewConnector.class);
        JSIDMNEdge jsidmnEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Node sourceNode = (Node)Mockito.mock(Node.class);
        Node targetNode = (Node)Mockito.mock(Node.class);
        View view = (View)Mockito.mock(View.class);
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        JSIPoint start = (JSIPoint)Mockito.mock(JSIPoint.class);
        JSIPoint waypoint = (JSIPoint)Mockito.mock(JSIPoint.class);
        JSIPoint end = (JSIPoint)Mockito.mock(JSIPoint.class);
        ArrayList<JSIPoint> waypoints = new ArrayList<JSIPoint>();
        waypoints.add(start);
        waypoints.add(waypoint);
        waypoints.add(end);
        NodeConnector nodeConnector = (NodeConnector)Mockito.mock(NodeConnector.class);
        ((NodeConnector)Mockito.doCallRealMethod().when((Object)nodeConnector)).setConnectionMagnets((Edge)ArgumentMatchers.eq((Object)edge), (ViewConnector)ArgumentMatchers.eq((Object)viewConnector), (JSIDMNEdge)ArgumentMatchers.eq((Object)jsidmnEdge));
        Mockito.when((Object)jsidmnEdge.getWaypoint()).thenReturn(waypoints);
        Mockito.when((Object)jsidmnEdge.getId()).thenReturn((Object)"-AUTO-SOURCE-AUTO-TARGET");
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)sourceNode);
        Mockito.when((Object)edge.getTargetNode()).thenReturn((Object)targetNode);
        Mockito.when((Object)sourceNode.getContent()).thenReturn((Object)view);
        Mockito.when((Object)targetNode.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)bounds.getWidth()).thenReturn((Object)0.0);
        Mockito.when((Object)bounds.getHeight()).thenReturn((Object)0.0);
        Mockito.when((Object)start.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)start.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)waypoint.getX()).thenReturn((Object)1.0);
        Mockito.when((Object)waypoint.getY()).thenReturn((Object)1.0);
        Mockito.when((Object)start.getX()).thenReturn((Object)1.0);
        Mockito.when((Object)start.getY()).thenReturn((Object)1.0);
        nodeConnector.setConnectionMagnets(edge, viewConnector, jsidmnEdge);
        ((NodeConnector)Mockito.verify((Object)nodeConnector)).isSourceAutoConnectionEdge(jsidmnEdge);
        ((NodeConnector)Mockito.verify((Object)nodeConnector)).isTargetAutoConnectionEdge(jsidmnEdge);
        ((ViewConnector)Mockito.verify((Object)viewConnector)).setControlPoints((ControlPoint[])ArgumentMatchers.any());
    }

    @Test
    public void testIsSourceAutoConnectionEdge() {
        String edgeId = "edge-name";
        JSIDMNEdge edge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)edge.getId()).thenReturn((Object)edgeId);
        Assert.assertFalse((boolean)this.nodeConnector.isSourceAutoConnectionEdge(edge));
        Mockito.when((Object)edge.getId()).thenReturn((Object)(edgeId + "-AUTO-SOURCE"));
        Assert.assertTrue((boolean)this.nodeConnector.isSourceAutoConnectionEdge(edge));
    }

    @Test
    public void testIsTargetAutoConnectionEdge() {
        String edgeId = "edge-name";
        JSIDMNEdge edge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)edge.getId()).thenReturn((Object)edgeId);
        Assert.assertFalse((boolean)this.nodeConnector.isTargetAutoConnectionEdge(edge));
        Mockito.when((Object)edge.getId()).thenReturn((Object)(edgeId + "-AUTO-TARGET"));
        Assert.assertTrue((boolean)this.nodeConnector.isTargetAutoConnectionEdge(edge));
    }

    @Test
    public void testIsAutoConnection() {
        String id = "DMNEdge-ID";
        String autoConnectionID = "#AUTO-CONNECTION";
        JSIDMNEdge jsiDMNEdge1 = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)jsiDMNEdge1.getId()).thenReturn((Object)id);
        JSIDMNEdge jsiDMNEdge2 = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)jsiDMNEdge2.getId()).thenReturn((Object)(id + autoConnectionID));
        JSIDMNEdge jsiDMNEdge3 = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        Mockito.when((Object)jsiDMNEdge3.getId()).thenReturn(null);
        Assert.assertFalse((boolean)this.nodeConnector.isAutoConnection(jsiDMNEdge1, autoConnectionID));
        Assert.assertTrue((boolean)this.nodeConnector.isAutoConnection(jsiDMNEdge2, autoConnectionID));
        Assert.assertFalse((boolean)this.nodeConnector.isAutoConnection(jsiDMNEdge3, autoConnectionID));
    }

    @Test
    public void testIsEdgeConnectedWithNode() {
        JSIDMNEdge jsiDMNEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        List nodeEntries = (List)Mockito.mock(List.class);
        Node targetNode = (Node)Mockito.mock(Node.class);
        Node sourceNode = (Node)Mockito.mock(Node.class);
        ((NodeConnector)Mockito.doReturn(Optional.of(targetNode)).when((Object)this.nodeConnector)).getTargetNode(jsiDMNEdge, nodeEntries);
        ((NodeConnector)Mockito.doReturn(Optional.of(sourceNode)).when((Object)this.nodeConnector)).getSourceNode(jsiDMNEdge, nodeEntries);
        Assert.assertFalse((boolean)this.nodeConnector.isEdgeConnectedWithNode(jsiDMNEdge, this.currentNode, nodeEntries));
    }

    @Test
    public void testIsEdgeConnectedWithNode_WhenIsConnectedBySource() {
        JSIDMNEdge jsiDMNEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        List nodeEntries = (List)Mockito.mock(List.class);
        Node targetNode = (Node)Mockito.mock(Node.class);
        ((NodeConnector)Mockito.doReturn(Optional.of(targetNode)).when((Object)this.nodeConnector)).getTargetNode(jsiDMNEdge, nodeEntries);
        ((NodeConnector)Mockito.doReturn(Optional.of(this.currentNode)).when((Object)this.nodeConnector)).getSourceNode(jsiDMNEdge, nodeEntries);
        Assert.assertTrue((boolean)this.nodeConnector.isEdgeConnectedWithNode(jsiDMNEdge, this.currentNode, nodeEntries));
    }

    @Test
    public void testIsEdgeConnectedWithNode_WhenIsConnectedByTarget() {
        JSIDMNEdge jsiDMNEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        List nodeEntries = (List)Mockito.mock(List.class);
        Node sourceNode = (Node)Mockito.mock(Node.class);
        ((NodeConnector)Mockito.doReturn(Optional.of(this.currentNode)).when((Object)this.nodeConnector)).getTargetNode(jsiDMNEdge, nodeEntries);
        ((NodeConnector)Mockito.doReturn(Optional.of(sourceNode)).when((Object)this.nodeConnector)).getSourceNode(jsiDMNEdge, nodeEntries);
        Assert.assertTrue((boolean)this.nodeConnector.isEdgeConnectedWithNode(jsiDMNEdge, this.currentNode, nodeEntries));
    }

    @Test
    public void testGetTargetNode_WhenThereIsOnlyASingleNode() {
        JSIDMNEdge jsiDMNEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        NodeEntry nodeEntry = (NodeEntry)Mockito.mock(NodeEntry.class);
        Node node = (Node)Mockito.mock(Node.class);
        List<NodeEntry> nodeEntries = Collections.singletonList(nodeEntry);
        Mockito.when((Object)nodeEntry.getNode()).thenReturn((Object)node);
        Optional targetNode = this.nodeConnector.getTargetNode(jsiDMNEdge, nodeEntries);
        Assert.assertTrue((boolean)targetNode.isPresent());
        Assert.assertEquals(targetNode.get(), (Object)node);
    }

    @Test
    public void testGetSourceNode_WhenThereIsOnlyASingleNode() {
        JSIDMNEdge jsiDMNEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        NodeEntry nodeEntry = (NodeEntry)Mockito.mock(NodeEntry.class);
        Node node = (Node)Mockito.mock(Node.class);
        List<NodeEntry> nodeEntries = Collections.singletonList(nodeEntry);
        Mockito.when((Object)nodeEntry.getNode()).thenReturn((Object)node);
        Optional sourceNode = this.nodeConnector.getSourceNode(jsiDMNEdge, nodeEntries);
        Assert.assertTrue((boolean)sourceNode.isPresent());
        Assert.assertEquals(sourceNode.get(), (Object)node);
    }

    @Test
    public void testGetSourceNode() {
        JSIDMNEdge jsiDMNEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        double sourceX = 1.0;
        double sourceY = 2.0;
        JSIPoint sourcePoint = this.createPoint(1.0, 2.0);
        JSIPoint targetPoint = this.createPoint(7.0, 8.0);
        List<JSIPoint> waypoints = Arrays.asList(sourcePoint, targetPoint);
        List nodeEntries = (List)Mockito.mock(List.class);
        Point2D sourcePoint2D = new Point2D(1.0, 2.0);
        Mockito.when((Object)jsiDMNEdge.getWaypoint()).thenReturn(waypoints);
        ((NodeConnector)Mockito.doReturn(Optional.of((Node)Mockito.mock(Node.class))).when((Object)this.nodeConnector)).getNodeFromPoint(sourcePoint2D, nodeEntries);
        this.nodeConnector.getSourceNode(jsiDMNEdge, nodeEntries);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).getNodeFromPoint(sourcePoint2D, nodeEntries);
    }

    @Test
    public void testGetTargetNode() {
        JSIDMNEdge jsiDMNEdge = (JSIDMNEdge)Mockito.mock(JSIDMNEdge.class);
        double targetX = 7.0;
        double targetY = 8.0;
        JSIPoint sourcePoint = this.createPoint(1.0, 2.0);
        JSIPoint targetPoint = this.createPoint(7.0, 8.0);
        List<JSIPoint> waypoints = Arrays.asList(sourcePoint, targetPoint);
        List nodeEntries = (List)Mockito.mock(List.class);
        Point2D targetPoint2D = new Point2D(7.0, 8.0);
        Mockito.when((Object)jsiDMNEdge.getWaypoint()).thenReturn(waypoints);
        ((NodeConnector)Mockito.doReturn(Optional.of((Node)Mockito.mock(Node.class))).when((Object)this.nodeConnector)).getNodeFromPoint(targetPoint2D, nodeEntries);
        this.nodeConnector.getTargetNode(jsiDMNEdge, nodeEntries);
        ((NodeConnector)Mockito.verify((Object)this.nodeConnector)).getNodeFromPoint(targetPoint2D, nodeEntries);
    }

    @Test
    public void testIsPointInsideNode() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(10.0, 320.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertTrue((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WithXUnderTolerance() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(-1.0, 320.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertTrue((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WithXOverTolerance() {
        double height = 100.0;
        double width = 50.0;
        double x = 70.0;
        double y = 300.0;
        Point2D point = new Point2D(121.0, 320.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(70.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertTrue((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WithYUnderTolerance() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(10.0, 299.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertTrue((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WithYOverTolerance() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(10.0, 401.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertTrue((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WhenXIsOverBounds() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(1000.0, 320.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertFalse((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WhenYIsOverBounds() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(10.0, 1320.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertFalse((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WhenXAndYAreOverBounds() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(1000.0, 1320.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertFalse((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WhenXIsUnderBounds() {
        double width = 50.0;
        double height = 100.0;
        double x = 10.0;
        double y = 300.0;
        Point2D point = new Point2D(8.0, 320.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(10.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertFalse((boolean)isInsideNode);
    }

    @Test
    public void testIsPointInsideNode_WhenYIsUnderBounds() {
        double height = 100.0;
        double width = 50.0;
        double x = 0.0;
        double y = 300.0;
        Point2D point = new Point2D(10.0, 290.0);
        NodeEntry nodeEntry = this.createNodeEntryWithBounds(0.0, 300.0, 50.0, 100.0);
        boolean isInsideNode = this.nodeConnector.isPointInsideNode(nodeEntry, point);
        Assert.assertFalse((boolean)isInsideNode);
    }

    NodeEntry createNodeEntryWithBounds(double x, double y, double width, double height) {
        NodeEntry nodeEntry = (NodeEntry)Mockito.mock(NodeEntry.class);
        JSIDMNShape shape = (JSIDMNShape)Mockito.mock(JSIDMNShape.class);
        JSIBounds bounds = (JSIBounds)Mockito.mock(JSIBounds.class);
        Mockito.when((Object)bounds.getHeight()).thenReturn((Object)height);
        Mockito.when((Object)bounds.getWidth()).thenReturn((Object)width);
        Mockito.when((Object)bounds.getX()).thenReturn((Object)x);
        Mockito.when((Object)bounds.getY()).thenReturn((Object)y);
        Mockito.when((Object)nodeEntry.getDmnShape()).thenReturn((Object)shape);
        Mockito.when((Object)shape.getBounds()).thenReturn((Object)bounds);
        return nodeEntry;
    }

    private JSIPoint createPoint(double x, double y) {
        JSIPoint point = (JSIPoint)Mockito.mock(JSIPoint.class);
        Mockito.when((Object)point.getX()).thenReturn((Object)x);
        Mockito.when((Object)point.getY()).thenReturn((Object)y);
        return point;
    }
}

