/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.property.dmn.QNameFieldDefinition;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.HasPlaceHolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class QNameFieldDefinitionTest {
    private static final String PLACE_HOLDER = "place-holder";
    @Mock
    private PlaceHolderFieldDefinition other;
    private QNameFieldDefinition definition;

    @Before
    public void setup() {
        this.definition = (QNameFieldDefinition)Mockito.spy((Object)new QNameFieldDefinition());
    }

    @Test
    public void testGetFieldType() {
        Assert.assertEquals((Object)QNameFieldDefinition.FIELD_TYPE, (Object)this.definition.getFieldType());
    }

    @Test
    public void testPlaceHolder() {
        this.definition.setPlaceHolder(PLACE_HOLDER);
        Assert.assertEquals((Object)PLACE_HOLDER, (Object)this.definition.getPlaceHolder());
    }

    @Test
    public void testDoCopyFromWhenDoesSupportPlaceHolder() {
        Mockito.when((Object)this.other.getPlaceHolder()).thenReturn((Object)PLACE_HOLDER);
        this.definition.doCopyFrom((FieldDefinition)this.other);
        ((QNameFieldDefinition)Mockito.verify((Object)this.definition)).setPlaceHolder((String)ArgumentMatchers.eq((Object)PLACE_HOLDER));
    }

    @Test
    public void testDoCopyFromWhenDoesNotSupportPlaceHolder() {
        FieldDefinition other = (FieldDefinition)Mockito.mock(FieldDefinition.class);
        this.definition.doCopyFrom(other);
        ((QNameFieldDefinition)Mockito.verify((Object)this.definition, (VerificationMode)Mockito.never())).setPlaceHolder((String)Mockito.any());
    }

    public static interface PlaceHolderFieldDefinition
    extends FieldDefinition,
    HasPlaceHolder {
    }
}

