/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.factory;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.DMNDefinition;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.client.shape.factory.DMNConnectorShapeFactory;
import org.kie.workbench.common.dmn.client.shape.factory.DMNDecisionServiceShapeFactory;
import org.kie.workbench.common.dmn.client.shape.factory.DMNShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.DelegateShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.svg.client.shape.factory.SVGShapeFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNShapeFactoryTest {
    private static final String DEFINITION_ID = "definition-id";
    @Mock
    private SVGShapeFactory svgShapeFactory;
    @Mock
    private DMNConnectorShapeFactory dmnConnectorShapeFactory;
    @Mock
    private DMNDecisionServiceShapeFactory dmnDecisionServiceShapeFactory;
    @Mock
    private DelegateShapeFactory<DMNDefinition, Shape> delegateShapeFactory;
    @Mock
    private DMNDefinition definition;
    @Captor
    private ArgumentCaptor<Supplier> shapeDefFactoryCaptor;
    private DMNShapeFactory factory;

    @Before
    public void setup() {
        this.factory = new DMNShapeFactory(this.svgShapeFactory, this.dmnConnectorShapeFactory, this.dmnDecisionServiceShapeFactory, this.delegateShapeFactory);
        Mockito.when((Object)this.delegateShapeFactory.delegate((Class)Mockito.any(), (ShapeDef)Mockito.any(), (Supplier)Mockito.any())).thenReturn(this.delegateShapeFactory);
    }

    @Test
    public void testInit() {
        this.factory.init();
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(DMNDiagram.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(InputData.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(KnowledgeSource.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(BusinessKnowledgeModel.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(Decision.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(TextAnnotation.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.svgShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(Association.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(AuthorityRequirement.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(InformationRequirement.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(KnowledgeRequirement.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnConnectorShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).delegate((Class)ArgumentMatchers.eq(DecisionService.class), (ShapeDef)Mockito.any(), (Supplier)this.shapeDefFactoryCaptor.capture());
        Assert.assertEquals((Object)this.dmnDecisionServiceShapeFactory, ((Supplier)this.shapeDefFactoryCaptor.getValue()).get());
    }

    @Test
    public void testNewShape() {
        this.factory.newShape(this.definition);
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).newShape((Object)this.definition);
    }

    @Test
    public void testGetGlyph() {
        this.factory.getGlyph(DEFINITION_ID);
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).getGlyph(DEFINITION_ID);
    }

    @Test
    public void testGetGlyphWithConsumer() {
        this.factory.getGlyph(DEFINITION_ID, ShapeFactory.GlyphConsumer.class);
        ((DelegateShapeFactory)Mockito.verify(this.delegateShapeFactory)).getGlyph(DEFINITION_ID, ShapeFactory.GlyphConsumer.class);
    }
}

