/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELSuggestions;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoSuggestionsPropertyFactory;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.Candidate;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.CompletionItemKind;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.feel.FEELLanguageService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class MonacoSuggestionsPropertyFactoryTest {
    @Mock
    private MonacoFEELSuggestions monacoFEELSuggestions;
    @Captor
    private ArgumentCaptor<Candidate> candidateArgumentCaptor;
    private MonacoSuggestionsPropertyFactory suggestionsPropertyFactory;

    @Before
    public void setup() {
        this.suggestionsPropertyFactory = (MonacoSuggestionsPropertyFactory)Mockito.spy((Object)new MonacoSuggestionsPropertyFactory(this.monacoFEELSuggestions));
    }

    @Test
    public void testCreate() {
        String expression = "1 +";
        FEELLanguageService.Position position = new FEELLanguageService.Position(1, 3);
        JSONValue jsonValue = (JSONValue)Mockito.mock(JSONValue.class);
        JSONArray expectedSuggestions = (JSONArray)Mockito.mock(JSONArray.class);
        Mockito.when((Object)this.monacoFEELSuggestions.getCandidates("1 +", position)).thenReturn(Arrays.asList(new Candidate("Decision-1", CompletionItemKind.Variable), new Candidate("else", CompletionItemKind.Keyword), new Candidate("custom(value)", "custom($1)", CompletionItemKind.Function), new Candidate("code(value)", "code($1)", CompletionItemKind.Function)));
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)expectedSuggestions).when((Object)this.suggestionsPropertyFactory)).makeJSONArray();
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)jsonValue).when((Object)this.suggestionsPropertyFactory)).getSuggestion((Candidate)this.candidateArgumentCaptor.capture(), ArgumentMatchers.anyInt());
        JSONArray actualSuggestions = this.suggestionsPropertyFactory.create("1 +", position);
        List captorAllValues = this.candidateArgumentCaptor.getAllValues();
        Assert.assertEquals((Object)"Decision-1", (Object)((Candidate)captorAllValues.get(0)).getLabel());
        Assert.assertEquals((Object)"else", (Object)((Candidate)captorAllValues.get(1)).getLabel());
        Assert.assertEquals((Object)"custom(value)", (Object)((Candidate)captorAllValues.get(2)).getLabel());
        Assert.assertEquals((Object)"code(value)", (Object)((Candidate)captorAllValues.get(3)).getLabel());
        Assert.assertEquals((Object)"abs(duration)", (Object)((Candidate)captorAllValues.get(4)).getLabel());
        Assert.assertEquals((Object)"abs(number)", (Object)((Candidate)captorAllValues.get(5)).getLabel());
        Assert.assertEquals((Object)"after(range, value)", (Object)((Candidate)captorAllValues.get(6)).getLabel());
        Assert.assertEquals((Object)"after(range1, range2)", (Object)((Candidate)captorAllValues.get(7)).getLabel());
        Assert.assertEquals((Object)"after(value, range)", (Object)((Candidate)captorAllValues.get(8)).getLabel());
        Assert.assertEquals((Object)"after(value1, value2)", (Object)((Candidate)captorAllValues.get(9)).getLabel());
        Assert.assertEquals((Object)"all(b)", (Object)((Candidate)captorAllValues.get(10)).getLabel());
        Assert.assertEquals((Object)"all(list)", (Object)((Candidate)captorAllValues.get(11)).getLabel());
        Assert.assertEquals((Object)"any(b)", (Object)((Candidate)captorAllValues.get(12)).getLabel());
        Assert.assertEquals((Object)"any(list)", (Object)((Candidate)captorAllValues.get(13)).getLabel());
        Assert.assertEquals((Object)"append(list, item)", (Object)((Candidate)captorAllValues.get(14)).getLabel());
        Assert.assertEquals((Object)"before(range, value)", (Object)((Candidate)captorAllValues.get(15)).getLabel());
        Assert.assertEquals((Object)"before(range1, range2)", (Object)((Candidate)captorAllValues.get(16)).getLabel());
        Assert.assertEquals((Object)"before(value, range)", (Object)((Candidate)captorAllValues.get(17)).getLabel());
        Assert.assertEquals((Object)"before(value1, value2)", (Object)((Candidate)captorAllValues.get(18)).getLabel());
        Assert.assertEquals((Object)"ceiling(n)", (Object)((Candidate)captorAllValues.get(19)).getLabel());
        Assert.assertEquals((Object)"coincides(range1, range2)", (Object)((Candidate)captorAllValues.get(20)).getLabel());
        Assert.assertEquals((Object)"coincides(value1, value2)", (Object)((Candidate)captorAllValues.get(21)).getLabel());
        Assert.assertEquals((Object)"concatenate(list)", (Object)((Candidate)captorAllValues.get(22)).getLabel());
        Assert.assertEquals((Object)"contains(string, match)", (Object)((Candidate)captorAllValues.get(23)).getLabel());
        Assert.assertEquals((Object)"count(c)", (Object)((Candidate)captorAllValues.get(24)).getLabel());
        Assert.assertEquals((Object)"count(list)", (Object)((Candidate)captorAllValues.get(25)).getLabel());
        Assert.assertEquals((Object)"date and time(date, time)", (Object)((Candidate)captorAllValues.get(26)).getLabel());
        Assert.assertEquals((Object)"date and time(from)", (Object)((Candidate)captorAllValues.get(27)).getLabel());
        Assert.assertEquals((Object)"date and time(year, month, day, hour, minute, second)", (Object)((Candidate)captorAllValues.get(28)).getLabel());
        Assert.assertEquals((Object)"date and time(year, month, day, hour, minute, second, hour offset)", (Object)((Candidate)captorAllValues.get(29)).getLabel());
        Assert.assertEquals((Object)"date and time(year, month, day, hour, minute, second, timezone)", (Object)((Candidate)captorAllValues.get(30)).getLabel());
        Assert.assertEquals((Object)"date(from)", (Object)((Candidate)captorAllValues.get(31)).getLabel());
        Assert.assertEquals((Object)"date(year, month, day)", (Object)((Candidate)captorAllValues.get(32)).getLabel());
        Assert.assertEquals((Object)"day of week(date)", (Object)((Candidate)captorAllValues.get(33)).getLabel());
        Assert.assertEquals((Object)"day of year(date)", (Object)((Candidate)captorAllValues.get(34)).getLabel());
        Assert.assertEquals((Object)"decimal(n, scale)", (Object)((Candidate)captorAllValues.get(35)).getLabel());
        Assert.assertEquals((Object)"decision table(ctx, outputs, input expression list, input values list, output values, rule list, hit policy, default output value)", (Object)((Candidate)captorAllValues.get(36)).getLabel());
        Assert.assertEquals((Object)"distinct values(list)", (Object)((Candidate)captorAllValues.get(37)).getLabel());
        Assert.assertEquals((Object)"duration(from)", (Object)((Candidate)captorAllValues.get(38)).getLabel());
        Assert.assertEquals((Object)"during(range1, range2)", (Object)((Candidate)captorAllValues.get(39)).getLabel());
        Assert.assertEquals((Object)"during(value, range)", (Object)((Candidate)captorAllValues.get(40)).getLabel());
        Assert.assertEquals((Object)"ends with(string, match)", (Object)((Candidate)captorAllValues.get(41)).getLabel());
        Assert.assertEquals((Object)"even(number)", (Object)((Candidate)captorAllValues.get(42)).getLabel());
        Assert.assertEquals((Object)"exp(number)", (Object)((Candidate)captorAllValues.get(43)).getLabel());
        Assert.assertEquals((Object)"finished by(range, value)", (Object)((Candidate)captorAllValues.get(44)).getLabel());
        Assert.assertEquals((Object)"finished by(range1, range2)", (Object)((Candidate)captorAllValues.get(45)).getLabel());
        Assert.assertEquals((Object)"finishes(range1, range2)", (Object)((Candidate)captorAllValues.get(46)).getLabel());
        Assert.assertEquals((Object)"finishes(value, range)", (Object)((Candidate)captorAllValues.get(47)).getLabel());
        Assert.assertEquals((Object)"flatten(list)", (Object)((Candidate)captorAllValues.get(48)).getLabel());
        Assert.assertEquals((Object)"floor(n)", (Object)((Candidate)captorAllValues.get(49)).getLabel());
        Assert.assertEquals((Object)"get entries(m)", (Object)((Candidate)captorAllValues.get(50)).getLabel());
        Assert.assertEquals((Object)"get value(m, key)", (Object)((Candidate)captorAllValues.get(51)).getLabel());
        Assert.assertEquals((Object)"includes(range, value)", (Object)((Candidate)captorAllValues.get(52)).getLabel());
        Assert.assertEquals((Object)"includes(range1, range2)", (Object)((Candidate)captorAllValues.get(53)).getLabel());
        Assert.assertEquals((Object)"index of(list, match)", (Object)((Candidate)captorAllValues.get(54)).getLabel());
        Assert.assertEquals((Object)"insert before(list, position, newItem)", (Object)((Candidate)captorAllValues.get(55)).getLabel());
        Assert.assertEquals((Object)"invoke(ctx, namespace, model name, decision name, parameters)", (Object)((Candidate)captorAllValues.get(56)).getLabel());
        Assert.assertEquals((Object)"list contains(list, element)", (Object)((Candidate)captorAllValues.get(57)).getLabel());
        Assert.assertEquals((Object)"log(number)", (Object)((Candidate)captorAllValues.get(58)).getLabel());
        Assert.assertEquals((Object)"lower case(string)", (Object)((Candidate)captorAllValues.get(59)).getLabel());
        Assert.assertEquals((Object)"matches(input, pattern)", (Object)((Candidate)captorAllValues.get(60)).getLabel());
        Assert.assertEquals((Object)"matches(input, pattern, flags)", (Object)((Candidate)captorAllValues.get(61)).getLabel());
        Assert.assertEquals((Object)"max(c)", (Object)((Candidate)captorAllValues.get(62)).getLabel());
        Assert.assertEquals((Object)"max(list)", (Object)((Candidate)captorAllValues.get(63)).getLabel());
        Assert.assertEquals((Object)"mean(list)", (Object)((Candidate)captorAllValues.get(64)).getLabel());
        Assert.assertEquals((Object)"mean(n)", (Object)((Candidate)captorAllValues.get(65)).getLabel());
        Assert.assertEquals((Object)"median(list)", (Object)((Candidate)captorAllValues.get(66)).getLabel());
        Assert.assertEquals((Object)"median(n)", (Object)((Candidate)captorAllValues.get(67)).getLabel());
        Assert.assertEquals((Object)"meets(range1, range2)", (Object)((Candidate)captorAllValues.get(68)).getLabel());
        Assert.assertEquals((Object)"met by(range1, range2)", (Object)((Candidate)captorAllValues.get(69)).getLabel());
        Assert.assertEquals((Object)"min(c)", (Object)((Candidate)captorAllValues.get(70)).getLabel());
        Assert.assertEquals((Object)"min(list)", (Object)((Candidate)captorAllValues.get(71)).getLabel());
        Assert.assertEquals((Object)"mode(list)", (Object)((Candidate)captorAllValues.get(72)).getLabel());
        Assert.assertEquals((Object)"mode(n)", (Object)((Candidate)captorAllValues.get(73)).getLabel());
        Assert.assertEquals((Object)"modulo(dividend, divisor)", (Object)((Candidate)captorAllValues.get(74)).getLabel());
        Assert.assertEquals((Object)"month of year(date)", (Object)((Candidate)captorAllValues.get(75)).getLabel());
        Assert.assertEquals((Object)"nn all(b)", (Object)((Candidate)captorAllValues.get(76)).getLabel());
        Assert.assertEquals((Object)"nn all(list)", (Object)((Candidate)captorAllValues.get(77)).getLabel());
        Assert.assertEquals((Object)"nn any(b)", (Object)((Candidate)captorAllValues.get(78)).getLabel());
        Assert.assertEquals((Object)"nn any(list)", (Object)((Candidate)captorAllValues.get(79)).getLabel());
        Assert.assertEquals((Object)"nn count(c)", (Object)((Candidate)captorAllValues.get(80)).getLabel());
        Assert.assertEquals((Object)"nn count(list)", (Object)((Candidate)captorAllValues.get(81)).getLabel());
        Assert.assertEquals((Object)"nn max(c)", (Object)((Candidate)captorAllValues.get(82)).getLabel());
        Assert.assertEquals((Object)"nn max(list)", (Object)((Candidate)captorAllValues.get(83)).getLabel());
        Assert.assertEquals((Object)"nn mean(list)", (Object)((Candidate)captorAllValues.get(84)).getLabel());
        Assert.assertEquals((Object)"nn mean(n)", (Object)((Candidate)captorAllValues.get(85)).getLabel());
        Assert.assertEquals((Object)"nn median(list)", (Object)((Candidate)captorAllValues.get(86)).getLabel());
        Assert.assertEquals((Object)"nn median(n)", (Object)((Candidate)captorAllValues.get(87)).getLabel());
        Assert.assertEquals((Object)"nn min(c)", (Object)((Candidate)captorAllValues.get(88)).getLabel());
        Assert.assertEquals((Object)"nn min(list)", (Object)((Candidate)captorAllValues.get(89)).getLabel());
        Assert.assertEquals((Object)"nn mode(list)", (Object)((Candidate)captorAllValues.get(90)).getLabel());
        Assert.assertEquals((Object)"nn mode(n)", (Object)((Candidate)captorAllValues.get(91)).getLabel());
        Assert.assertEquals((Object)"nn stddev(list)", (Object)((Candidate)captorAllValues.get(92)).getLabel());
        Assert.assertEquals((Object)"nn stddev(n)", (Object)((Candidate)captorAllValues.get(93)).getLabel());
        Assert.assertEquals((Object)"nn sum(list)", (Object)((Candidate)captorAllValues.get(94)).getLabel());
        Assert.assertEquals((Object)"nn sum(n)", (Object)((Candidate)captorAllValues.get(95)).getLabel());
        Assert.assertEquals((Object)"not(negand)", (Object)((Candidate)captorAllValues.get(96)).getLabel());
        Assert.assertEquals((Object)"now()", (Object)((Candidate)captorAllValues.get(97)).getLabel());
        Assert.assertEquals((Object)"number(from, grouping separator, decimal separator)", (Object)((Candidate)captorAllValues.get(98)).getLabel());
        Assert.assertEquals((Object)"odd(number)", (Object)((Candidate)captorAllValues.get(99)).getLabel());
        Assert.assertEquals((Object)"overlapped after by(range1, range2)", (Object)((Candidate)captorAllValues.get(100)).getLabel());
        Assert.assertEquals((Object)"overlapped before by(range1, range2)", (Object)((Candidate)captorAllValues.get(101)).getLabel());
        Assert.assertEquals((Object)"overlapped by(range1, range2)", (Object)((Candidate)captorAllValues.get(102)).getLabel());
        Assert.assertEquals((Object)"overlaps after(range1, range2)", (Object)((Candidate)captorAllValues.get(103)).getLabel());
        Assert.assertEquals((Object)"overlaps before(range1, range2)", (Object)((Candidate)captorAllValues.get(104)).getLabel());
        Assert.assertEquals((Object)"overlaps(range1, range2)", (Object)((Candidate)captorAllValues.get(105)).getLabel());
        Assert.assertEquals((Object)"product(list)", (Object)((Candidate)captorAllValues.get(106)).getLabel());
        Assert.assertEquals((Object)"product(n)", (Object)((Candidate)captorAllValues.get(107)).getLabel());
        Assert.assertEquals((Object)"remove(list, position)", (Object)((Candidate)captorAllValues.get(108)).getLabel());
        Assert.assertEquals((Object)"replace(input, pattern, replacement)", (Object)((Candidate)captorAllValues.get(109)).getLabel());
        Assert.assertEquals((Object)"replace(input, pattern, replacement, flags)", (Object)((Candidate)captorAllValues.get(110)).getLabel());
        Assert.assertEquals((Object)"reverse(list)", (Object)((Candidate)captorAllValues.get(111)).getLabel());
        Assert.assertEquals((Object)"sort()", (Object)((Candidate)captorAllValues.get(112)).getLabel());
        Assert.assertEquals((Object)"sort(ctx, list, precedes)", (Object)((Candidate)captorAllValues.get(113)).getLabel());
        Assert.assertEquals((Object)"sort(list)", (Object)((Candidate)captorAllValues.get(114)).getLabel());
        Assert.assertEquals((Object)"split(string, delimiter)", (Object)((Candidate)captorAllValues.get(115)).getLabel());
        Assert.assertEquals((Object)"split(string, delimiter, flags)", (Object)((Candidate)captorAllValues.get(116)).getLabel());
        Assert.assertEquals((Object)"sqrt(number)", (Object)((Candidate)captorAllValues.get(117)).getLabel());
        Assert.assertEquals((Object)"started by(range, value)", (Object)((Candidate)captorAllValues.get(118)).getLabel());
        Assert.assertEquals((Object)"started by(range1, range2)", (Object)((Candidate)captorAllValues.get(119)).getLabel());
        Assert.assertEquals((Object)"starts with(string, match)", (Object)((Candidate)captorAllValues.get(120)).getLabel());
        Assert.assertEquals((Object)"starts(range1, range2)", (Object)((Candidate)captorAllValues.get(121)).getLabel());
        Assert.assertEquals((Object)"starts(value, range)", (Object)((Candidate)captorAllValues.get(122)).getLabel());
        Assert.assertEquals((Object)"stddev(list)", (Object)((Candidate)captorAllValues.get(123)).getLabel());
        Assert.assertEquals((Object)"stddev(n)", (Object)((Candidate)captorAllValues.get(124)).getLabel());
        Assert.assertEquals((Object)"string length(string)", (Object)((Candidate)captorAllValues.get(125)).getLabel());
        Assert.assertEquals((Object)"string(from)", (Object)((Candidate)captorAllValues.get(126)).getLabel());
        Assert.assertEquals((Object)"string(mask, p)", (Object)((Candidate)captorAllValues.get(127)).getLabel());
        Assert.assertEquals((Object)"sublist(list, start position)", (Object)((Candidate)captorAllValues.get(128)).getLabel());
        Assert.assertEquals((Object)"sublist(list, start position, length)", (Object)((Candidate)captorAllValues.get(129)).getLabel());
        Assert.assertEquals((Object)"substring after(string, match)", (Object)((Candidate)captorAllValues.get(130)).getLabel());
        Assert.assertEquals((Object)"substring before(string, match)", (Object)((Candidate)captorAllValues.get(131)).getLabel());
        Assert.assertEquals((Object)"substring(string, start position)", (Object)((Candidate)captorAllValues.get(132)).getLabel());
        Assert.assertEquals((Object)"substring(string, start position, length)", (Object)((Candidate)captorAllValues.get(133)).getLabel());
        Assert.assertEquals((Object)"sum(list)", (Object)((Candidate)captorAllValues.get(134)).getLabel());
        Assert.assertEquals((Object)"sum(n)", (Object)((Candidate)captorAllValues.get(135)).getLabel());
        Assert.assertEquals((Object)"time(from)", (Object)((Candidate)captorAllValues.get(136)).getLabel());
        Assert.assertEquals((Object)"time(hour, minute, second)", (Object)((Candidate)captorAllValues.get(137)).getLabel());
        Assert.assertEquals((Object)"time(hour, minute, second, offset)", (Object)((Candidate)captorAllValues.get(138)).getLabel());
        Assert.assertEquals((Object)"today()", (Object)((Candidate)captorAllValues.get(139)).getLabel());
        Assert.assertEquals((Object)"union(list)", (Object)((Candidate)captorAllValues.get(140)).getLabel());
        Assert.assertEquals((Object)"upper case(string)", (Object)((Candidate)captorAllValues.get(141)).getLabel());
        Assert.assertEquals((Object)"week of year(date)", (Object)((Candidate)captorAllValues.get(142)).getLabel());
        Assert.assertEquals((Object)"years and months duration(from, to)", (Object)((Candidate)captorAllValues.get(143)).getLabel());
        Assert.assertEquals((Object)"for", (Object)((Candidate)captorAllValues.get(144)).getLabel());
        Assert.assertEquals((Object)"return", (Object)((Candidate)captorAllValues.get(145)).getLabel());
        Assert.assertEquals((Object)"if", (Object)((Candidate)captorAllValues.get(146)).getLabel());
        Assert.assertEquals((Object)"then", (Object)((Candidate)captorAllValues.get(147)).getLabel());
        Assert.assertEquals((Object)"some", (Object)((Candidate)captorAllValues.get(148)).getLabel());
        Assert.assertEquals((Object)"every", (Object)((Candidate)captorAllValues.get(149)).getLabel());
        Assert.assertEquals((Object)"satisfies", (Object)((Candidate)captorAllValues.get(150)).getLabel());
        Assert.assertEquals((Object)"instance", (Object)((Candidate)captorAllValues.get(151)).getLabel());
        Assert.assertEquals((Object)"of", (Object)((Candidate)captorAllValues.get(152)).getLabel());
        Assert.assertEquals((Object)"in", (Object)((Candidate)captorAllValues.get(153)).getLabel());
        Assert.assertEquals((Object)"function", (Object)((Candidate)captorAllValues.get(154)).getLabel());
        Assert.assertEquals((Object)"external", (Object)((Candidate)captorAllValues.get(155)).getLabel());
        Assert.assertEquals((Object)"or", (Object)((Candidate)captorAllValues.get(156)).getLabel());
        Assert.assertEquals((Object)"and", (Object)((Candidate)captorAllValues.get(157)).getLabel());
        Assert.assertEquals((Object)"between", (Object)((Candidate)captorAllValues.get(158)).getLabel());
        Assert.assertEquals((Object)"not", (Object)((Candidate)captorAllValues.get(159)).getLabel());
        Assert.assertEquals((Object)"null", (Object)((Candidate)captorAllValues.get(160)).getLabel());
        Assert.assertEquals((Object)"true", (Object)((Candidate)captorAllValues.get(161)).getLabel());
        Assert.assertEquals((Object)"false", (Object)((Candidate)captorAllValues.get(162)).getLabel());
        Assert.assertEquals((Object)expectedSuggestions, (Object)actualSuggestions);
    }

    @Test
    public void testSuggestion() {
        String candidateLabel = "sum(value)";
        String insertText = "sum($1)";
        Candidate candidate = new Candidate("sum(value)", "sum($1)", CompletionItemKind.Function);
        JSONObject expectedSuggestion = (JSONObject)Mockito.mock(JSONObject.class);
        JSONValue jsonKindKeyValue = (JSONValue)Mockito.mock(JSONValue.class);
        JSONValue jsonInsertTextRulesKeyValue = (JSONValue)Mockito.mock(JSONValue.class);
        JSONString jsonLabelValue = (JSONString)Mockito.mock(JSONString.class);
        JSONString jsonInsertTextValue = (JSONString)Mockito.mock(JSONString.class);
        JSONString jsonSortKeyValue = (JSONString)Mockito.mock(JSONString.class);
        int completionItemInsertTextRuleInsertAsSnippet = 4;
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)expectedSuggestion).when((Object)this.suggestionsPropertyFactory)).makeJSONObject();
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)jsonKindKeyValue).when((Object)this.suggestionsPropertyFactory)).makeJSONNumber(CompletionItemKind.Function.getValue());
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)jsonInsertTextRulesKeyValue).when((Object)this.suggestionsPropertyFactory)).makeJSONNumber(4);
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)jsonLabelValue).when((Object)this.suggestionsPropertyFactory)).makeJSONString("sum(value)");
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)jsonInsertTextValue).when((Object)this.suggestionsPropertyFactory)).makeJSONString("sum($1)");
        ((MonacoSuggestionsPropertyFactory)Mockito.doReturn((Object)jsonSortKeyValue).when((Object)this.suggestionsPropertyFactory)).makeJSONString("0000");
        JSONValue actualSuggestion = this.suggestionsPropertyFactory.getSuggestion(candidate, 0);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("kind", jsonKindKeyValue);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertTextRules", jsonInsertTextRulesKeyValue);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("label", (JSONValue)jsonLabelValue);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("insertText", (JSONValue)jsonInsertTextValue);
        ((JSONObject)Mockito.verify((Object)expectedSuggestion)).put("sortText", (JSONValue)jsonSortKeyValue);
        Assert.assertEquals((Object)expectedSuggestion, (Object)actualSuggestion);
    }
}

