/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGridRenderer;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseExpressionGridRenderingTest<D extends GridData> {
    protected D gridData;

    @Before
    public void setup() {
        this.gridData = this.getGridData();
    }

    protected D getGridData() {
        return (D)((GridData)Mockito.spy((Object)new BaseGridData()));
    }

    protected GridRenderer getGridRenderer() {
        return new BaseExpressionGridRenderer(this.gridData);
    }

    protected double getExpectedHeaderRowHeight() {
        return 64.0;
    }

    protected double getExpectedHeaderHeightZeroRows() {
        return 0.0;
    }

    protected double getExpectedHeaderHeightOneRow() {
        return 64.0;
    }

    protected double getExpectedHeaderHeightTwoRows() {
        return 128.0;
    }

    @Test
    public void testHeaderDimensionsWhenHeaderHasZeroRows() {
        Mockito.when((Object)this.gridData.getHeaderRowCount()).thenReturn((Object)0);
        GridRenderer renderer = this.getGridRenderer();
        Assert.assertEquals((double)this.getExpectedHeaderHeightZeroRows(), (double)renderer.getHeaderHeight(), (double)0.0);
        Assert.assertEquals((double)this.getExpectedHeaderRowHeight(), (double)renderer.getHeaderRowHeight(), (double)0.0);
    }

    @Test
    public void testHeaderDimensionsWhenHeaderHasOneRow() {
        Mockito.when((Object)this.gridData.getHeaderRowCount()).thenReturn((Object)1);
        GridRenderer renderer = this.getGridRenderer();
        Assert.assertEquals((double)this.getExpectedHeaderHeightOneRow(), (double)renderer.getHeaderHeight(), (double)0.0);
        Assert.assertEquals((double)this.getExpectedHeaderRowHeight(), (double)renderer.getHeaderRowHeight(), (double)0.0);
    }

    @Test
    public void testHeaderDimensionsWhenHeaderHasTwoRows() {
        Mockito.when((Object)this.gridData.getHeaderRowCount()).thenReturn((Object)2);
        GridRenderer renderer = this.getGridRenderer();
        Assert.assertEquals((double)this.getExpectedHeaderHeightTwoRows(), (double)renderer.getHeaderHeight(), (double)0.0);
        Assert.assertEquals((double)this.getExpectedHeaderRowHeight(), (double)renderer.getHeaderRowHeight(), (double)0.0);
    }
}

