/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import com.ibm.icu.impl.Assert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.widgets.grid.model.HasDynamicHeight;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public abstract class BaseHasDynamicHeightCellTest<CELL extends BaseGridCell> {
    public static final double LINE_HEIGHT = 16.0;
    protected CELL cell;

    protected abstract CELL makeCell();

    protected abstract CELL makeCell(double var1);

    @Before
    public void setup() {
        this.cell = this.makeCell();
    }

    @Test
    public void testNullValue() {
        this.setValue(null);
        Assertions.assertThat((double)((HasDynamicHeight)this.cell).getHeight()).isEqualTo(48.0);
    }

    @Test
    public void testEmptyValue() {
        this.setValue((GridCellValue)new BaseGridCellValue((Object)""));
        Assertions.assertThat((double)((HasDynamicHeight)this.cell).getHeight()).isEqualTo(48.0);
    }

    @Test
    public void testSingleLineValue() {
        this.setValue((GridCellValue)new BaseGridCellValue((Object)"cheese"));
        Assertions.assertThat((double)((HasDynamicHeight)this.cell).getHeight()).isEqualTo(31.0);
    }

    @Test
    public void testMultipleLineValue() {
        this.setValue((GridCellValue)new BaseGridCellValue((Object)"1\n2\n3\n4"));
        Assertions.assertThat((double)((HasDynamicHeight)this.cell).getHeight()).isEqualTo(79.0);
    }

    @Test
    public void testMulitpleLineValueWithEmptyLines() {
        this.setValue((GridCellValue)new BaseGridCellValue((Object)"1\n2\n\n\n3\n4"));
        Assertions.assertThat((double)((HasDynamicHeight)this.cell).getHeight()).isEqualTo(111.0);
    }

    @Test
    public void testMulitpleLineValueWithDifferentEndOfLines() {
        this.setValue((GridCellValue)new BaseGridCellValue((Object)"1\n2\r\n \n3\n4 \r\n"));
        Assertions.assertThat((double)((HasDynamicHeight)this.cell).getHeight()).isEqualTo(111.0);
    }

    @Test
    public void testMultipleLineValueWithEndingWithEmptyLine() {
        this.setValue((GridCellValue)new BaseGridCellValue((Object)"1\n2\r\n3\n"));
        Assertions.assertThat((double)((HasDynamicHeight)this.cell).getHeight()).isEqualTo(79.0);
    }

    @Test
    public void testEquals() {
        CELL sameCell = this.makeCell();
        Assertions.assertThat(this.cell).isEqualTo(sameCell);
        Assertions.assertThat((int)this.cell.hashCode()).isEqualTo(sameCell.hashCode());
    }

    @Test
    public void testEqualsIdentity() {
        Assertions.assertThat(this.cell).isEqualTo(this.cell);
        Assertions.assertThat((int)this.cell.hashCode()).isEqualTo(this.cell.hashCode());
    }

    @Test
    public void testEqualsDifferentHeight() {
        CELL differentCell = this.makeCell();
        BaseGridCellValue differentValue = new BaseGridCellValue((Object)"Hello\nWorld!");
        this.setValue(differentCell, (GridCellValue)differentValue);
        Assertions.assertThat(this.cell).isNotEqualTo(differentCell);
        Assertions.assertThat((int)this.cell.hashCode()).isNotEqualTo(differentCell.hashCode());
    }

    @Test
    public void testEqualsDifferentLineHeight() {
        CELL differentCell = this.makeCell(17.0);
        Assertions.assertThat(this.cell).isNotEqualTo(differentCell);
        Assertions.assertThat((int)this.cell.hashCode()).isNotEqualTo(differentCell.hashCode());
    }

    protected void setValue(GridCellValue value) {
        this.setValue(this.cell, value);
    }

    protected void setValue(CELL cell, GridCellValue value) {
        try {
            Method m = BaseGridCell.class.getDeclaredMethod("setValue", GridCellValue.class);
            m.setAccessible(true);
            m.invoke(cell, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Assert.fail((Exception)e);
        }
    }
}

