/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorGridRow;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorGridRowTest {
    @Mock
    private BaseExpressionGrid view;

    @Test
    public void testEmptyRow() {
        ExpressionEditorGridRow row = new ExpressionEditorGridRow();
        Assertions.assertThat((double)row.getHeight()).isEqualTo(48.0);
    }

    @Test
    public void testRowLowerThanDefault() {
        Mockito.when((Object)this.view.getHeight()).thenReturn((Object)47.0);
        GridRow row = (GridRow)Mockito.spy(ExpressionEditorGridRow.class);
        Map cells = new Maps.Builder().put((Object)0, (Object)new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(this.view)))).build();
        Mockito.when((Object)row.getCells()).thenReturn((Object)cells);
        Assertions.assertThat((double)row.getHeight()).isBetween(Double.valueOf(0.0), Double.valueOf(48.0));
    }

    @Test
    public void testRowHigherThanDefault() {
        Mockito.when((Object)this.view.getHeight()).thenReturn((Object)49.0);
        GridRow row = (GridRow)Mockito.spy(ExpressionEditorGridRow.class);
        Map cells = new Maps.Builder().put((Object)0, (Object)new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(this.view)))).build();
        Mockito.when((Object)row.getCells()).thenReturn((Object)cells);
        Assertions.assertThat((double)row.getHeight()).isGreaterThan(48.0);
    }

    @Test
    public void testRowHigherThanDefaultWithNullCell() {
        Mockito.when((Object)this.view.getHeight()).thenReturn((Object)49.0);
        GridRow row = (GridRow)Mockito.spy(ExpressionEditorGridRow.class);
        Map cells = new Maps.Builder().put((Object)0, (Object)new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(this.view)))).put((Object)1, null).build();
        Mockito.when((Object)row.getCells()).thenReturn((Object)cells);
        Assertions.assertThat((double)row.getHeight()).isGreaterThan(48.0);
    }

    @Test
    public void testRowHigherThanDefaultWithNullCellValue() {
        Mockito.when((Object)this.view.getHeight()).thenReturn((Object)49.0);
        GridRow row = (GridRow)Mockito.spy(ExpressionEditorGridRow.class);
        Map cells = new Maps.Builder().put((Object)0, (Object)new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(this.view)))).put((Object)1, (Object)new BaseGridCell(null)).build();
        Mockito.when((Object)row.getCells()).thenReturn((Object)cells);
        Assertions.assertThat((double)row.getHeight()).isGreaterThan(48.0);
    }
}

