/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.util;

import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class ContentDefinitionIdUtils {
    private ContentDefinitionIdUtils() {
    }

    public static boolean belongsToCurrentGraph(Node node, GraphsProvider graphsProvider) {
        return ContentDefinitionIdUtils.isTheCurrentDiagram(ContentDefinitionIdUtils.getDiagramId(node), graphsProvider);
    }

    public static boolean belongsToCurrentGraph(Edge<? extends View, Node> edge, GraphsProvider graphsProvider) {
        return ContentDefinitionIdUtils.isTheCurrentDiagram(ContentDefinitionIdUtils.getDiagramId(edge), graphsProvider);
    }

    public static boolean isTheCurrentDiagram(Optional<String> diagramId, GraphsProvider graphsProvider) {
        return diagramId.isPresent() && Objects.equals(diagramId.get(), graphsProvider.getCurrentDiagramId());
    }

    public static Optional<String> getDiagramId(Edge<? extends View, Node> edge) {
        Node node = Objects.isNull(edge.getSourceNode()) ? edge.getTargetNode() : edge.getSourceNode();
        return ContentDefinitionIdUtils.getDiagramId(node);
    }

    public static Optional<String> getDiagramId(Node node) {
        Object definition;
        if (Objects.isNull(node)) {
            return Optional.empty();
        }
        Object content = node.getContent();
        if (content instanceof Definition && (definition = ((Definition)content).getDefinition()) instanceof HasContentDefinitionId) {
            return Optional.of(((HasContentDefinitionId)definition).getDiagramId());
        }
        return Optional.empty();
    }
}

