/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsPageStateProvider;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsFactory;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;

@ApplicationScoped
public class IncludedModelsPageStateProviderImpl
implements IncludedModelsPageStateProvider {
    private final DMNGraphUtils dmnGraphUtils;
    private final IncludedModelsFactory factory;
    private final DMNDiagramsSession dmnDiagramsSession;

    public IncludedModelsPageStateProviderImpl() {
        this(null, null, null);
    }

    @Inject
    public IncludedModelsPageStateProviderImpl(DMNGraphUtils dmnGraphUtils, IncludedModelsFactory factory, DMNDiagramsSession dmnDiagramsSession) {
        this.dmnGraphUtils = dmnGraphUtils;
        this.factory = factory;
        this.dmnDiagramsSession = dmnDiagramsSession;
    }

    @Override
    public String getCurrentDiagramNamespace() {
        return this.getDiagram().map(diagram -> this.getDefinitions((Diagram)diagram).getNamespace().getValue()).orElse("");
    }

    @Override
    public List<BaseIncludedModelActiveRecord> generateIncludedModels() {
        return this.factory.makeIncludedModels(this.getImports());
    }

    public List<Import> getImports() {
        return this.getDiagram().map(this::getImports).orElse(Collections.emptyList());
    }

    public Optional<Diagram> getDiagram() {
        return Optional.ofNullable(this.dmnDiagramsSession.getDRGDiagram());
    }

    private List<Import> getImports(Diagram diagram) {
        return this.getDefinitions(diagram).getImport();
    }

    private Definitions getDefinitions(Diagram diagram) {
        return this.dmnGraphUtils.getDefinitions(diagram);
    }
}

