/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessages;
import org.kie.workbench.common.dmn.client.editors.common.page.DMNPage;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.events.RefreshDataTypesListEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeShortcuts;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;

@Dependent
public class DataTypesPage
extends DMNPage {
    private final DataTypeList treeList;
    private final ItemDefinitionUtils itemDefinitionUtils;
    private final ItemDefinitionStore definitionStore;
    private final DataTypeStore dataTypeStore;
    private final DataTypeManager dataTypeManager;
    private final DataTypeManagerStackStore stackIndex;
    private final FlashMessages flashMessages;
    private final DataTypeSearchBar searchBar;
    private final DMNGraphUtils dmnGraphUtils;
    private final DataTypeShortcuts dataTypeShortcuts;
    private String loadedDMNModelNamespace;

    @Inject
    public DataTypesPage(DataTypeList treeList, ItemDefinitionUtils itemDefinitionUtils, ItemDefinitionStore definitionStore, DataTypeStore dataTypeStore, DataTypeManager dataTypeManager, DataTypeManagerStackStore stackIndex, FlashMessages flashMessages, DataTypeSearchBar searchBar, DMNGraphUtils dmnGraphUtils, TranslationService translationService, DataTypeShortcuts dataTypeShortcuts, HTMLDivElement pageView) {
        super("DataTypesPage.Title", pageView, translationService);
        this.treeList = treeList;
        this.itemDefinitionUtils = itemDefinitionUtils;
        this.definitionStore = definitionStore;
        this.dataTypeStore = dataTypeStore;
        this.dataTypeManager = dataTypeManager;
        this.stackIndex = stackIndex;
        this.flashMessages = flashMessages;
        this.searchBar = searchBar;
        this.dmnGraphUtils = dmnGraphUtils;
        this.dataTypeShortcuts = dataTypeShortcuts;
    }

    @PostConstruct
    public void init() {
        this.dataTypeShortcuts.init(this.treeList);
    }

    public void onFocus() {
        if (!this.isLoaded()) {
            this.reload();
        }
        this.refreshPageView();
    }

    public void onLostFocus() {
        this.flashMessages.hideMessages();
    }

    public void onRefreshDataTypesListWithNewItemDefinitions(@Observes RefreshDataTypesListEvent refresh) {
        if (this.isLoaded()) {
            this.refreshItemDefinitions(refresh.getNewItemDefinitions());
            this.reload();
        }
    }

    void refreshItemDefinitions(List<ItemDefinition> newItemDefinitions) {
        this.itemDefinitionUtils.addItemDefinitions(newItemDefinitions);
    }

    public void reload() {
        this.loadedDMNModelNamespace = this.currentDMNModelNamespace();
        this.cleanDataTypeStore();
        this.loadDataTypes();
    }

    void refreshPageView() {
        HTMLDivElement pageView = this.getPageView();
        RemoveHelper.removeChildren((Element)pageView);
        pageView.appendChild((Node)this.flashMessages.getElement());
        pageView.appendChild((Node)this.treeList.getElement());
    }

    boolean isLoaded() {
        return Objects.equals(this.getLoadedDMNModelNamespace(), this.currentDMNModelNamespace());
    }

    String currentDMNModelNamespace() {
        return this.getNamespace().map(Text::getValue).orElse("");
    }

    void cleanDataTypeStore() {
        this.definitionStore.clear();
        this.dataTypeStore.clear();
        this.stackIndex.clear();
        this.searchBar.reset();
    }

    void loadDataTypes() {
        this.treeList.setupItems(this.itemDefinitionUtils.all().stream().map(this::makeDataType).collect(Collectors.toList()));
    }

    DataType makeDataType(ItemDefinition itemDefinition) {
        return this.dataTypeManager.from(itemDefinition).get();
    }

    String getLoadedDMNModelNamespace() {
        return this.loadedDMNModelNamespace;
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        this.onFocus();
    }

    private Optional<Text> getNamespace() {
        return this.getDefinitions().map(Definitions::getNamespace);
    }

    private Optional<Definitions> getDefinitions() {
        return Optional.ofNullable(this.dmnGraphUtils.getModelDefinitions());
    }

    public void enableShortcuts() {
        this.dataTypeShortcuts.setup();
    }

    public void disableShortcuts() {
        this.dataTypeShortcuts.teardown();
    }
}

