/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported.treelist;

import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListSubItem;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class TreeListItem {
    private View view;
    private final List<TreeListSubItem> subItems;
    private String description;
    private boolean isSelected;
    private DataObject dataSource;
    private Consumer<TreeListItem> onIsSelectedChanged;

    @Inject
    public TreeListItem(View view) {
        this.view = view;
        this.subItems = new ArrayList<TreeListSubItem>();
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public Node getElement() {
        return this.view.getElement();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addSubItem(TreeListSubItem subItem) {
        this.subItems.add(subItem);
    }

    public List<TreeListSubItem> getSubItems() {
        return this.subItems;
    }

    public void updateView() {
        this.view.populate(this);
    }

    public void setIsSelected(boolean value) {
        this.isSelected = value;
        this.callOnIsSelectedChanged();
    }

    void callOnIsSelectedChanged() {
        if (!Objects.isNull(this.getOnIsSelectedChanged())) {
            this.getOnIsSelectedChanged().accept(this);
        }
    }

    public boolean getIsSelected() {
        return this.isSelected;
    }

    public void setDataSource(DataObject dataSource) {
        this.dataSource = dataSource;
    }

    public DataObject getDataSource() {
        return this.dataSource;
    }

    public void setOnIsSelectedChanged(Consumer<TreeListItem> onIsSelectedChanged) {
        this.onIsSelectedChanged = onIsSelectedChanged;
    }

    public Consumer<TreeListItem> getOnIsSelectedChanged() {
        return this.onIsSelectedChanged;
    }

    public static interface View
    extends UberElemental<TreeListItem> {
        public void populate(TreeListItem var1);
    }
}

