/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import elemental2.dom.HTMLElement;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class DataTypeConstraint {
    static final String NONE = "";
    private final View view;
    private final ManagedInstance<DataTypeConstraintModal> constraintModalManagedInstance;
    private DataTypeConstraintModal constraintModal;
    private boolean isEditModeEnabled = false;
    private String constraintValue = "";
    private ConstraintType constraintType = ConstraintType.NONE;
    private DataTypeListItem listItem;

    @Inject
    public DataTypeConstraint(View view, ManagedInstance<DataTypeConstraintModal> constraintModalManagedInstance) {
        this.view = view;
        this.constraintModalManagedInstance = constraintModalManagedInstance;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
        this.disableEditMode();
    }

    public void init(DataTypeListItem listItem) {
        this.listItem = listItem;
        this.constraintValue = listItem.getDataType().getConstraint();
        this.constraintType = listItem.getDataType().getConstraintType();
        this.refreshView();
    }

    public String getValue() {
        return this.constraintValue;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void enableEditMode() {
        this.isEditModeEnabled = true;
        this.view.showAnchor();
    }

    public void disableEditMode() {
        this.isEditModeEnabled = false;
        this.view.hideAnchor();
    }

    public void refreshView() {
        this.view.setText(this.getValue());
        if (this.isEditModeEnabled()) {
            this.enableEditMode();
        } else {
            this.disableEditMode();
        }
    }

    void openModal() {
        this.constraintModal().load(this.getListItem().getType(), this.getValue(), this.getConstraintType());
        this.constraintModal().show(this.getOnShowConsumer());
    }

    BiConsumer<String, ConstraintType> getOnShowConsumer() {
        return (newConstraintValue, newConstraintType) -> {
            this.setConstraint((String)newConstraintValue, (ConstraintType)newConstraintType);
            this.refreshView();
        };
    }

    DataTypeListItem getListItem() {
        return this.listItem;
    }

    boolean isEditModeEnabled() {
        return this.isEditModeEnabled;
    }

    public void disable() {
        this.setConstraint(NONE, ConstraintType.NONE);
        this.view.disable();
    }

    public void enable() {
        this.view.enable();
    }

    private void setConstraint(String value, ConstraintType type) {
        this.constraintValue = value;
        this.constraintType = type;
    }

    DataTypeConstraintModal constraintModal() {
        if (this.constraintModal == null) {
            this.constraintModal = (DataTypeConstraintModal)((Object)this.constraintModalManagedInstance.get());
        }
        return this.constraintModal;
    }

    DataTypeConstraintModal getConstraintModal() {
        return this.constraintModal;
    }

    public static interface View
    extends UberElemental<DataTypeConstraint>,
    IsElement {
        public void showAnchor();

        public void hideAnchor();

        public void setText(String var1);

        public void enable();

        public void disable();
    }
}

