/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueComponentSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item.DataTypeConstraintEnumerationItem;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Templated
@Dependent
public class DataTypeConstraintEnumerationItemView
implements DataTypeConstraintEnumerationItem.View {
    static final String HIGHLIGHTED_CSS_CLASS = "highlighted";
    static final String NONE_CSS_CLASS = "none";
    public static final String DATA_POSITION = "data-position";
    private final TypedValueComponentSelector componentSelector;
    private TypedValueSelector typedValueSelector;
    @DataField(value="value-text")
    private final HTMLElement valueText;
    @DataField(value="value-input-container")
    private final HTMLDivElement valueInputContainer;
    @DataField(value="save-anchor")
    private final HTMLAnchorElement saveAnchor;
    @DataField(value="remove-anchor")
    private final HTMLAnchorElement removeAnchor;
    @DataField(value="clear-field-anchor")
    private final HTMLAnchorElement clearFieldAnchor;
    private final TranslationService translationService;
    private DataTypeConstraintEnumerationItem presenter;

    @Inject
    public DataTypeConstraintEnumerationItemView(@Named(value="span") HTMLElement valueText, HTMLDivElement valueInput, HTMLAnchorElement saveAnchor, HTMLAnchorElement removeAnchor, HTMLAnchorElement clearFieldAnchor, TranslationService translationService, TypedValueComponentSelector valueComponentSelector) {
        this.valueText = valueText;
        this.valueInputContainer = valueInput;
        this.saveAnchor = saveAnchor;
        this.removeAnchor = removeAnchor;
        this.clearFieldAnchor = clearFieldAnchor;
        this.translationService = translationService;
        this.componentSelector = valueComponentSelector;
    }

    public void init(DataTypeConstraintEnumerationItem presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showValueText() {
        HiddenHelper.show((Element)this.valueText);
        HiddenHelper.hide((Element)this.valueInputContainer);
    }

    @Override
    public void showValueInput() {
        HiddenHelper.show((Element)this.valueInputContainer);
        HiddenHelper.hide((Element)this.valueText);
    }

    @Override
    public void focusValueInput() {
        this.typedValueSelector.select();
    }

    @Override
    public void showSaveButton() {
        HiddenHelper.show((Element)this.saveAnchor);
    }

    @Override
    public void hideSaveButton() {
        HiddenHelper.hide((Element)this.saveAnchor);
    }

    @Override
    public void enableHighlight() {
        this.getElement().classList.add(new String[]{HIGHLIGHTED_CSS_CLASS});
    }

    @Override
    public void disableHighlight() {
        this.getElement().classList.remove(new String[]{HIGHLIGHTED_CSS_CLASS});
    }

    @EventHandler(value={"value-text"})
    public void onValueTextClick(ClickEvent e) {
        this.presenter.enableEditMode();
    }

    @EventHandler(value={"save-anchor"})
    public void onSaveAnchorClick(ClickEvent e) {
        this.presenter.save(this.typedValueSelector.getValue());
    }

    @EventHandler(value={"remove-anchor"})
    public void onRemoveAnchorClick(ClickEvent e) {
        this.presenter.remove();
    }

    @EventHandler(value={"clear-field-anchor"})
    public void onClearFieldAnchorClick(ClickEvent e) {
        this.presenter.setValue("");
        this.typedValueSelector.select();
    }

    public void onValueInputBlur(BlurEvent blurEvent) {
        boolean isNotClearButtonClick;
        Object target = this.getEventTarget(blurEvent);
        boolean isNotSaveButtonClick = !Objects.equals(target, this.getSaveAnchorTarget());
        boolean bl = isNotClearButtonClick = !Objects.equals(target, this.getClearAnchorTarget());
        if (isNotSaveButtonClick && isNotClearButtonClick) {
            this.presenter.discardEditMode();
        }
    }

    @Override
    public void setValue(String value) {
        this.setText(value);
        this.setInput(value);
    }

    @Override
    public void setPlaceholder(String placeholder) {
        this.typedValueSelector.setPlaceholder(placeholder);
    }

    @Override
    public void setComponentSelector(String type) {
        this.typedValueSelector = this.componentSelector.makeSelectorForType(type);
        RemoveHelper.removeChildren((Element)this.valueInputContainer);
        this.valueInputContainer.appendChild((Node)this.typedValueSelector.getElement());
        this.typedValueSelector.setOnInputBlurCallback(this::onValueInputBlur);
    }

    @Override
    public void showClearButton() {
        HiddenHelper.show((Element)this.clearFieldAnchor);
    }

    @Override
    public void hideDeleteButton() {
        HiddenHelper.hide((Element)this.removeAnchor);
    }

    @Override
    public void hideClearButton() {
        HiddenHelper.hide((Element)this.clearFieldAnchor);
    }

    @Override
    public void showDeleteButton() {
        HiddenHelper.show((Element)this.removeAnchor);
    }

    @Override
    public int getOrder() {
        String dataPosition = this.getElement().getAttribute(DATA_POSITION);
        if (StringUtils.isEmpty((String)dataPosition)) {
            return 0;
        }
        return Integer.valueOf(dataPosition);
    }

    @Override
    public void setOrder(int order) {
        this.getElement().setAttribute(DATA_POSITION, (double)order);
    }

    private void setText(String value) {
        if (this.isNULL(value)) {
            this.valueText.classList.add(new String[]{NONE_CSS_CLASS});
            this.valueText.textContent = this.none();
        } else {
            this.valueText.classList.remove(new String[]{NONE_CSS_CLASS});
            this.valueText.textContent = this.typedValueSelector.toDisplay(value);
        }
    }

    private void setInput(String value) {
        if (this.isNULL(value)) {
            this.typedValueSelector.setValue("");
        } else {
            this.typedValueSelector.setValue(value);
        }
    }

    private boolean isNULL(String value) {
        return Objects.equals(value, "null");
    }

    private String none() {
        return this.translationService.format("DataTypeConstraintEnumerationItemView.None", new Object[0]);
    }

    Object getEventTarget(BlurEvent blurEvent) {
        return blurEvent.getNativeEvent().getRelatedEventTarget();
    }

    Object getSaveAnchorTarget() {
        return this.saveAnchor;
    }

    Object getClearAnchorTarget() {
        return this.clearFieldAnchor;
    }
}

