/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;

public class DataTypeHandler {
    final DataTypeStore dataTypeStore;
    final DataTypeManager dataTypeManager;
    ItemDefinitionRecordEngine recordEngine;

    DataTypeHandler(DataTypeStore dataTypeStore, DataTypeManager dataTypeManager) {
        this.dataTypeStore = dataTypeStore;
        this.dataTypeManager = dataTypeManager;
    }

    public void init(ItemDefinitionRecordEngine recordEngine) {
        this.recordEngine = recordEngine;
    }

    Optional<DataType> getClosestTopLevelDataType(DataType dataType) {
        Optional<DataType> closestTopLevelDataType = this.getClosestTopLevel(this.parent(dataType));
        if (closestTopLevelDataType.isPresent()) {
            DataType topLevel = closestTopLevelDataType.get();
            String type = topLevel.isTopLevel() ? topLevel.getName() : topLevel.getType();
            return this.findTopLevelDataTypeByName(type);
        }
        return Optional.empty();
    }

    List<DataType> getSubDataTypesByType(String type) {
        return new DataTypeQuery().where(dataType -> Objects.equals(dataType.getType(), type)).collect();
    }

    List<DataType> forEachSubDataTypesByType(String type, Consumer<DataType> consumer) {
        return new DataTypeQuery().where(dataType -> Objects.equals(dataType.getType(), type)).apply(consumer).collect();
    }

    List<DataType> forEachSubDataTypesByTypeOrName(String typeOrName, Consumer<DataType> consumer) {
        return new DataTypeQuery().where(dataType -> Objects.equals(dataType.getType(), typeOrName) || Objects.equals(dataType.getName(), typeOrName)).apply(consumer).collect();
    }

    DataType parent(DataType dataType) {
        return this.dataTypeStore.get(dataType.getParentUUID());
    }

    ItemDefinitionRecordEngine getRecordEngine() {
        return this.recordEngine;
    }

    boolean isStructure(DataType dataType) {
        return Objects.equals(dataType.getType(), this.dataTypeManager.structure());
    }

    private Optional<DataType> findTopLevelDataTypeByName(String name) {
        List<DataType> dataTypes = this.topLevelDataTypes();
        return dataTypes.stream().filter(dataType -> Objects.equals(dataType.getName(), name)).findFirst();
    }

    private Optional<DataType> getClosestTopLevel(DataType dataType) {
        if (dataType == null) {
            return Optional.empty();
        }
        if (this.isClosestTopLevel(dataType)) {
            return Optional.of(dataType);
        }
        return this.getClosestTopLevel(this.parent(dataType));
    }

    private boolean isClosestTopLevel(DataType dataType) {
        boolean isTopLevel = dataType.isTopLevel();
        boolean isTopLevelField = this.topLevelDataTypes().stream().anyMatch(topLevel -> Objects.equals(topLevel.getName(), dataType.getType()));
        return isTopLevel || isTopLevelField;
    }

    private List<DataType> topLevelDataTypes() {
        return this.dataTypeStore.getTopLevelDataTypes();
    }

    class DataTypeQuery {
        private Function<DataType, Boolean> condition = dataType -> true;
        private Consumer<DataType> consumer = dataType -> {};

        DataTypeQuery() {
        }

        DataTypeQuery where(Function<DataType, Boolean> condition) {
            this.condition = condition;
            return this;
        }

        DataTypeQuery apply(Consumer<DataType> consumer) {
            this.consumer = consumer;
            return this;
        }

        List<DataType> collect() {
            return this.collect(DataTypeHandler.this.topLevelDataTypes());
        }

        private List<DataType> collect(List<DataType> dataTypes) {
            ArrayList<DataType> updated = new ArrayList<DataType>();
            for (DataType dataType : dataTypes) {
                if (this.condition.apply(dataType).booleanValue()) {
                    updated.add(dataType);
                    this.consumer.accept(dataType);
                }
                updated.addAll(this.collect(dataType.getSubDataTypes()));
            }
            return updated;
        }
    }
}

