/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DRGDiagramUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.JsInteropUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIBounds;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIDiagramElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDI;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DMNDiagramElementsUtils {
    public void ensureDRGElementExists(JSITDefinitions dmnDefinitions) {
        List<JSIDMNDiagram> dmnDiagrams = this.getValidDMNDiagrams(dmnDefinitions);
        Optional<JSIDMNDiagram> drgDiagramElement = this.findDRGDiagramElement(dmnDiagrams);
        if (drgDiagramElement.isPresent()) {
            return;
        }
        if (dmnDiagrams.size() == 1) {
            this.renameDiagramElement(dmnDiagrams);
            return;
        }
        JSIDMNDiagram drg = this.generateDRGElement(dmnDefinitions);
        dmnDefinitions.getDMNDI().addDMNDiagram(drg);
    }

    private List<JSIDMNDiagram> getValidDMNDiagrams(JSITDefinitions dmnDefinitions) {
        List<JSIDMNDiagram> dmnDiagrams = this.getDmnDiagram(dmnDefinitions);
        JsInteropUtils.forEach(dmnDiagrams, dmnDiagram -> {
            if (StringUtils.isEmpty((String)dmnDiagram.getId())) {
                dmnDiagram.setId(IdUtils.uniqueId());
            }
        });
        return dmnDiagrams;
    }

    private JSIDMNDiagram generateDRGElement(JSITDefinitions dmnDefinitions) {
        JSIDMNDiagram drg = DRGDiagramUtils.newJSIDRGInstance();
        double[] globalOriginX = new double[]{0.0};
        JsInteropUtils.forEach(this.getDmnDiagram(dmnDefinitions), dmnDiagram -> {
            List elements = dmnDiagram.getDMNDiagramElement();
            double[] diagramOriginX = new double[]{globalOriginX[0]};
            JsInteropUtils.forEach(elements, element -> {
                JSIDMNShape shape;
                JSIDiagramElement copy = (JSIDiagramElement)Js.uncheckedCast((Object)JsInteropUtils.jsCopy(element));
                if (JSIDMNShape.instanceOf((Object)copy)) {
                    shape = (JSIDMNShape)Js.uncheckedCast((Object)copy);
                    JSIBounds bounds = shape.getBounds();
                    double currentMax = bounds.getX() + bounds.getWidth();
                    shape.setId(IdUtils.uniqueId());
                    bounds.setX(diagramOriginX[0] + bounds.getX());
                    if (currentMax > globalOriginX[0]) {
                        globalOriginX[0] = currentMax;
                    }
                }
                if (JSIDMNEdge.instanceOf((Object)copy)) {
                    shape = (JSIDMNEdge)Js.uncheckedCast((Object)copy);
                    shape.setId(IdUtils.uniqueId());
                    shape.setOtherAttributes(null);
                    JsInteropUtils.forEach(shape.getWaypoint(), jsiPoint -> jsiPoint.setX(diagramOriginX[0] + jsiPoint.getX()));
                }
                drg.addDMNDiagramElement((JSIDiagramElement)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)copy)));
            });
        });
        return drg;
    }

    private void renameDiagramElement(List<JSIDMNDiagram> dmnDiagramElements) {
        JSIDMNDiagram dmnDiagramElement = (JSIDMNDiagram)Js.uncheckedCast((Object)dmnDiagramElements.get(0));
        dmnDiagramElement.setName(DRGDiagramUtils.DRG);
    }

    private Optional<JSIDMNDiagram> findDRGDiagramElement(List<JSIDMNDiagram> dmnDiagramElements) {
        List<JSIDMNDiagram> eligibleAsDRGs = this.findEligibleDRGs(dmnDiagramElements);
        Optional<JSIDMNDiagram> drg = eligibleAsDRGs.stream().findFirst();
        if (drg.isPresent() && eligibleAsDRGs.size() > 1) {
            this.renameOtherEligibleDRGs(eligibleAsDRGs, (JSIDMNDiagram)Js.uncheckedCast((Object)drg.get()));
        }
        return drg;
    }

    private void renameOtherEligibleDRGs(List<JSIDMNDiagram> eligibleAsDRGs, JSIDMNDiagram drg) {
        String drgId = drg.getId();
        AtomicInteger index = new AtomicInteger();
        JsInteropUtils.forEach(eligibleAsDRGs, eligibleAsDRG -> {
            String currentId = eligibleAsDRG.getId();
            if (!Objects.equals(currentId, drgId)) {
                eligibleAsDRG.setName(eligibleAsDRG.getName() + "-" + index.incrementAndGet());
            }
        });
    }

    private List<JSIDMNDiagram> findEligibleDRGs(List<JSIDMNDiagram> dmnDiagramElements) {
        ArrayList<JSIDMNDiagram> eligibleDRGs = new ArrayList<JSIDMNDiagram>();
        JsInteropUtils.forEach(dmnDiagramElements, dmnDiagramElement -> {
            if (DRGDiagramUtils.isDRG(dmnDiagramElement)) {
                eligibleDRGs.add((JSIDMNDiagram)dmnDiagramElement);
            }
        });
        return eligibleDRGs;
    }

    private List<JSIDMNDiagram> getDmnDiagram(JSITDefinitions dmnDefinitions) {
        if (dmnDefinitions.getDMNDI() == null) {
            dmnDefinitions.setDMNDI(new JSIDMNDI());
        }
        return dmnDefinitions.getDMNDI().getDMNDiagram();
    }
}

