/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall;

import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSessionState;
import org.kie.workbench.common.dmn.client.marshaller.common.DMNDiagramElementsUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.DefinitionsConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.ItemDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.PointUtils;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsClientHelper;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntriesFactory;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIDiagramElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentsWidthsExtension;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.uberfire.client.promise.Promises;

@ApplicationScoped
public class DMNUnmarshaller {
    private final FactoryManager factoryManager;
    private final DMNMarshallerImportsClientHelper dmnMarshallerImportsHelper;
    private final Promises promises;
    private final NodeEntriesFactory modelToStunnerConverter;
    private final DMNDiagramElementsUtils dmnDiagramElementsUtils;
    private final DMNDiagramsSession dmnDiagramsSession;

    public DMNUnmarshaller() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public DMNUnmarshaller(FactoryManager factoryManager, DMNMarshallerImportsClientHelper dmnMarshallerImportsHelper, Promises promises, NodeEntriesFactory modelToStunnerConverter, DMNDiagramElementsUtils dmnDiagramElementsUtils, DMNDiagramsSession dmnDiagramsSession) {
        this.factoryManager = factoryManager;
        this.dmnMarshallerImportsHelper = dmnMarshallerImportsHelper;
        this.promises = promises;
        this.modelToStunnerConverter = modelToStunnerConverter;
        this.dmnDiagramElementsUtils = dmnDiagramElementsUtils;
        this.dmnDiagramsSession = dmnDiagramsSession;
    }

    @PostConstruct
    public void init() {
        MainJs.initializeJsInteropConstructors((JsPropertyMap)MainJs.getConstructorsMap());
    }

    public Promise<Graph> unmarshall(Metadata metadata, JSITDefinitions jsiDefinitions) {
        return this.getImportDefinitions(metadata, jsiDefinitions).then(importDefinitions -> this.getPMMLDocuments(metadata, jsiDefinitions).then(pmmlDocumentMetadata -> this.unmarshall(metadata, jsiDefinitions, (Map<JSITImport, JSITDefinitions>)importDefinitions, (Map<JSITImport, PMMLDocumentMetadata>)pmmlDocumentMetadata)));
    }

    Promise<Map<JSITImport, JSITDefinitions>> getImportDefinitions(Metadata metadata, JSITDefinitions jsiDefinitions) {
        List imports = jsiDefinitions.getImport();
        return this.dmnMarshallerImportsHelper.getImportDefinitionsAsync(metadata, imports);
    }

    Promise<Map<JSITImport, PMMLDocumentMetadata>> getPMMLDocuments(Metadata metadata, JSITDefinitions jsiDefinitions) {
        List imports = jsiDefinitions.getImport();
        return this.dmnMarshallerImportsHelper.getPMMLDocumentsAsync(metadata, imports);
    }

    private Promise<Graph> unmarshall(Metadata metadata, JSITDefinitions dmnDefinitions, Map<JSITImport, JSITDefinitions> importDefinitions, Map<JSITImport, PMMLDocumentMetadata> pmmlDocuments) {
        HashMap hasComponentWidthsMap = new HashMap();
        BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer = (uuid, hcw) -> {
            if (Objects.nonNull(uuid)) {
                hasComponentWidthsMap.put(uuid, hcw);
            }
        };
        boolean isDMNDIPresent = Optional.ofNullable(dmnDefinitions.getDMNDI()).isPresent();
        this.ensureDRGElementExists(dmnDefinitions);
        Definitions wbDefinitions = DefinitionsConverter.wbFromDMN(dmnDefinitions, importDefinitions, pmmlDocuments);
        List<NodeEntry> nodeEntries = this.modelToStunnerConverter.makeNodes(dmnDefinitions, importDefinitions, isDMNDIPresent, hasComponentWidthsConsumer);
        List<JSITDecisionService> dmnDecisionServices = this.getDecisionServices(nodeEntries);
        nodeEntries.forEach(e -> PointUtils.convertToRelativeBounds(e.getNode()));
        HashMap<String, Diagram> stunnerDiagramsById = new HashMap<String, Diagram>();
        HashMap<String, DMNDiagramElement> dmnDiagramsById = new HashMap<String, DMNDiagramElement>();
        for (DMNDiagramElement dmnDiagramElement : wbDefinitions.getDiagramElements()) {
            String dmnDiagramId = dmnDiagramElement.getId().getValue();
            Diagram value = this.factoryManager.newDiagram(dmnDiagramId, BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class), metadata);
            stunnerDiagramsById.put(dmnDiagramId, value);
            dmnDiagramsById.put(dmnDiagramId, dmnDiagramElement);
        }
        DMNDiagramsSessionState state = this.dmnDiagramsSession.setState(metadata, stunnerDiagramsById, dmnDiagramsById);
        nodeEntries.forEach(nodeEntry -> {
            String diagramId = nodeEntry.getDiagramId();
            Graph graph = ((Diagram)stunnerDiagramsById.get(diagramId)).getGraph();
            graph.addNode(nodeEntry.getNode());
        });
        Graph drgGraph = state.getDRGDiagram().getGraph();
        this.loadImportedItemDefinitions(wbDefinitions, importDefinitions);
        for (Diagram value : stunnerDiagramsById.values()) {
            Node<?, ?> dmnDiagramRoot = DMNGraphUtils.findDMNDiagramRoot(value.getGraph());
            ((DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).setDefinitions(wbDefinitions);
            nodeEntries.forEach(nodeEntry -> {
                if (Objects.equals(stunnerDiagramsById.get(nodeEntry.getDiagramId()), value)) {
                    this.connectRootWithChild(dmnDiagramRoot, nodeEntry.getNode());
                }
            });
        }
        ArrayList<String> references = new ArrayList<String>();
        ArrayList<JSITDecisionService> lstDecisionServices = new ArrayList<JSITDecisionService>(dmnDecisionServices);
        for (int iDS = 0; iDS < lstDecisionServices.size(); ++iDS) {
            List jsiOutputDecisions;
            JSITDecisionService jsiDecisionService = (JSITDecisionService)Js.uncheckedCast(lstDecisionServices.get(iDS));
            List jsiEncapsulatedDecisions = jsiDecisionService.getEncapsulatedDecision();
            if (Objects.nonNull(jsiEncapsulatedDecisions)) {
                for (int i = 0; i < jsiEncapsulatedDecisions.size(); ++i) {
                    JSITDMNElementReference jsiEncapsulatedDecision = (JSITDMNElementReference)Js.uncheckedCast(jsiEncapsulatedDecisions.get(i));
                    references.add(jsiEncapsulatedDecision.getHref());
                }
            }
            if (!Objects.nonNull(jsiOutputDecisions = jsiDecisionService.getOutputDecision())) continue;
            for (int i = 0; i < jsiOutputDecisions.size(); ++i) {
                JSITDMNElementReference jsiOutputDecision = (JSITDMNElementReference)Js.uncheckedCast(jsiOutputDecisions.get(i));
                references.add(jsiOutputDecision.getHref());
            }
        }
        List<JSITComponentsWidthsExtension> extensions = this.findComponentsWidthsExtensions(dmnDefinitions.getDMNDI().getDMNDiagram());
        extensions.forEach(componentsWidthsExtension -> {
            if (Objects.nonNull(componentsWidthsExtension.getComponentWidths())) {
                hasComponentWidthsMap.entrySet().forEach(es -> {
                    List jsiComponentWidths = componentsWidthsExtension.getComponentWidths();
                    for (int i = 0; i < jsiComponentWidths.size(); ++i) {
                        JSITComponentWidths jsiWidths = (JSITComponentWidths)Js.uncheckedCast(jsiComponentWidths.get(i));
                        if (!Objects.equals(jsiWidths.getDmnElementRef(), es.getKey())) continue;
                        List widths = ((HasComponentWidths)es.getValue()).getComponentWidths();
                        if (!Objects.nonNull(jsiWidths.getWidth())) continue;
                        widths.clear();
                        for (int w = 0; w < jsiWidths.getWidth().size(); ++w) {
                            double width = ((Float)jsiWidths.getWidth().get(w)).doubleValue();
                            widths.add(width);
                        }
                    }
                });
            }
        });
        return this.promises.resolve((Object)drgGraph);
    }

    private void ensureDRGElementExists(JSITDefinitions dmnDefinitions) {
        this.dmnDiagramElementsUtils.ensureDRGElementExists(dmnDefinitions);
    }

    private List<JSITDecisionService> getDecisionServices(List<NodeEntry> nodeEntries) {
        return nodeEntries.stream().filter(nodeEntry -> JSITDecisionService.instanceOf((Object)nodeEntry.getDmnElement())).map(nodeEntry -> {
            JSITDecisionService jsitDecisionService = (JSITDecisionService)Js.uncheckedCast((Object)nodeEntry.getDmnElement());
            return jsitDecisionService;
        }).collect(Collectors.toList());
    }

    private void connectRootWithChild(Node dmnDiagramRoot, Node child) {
        String uuid = UUID.uuid();
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent((Object)new Child());
        this.connectEdge((Edge)edge, dmnDiagramRoot, child);
        Definitions definitions = ((DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).getDefinitions();
        DMNModelInstrumentedBase childDRG = (DMNModelInstrumentedBase)((View)child.getContent()).getDefinition();
        childDRG.setParent((DMNModelInstrumentedBase)definitions);
    }

    private void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    private List<JSITComponentsWidthsExtension> findComponentsWidthsExtensions(List<JSIDMNDiagram> dmnDDDiagrams) {
        JSIDMNDiagram jsiDiagram;
        JSIDiagramElement.JSIExtension dmnDDExtensions;
        ArrayList<JSITComponentsWidthsExtension> componentsWidthsExtensions = new ArrayList<JSITComponentsWidthsExtension>();
        int dmnDiagram1Size = dmnDDDiagrams.size();
        for (int index = 0; index < dmnDiagram1Size && !Objects.isNull(dmnDDExtensions = (JSIDiagramElement.JSIExtension)Js.uncheckedCast((Object)(jsiDiagram = (JSIDMNDiagram)Js.uncheckedCast((Object)dmnDDDiagrams.get(index))).getExtension())) && !Objects.isNull(dmnDDExtensions.getAny()); ++index) {
            List extensions = dmnDDExtensions.getAny();
            if (Objects.isNull(extensions)) continue;
            for (int i = 0; i < extensions.size(); ++i) {
                Object wrapped = extensions.get(i);
                Object extension = JsUtils.getUnwrappedElement(wrapped);
                if (!JSITComponentsWidthsExtension.instanceOf((Object)extension)) continue;
                JSITComponentsWidthsExtension jsiExtension = (JSITComponentsWidthsExtension)Js.uncheckedCast((Object)extension);
                componentsWidthsExtensions.add(jsiExtension);
            }
        }
        return componentsWidthsExtensions;
    }

    private void loadImportedItemDefinitions(Definitions definitions, Map<JSITImport, JSITDefinitions> importDefinitions) {
        definitions.getItemDefinition().addAll(this.getWbImportedItemDefinitions(importDefinitions));
    }

    private List<ItemDefinition> getWbImportedItemDefinitions(Map<JSITImport, JSITDefinitions> importDefinitions) {
        ArrayList<ItemDefinition> definitions = new ArrayList<ItemDefinition>();
        List<JSITItemDefinition> importedDefinitions = this.dmnMarshallerImportsHelper.getImportedItemDefinitions(importDefinitions);
        for (int i = 0; i < importedDefinitions.size(); ++i) {
            JSITItemDefinition definition = (JSITItemDefinition)Js.uncheckedCast((Object)importedDefinitions.get(i));
            ItemDefinition converted = ItemDefinitionPropertyConverter.wbFromDMN(definition);
            if (converted == null) continue;
            converted.setAllowOnlyVisualChange(true);
            definitions.add(converted);
        }
        return definitions;
    }
}

