/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import com.google.common.collect.ImmutableList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoPropertiesFactory;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoSuggestionsPropertyFactory;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoEditor;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoLanguages;

@ApplicationScoped
public class MonacoFEELInitializer {
    public static final ImmutableList<String> FEEL_RESERVED_KEYWORDS = ImmutableList.of((Object)"for", (Object)"return", (Object)"if", (Object)"then", (Object)"else", (Object)"some", (Object)"every", (Object)"satisfies", (Object)"instance", (Object)"of", (Object)"in", (Object)"function", (Object[])new String[]{"external", "or", "and", "between", "not", "null", "true", "false"});
    private final MonacoSuggestionsPropertyFactory suggestionsPropertyFactory;
    private MonacoFEELInitializationStatus initializationStatus = MonacoFEELInitializationStatus.NOT_INITIALIZED;

    @Inject
    public MonacoFEELInitializer(MonacoSuggestionsPropertyFactory suggestionsPropertyFactory) {
        this.suggestionsPropertyFactory = suggestionsPropertyFactory;
    }

    public void initializeFEELEditor() {
        if (this.isFEELInitialized()) {
            return;
        }
        this.setFEELAsInitializing();
        MonacoPropertiesFactory properties = this.makeMonacoPropertiesFactory();
        MonacoLanguages.get().register(properties.getLanguage());
        MonacoLanguages.get().setMonarchTokensProvider("feel-language", properties.getLanguageDefinition());
        MonacoLanguages.get().registerCompletionItemProvider("feel-language", properties.getCompletionItemProvider(this.suggestionsPropertyFactory));
        MonacoEditor.get().defineTheme("feel-theme", properties.getThemeData());
        this.setFEELAsInitialized();
    }

    MonacoPropertiesFactory makeMonacoPropertiesFactory() {
        return new MonacoPropertiesFactory();
    }

    void setFEELAsInitialized() {
        this.initializationStatus = MonacoFEELInitializationStatus.INITIALIZED;
    }

    void setFEELAsInitializing() {
        this.initializationStatus = MonacoFEELInitializationStatus.INITIALIZING;
    }

    boolean isFEELInitialized() {
        return MonacoFEELInitializationStatus.INITIALIZED == this.getInitializationStatus() || MonacoFEELInitializationStatus.INITIALIZING == this.getInitializationStatus();
    }

    public MonacoFEELInitializationStatus getInitializationStatus() {
        return this.initializationStatus;
    }

    static enum MonacoFEELInitializationStatus {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

