/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.container;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.RootPanel;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Body;
import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.PopupEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;

@Templated
@ApplicationScoped
public class CellEditorControlsViewImpl
implements CellEditorControlsView {
    private static final String CONTAINER_CLASS = "kie-dmn-cell-editor-controls";
    private static final String BOOTSTRAP_SELECT_CLASS = "bootstrap-select";
    private static final String BOOTSTRAP_SELECT_OPEN_CLASS = "open";
    static final String DMN_CONTAINER_SELECT = "[id^='dmn_container_']";
    static final String PX = "px";
    public static final String LEFT = "left";
    public static final String TOP = "top";
    @DataField(value="cellEditorControls")
    private Div cellEditorControls;
    @DataField(value="cellEditorControlsContainer")
    private Div cellEditorControlsContainer;
    private Body body;
    private EventListener hidePopoverHandler = event -> {
        if (!this.isOverCellEditorControlsContainer(event)) {
            this.hide();
        }
    };
    private Optional<PopupEditorControls> activeEditor = Optional.empty();
    private Optional<ElementWrapperWidget<?>> elementWrapperWidget = Optional.empty();

    public Optional<PopupEditorControls> getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(Optional<PopupEditorControls> activeEditor) {
        this.activeEditor = activeEditor;
    }

    public CellEditorControlsViewImpl() {
    }

    @Inject
    public CellEditorControlsViewImpl(Document document, Div cellEditorControls, Div cellEditorControlsContainer) {
        this.cellEditorControls = cellEditorControls;
        this.cellEditorControlsContainer = cellEditorControlsContainer;
        this.body = document.getBody();
    }

    @PostConstruct
    public void setup() {
        this.cellEditorControls.setId(DOM.createUniqueId());
        this.elementWrapperWidget = Optional.of(this.getWidget());
        this.elementWrapperWidget.ifPresent(this::addWidgetToRootPanel);
        this.body.addEventListener("mousedown", this.hidePopoverHandler, false);
        this.body.addEventListener("mousewheel", this.hidePopoverHandler, false);
    }

    ElementWrapperWidget<?> getWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.getElement());
    }

    @PreDestroy
    public void destroy() {
        this.elementWrapperWidget.ifPresent(this::removeWidgetFromRootPanel);
        this.body.removeEventListener("mousedown", this.hidePopoverHandler, false);
        this.body.removeEventListener("mousewheel", this.hidePopoverHandler, false);
    }

    void addWidgetToRootPanel(ElementWrapperWidget<?> widget) {
        RootPanel.get().add(widget);
    }

    void removeWidgetFromRootPanel(ElementWrapperWidget<?> widget) {
        RootPanel.get().remove(widget);
    }

    @Override
    public void show(PopupEditorControls editor, int x, int y) {
        DOMUtil.removeAllChildren((Node)this.cellEditorControlsContainer);
        this.cellEditorControlsContainer.appendChild((Node)editor.getElement());
        CSSStyleDeclaration style = this.getElement().getStyle();
        style.setProperty(LEFT, x + PX);
        style.setProperty(TOP, y + PX);
        this.setActiveEditor(Optional.of(editor));
        this.setOnClosedByKeyboardCallback(editor);
        editor.show();
    }

    void setOnClosedByKeyboardCallback(PopupEditorControls editor) {
        if (editor instanceof CanBeClosedByKeyboard) {
            editor.setOnClosedByKeyboardCallback(this::focusOnDMNContainer);
        }
    }

    void removeOnClosedByKeyboardCallback(PopupEditorControls editor) {
        if (editor instanceof CanBeClosedByKeyboard) {
            editor.setOnClosedByKeyboardCallback(null);
        }
    }

    void focusOnDMNContainer(Object o) {
        Element element = this.getDMNContainer();
        if (!Objects.isNull(element)) {
            element.focus();
        }
    }

    Element getDMNContainer() {
        return DomGlobal.document.querySelector(DMN_CONTAINER_SELECT);
    }

    @Override
    public void hide() {
        this.getActiveEditor().ifPresent(PopupEditorControls::hide);
        this.getActiveEditor().ifPresent(e -> this.removeOnClosedByKeyboardCallback((PopupEditorControls)e));
        this.setActiveEditor(Optional.empty());
    }

    private boolean isOverCellEditorControlsContainer(Event event) {
        for (HTMLElement e = (HTMLElement)event.getTarget(); e != null; e = (HTMLElement)e.getParentElement()) {
            if (this.isOverCellEditorContainer(e)) {
                return true;
            }
            if (!this.isOverBootstrapSelectContainer(e)) continue;
            return true;
        }
        return false;
    }

    private boolean isOverCellEditorContainer(HTMLElement e) {
        return e.getClassList().contains(CONTAINER_CLASS);
    }

    private boolean isOverBootstrapSelectContainer(HTMLElement e) {
        if (!e.getClassList().contains(BOOTSTRAP_SELECT_CLASS)) {
            return false;
        }
        return e.getClassList().contains(BOOTSTRAP_SELECT_OPEN_CLASS);
    }
}

