/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.list;

import com.google.gwt.core.client.Scheduler;
import elemental2.dom.KeyboardEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorDividerItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorHeaderItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorTextItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;

@Templated
@Dependent
public class ListSelectorViewImpl
implements ListSelectorView {
    static final String OPEN = "open";
    @DataField(value="items-container")
    private UnorderedList itemsContainer;
    private ManagedInstance<ListSelectorTextItemView> listSelectorTextItemViews;
    private ManagedInstance<ListSelectorDividerItemView> listSelectorDividerItemViews;
    private ManagedInstance<ListSelectorHeaderItemView> listSelectorHeaderItemViews;
    private ListSelectorView.Presenter presenter;
    private Optional<Consumer<CanBeClosedByKeyboard>> closedByKeyboardCallback = Optional.empty();

    public ListSelectorViewImpl() {
    }

    @Inject
    public ListSelectorViewImpl(UnorderedList itemsContainer, ManagedInstance<ListSelectorTextItemView> listSelectorTextItemViews, ManagedInstance<ListSelectorDividerItemView> listSelectorDividerItemViews, ManagedInstance<ListSelectorHeaderItemView> listSelectorHeaderItemViews) {
        this.itemsContainer = itemsContainer;
        this.listSelectorTextItemViews = listSelectorTextItemViews;
        this.listSelectorDividerItemViews = listSelectorDividerItemViews;
        this.listSelectorHeaderItemViews = listSelectorHeaderItemViews;
    }

    public void init(ListSelectorView.Presenter presenter) {
        this.presenter = presenter;
        this.registerOnCloseHandler();
    }

    void registerOnCloseHandler() {
        this.getElement().addEventListener("keydown", this.onKeyDown(), false);
    }

    EventListener<Event> onKeyDown() {
        return event -> {
            if (this.isEscape(event)) {
                this.hide();
                this.returnFocusToPanel();
            }
        };
    }

    boolean isEscape(Event event) {
        KeyboardEvent keyboardEvent = this.asElemental2Event(event);
        boolean isEscape = keyboardEvent.key.equals("Esc");
        boolean isEsc = keyboardEvent.key.equals("Escape");
        return isEscape || isEsc;
    }

    @Override
    public void setItems(List<HasListSelectorControl.ListSelectorItem> items) {
        DOMUtil.removeAllChildren((Node)this.itemsContainer);
        items.forEach(item -> this.makeListSelectorItemView((HasListSelectorControl.ListSelectorItem)item).ifPresent(child -> this.itemsContainer.appendChild((Node)child.getElement())));
    }

    private Optional<IsElement> makeListSelectorItemView(HasListSelectorControl.ListSelectorItem item) {
        Optional<Object> listSelectorItemView = Optional.empty();
        if (item instanceof HasListSelectorControl.ListSelectorTextItem) {
            HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
            ListSelectorTextItemView selector = (ListSelectorTextItemView)this.listSelectorTextItemViews.get();
            selector.setText(ti.getText());
            selector.setEnabled(ti.isEnabled());
            selector.addClickHandler(() -> {
                if (ti.isEnabled()) {
                    this.presenter.onItemSelected(item);
                }
            });
            listSelectorItemView = Optional.of(selector);
        } else if (item instanceof HasListSelectorControl.ListSelectorDividerItem) {
            listSelectorItemView = Optional.of((IsElement)this.listSelectorDividerItemViews.get());
        } else if (item instanceof HasListSelectorControl.ListSelectorHeaderItem) {
            HasListSelectorControl.ListSelectorHeaderItem ti = (HasListSelectorControl.ListSelectorHeaderItem)item;
            ListSelectorHeaderItemView selector = (ListSelectorHeaderItemView)this.listSelectorHeaderItemViews.get();
            selector.setText(ti.getText());
            selector.setIconClass(ti.getIconClass());
            listSelectorItemView = Optional.of(selector);
        }
        return listSelectorItemView;
    }

    @Override
    public void show(Optional<String> title) {
        this.getElement().getClassList().add(OPEN);
        this.schedule(() -> this.getElement().focus());
    }

    @Override
    public void hide() {
        this.getElement().getClassList().remove(OPEN);
    }

    @Override
    public void setOnClosedByKeyboardCallback(Consumer<CanBeClosedByKeyboard> callback) {
        this.closedByKeyboardCallback = Optional.ofNullable(callback);
    }

    void returnFocusToPanel() {
        this.closedByKeyboardCallback.ifPresent(c -> c.accept(this));
    }

    void schedule(Scheduler.ScheduledCommand command) {
        Scheduler.get().scheduleDeferred(command);
    }

    KeyboardEvent asElemental2Event(Event event) {
        return (KeyboardEvent)event;
    }
}

