/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import javax.enterprise.event.Event;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.project.client.editor.DMNDiagramEditor;
import org.kie.workbench.common.dmn.project.client.editor.DMNProjectEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.editor.ProjectToolbarStateHandler;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditorTest;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectEditorMenuSessionItems;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={PathPlaceRequest.class})
public class DMNDiagramEditorTest
extends AbstractProjectDiagramEditorTest {
    @Mock
    private PlaceRequest currentPlace;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNEditorSession dmnEditorSession;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private ExpressionEditorView.Presenter expressionEditor;
    @Mock
    private DecisionNavigatorDock decisionNavigatorDock;
    @Mock
    private EditExpressionEvent editExpressionEvent;
    @Mock
    private DMNProjectEditorMenuSessionItems dmnProjectMenuSessionItems;
    @Mock
    private LayoutHelper layoutHelper;
    @Mock
    private DataTypesPage dataTypesPage;
    @Mock
    private MultiPageEditor multiPage;
    private DMNDiagramEditor diagramEditor;

    @Before
    public void before() {
        Mockito.when((Object)this.kieView.getMultiPage()).thenReturn((Object)this.multiPage);
    }

    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.sessionEditorPresenter.getInstance()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
    }

    protected DMNDiagramResourceType mockResourceType() {
        DMNDiagramResourceType resourceType = (DMNDiagramResourceType)Mockito.mock(DMNDiagramResourceType.class);
        Mockito.when((Object)resourceType.getSuffix()).thenReturn((Object)"dmn");
        Mockito.when((Object)resourceType.getShortName()).thenReturn((Object)"DMN");
        return resourceType;
    }

    protected AbstractProjectDiagramEditor createDiagramEditor() {
        this.diagramEditor = (DMNDiagramEditor)Mockito.spy((Object)new DMNDiagramEditor(this.view, this.placeManager, this.errorPopupPresenter, (Event)this.changeTitleNotificationEvent, this.savePopUpPresenter, (DMNDiagramResourceType)this.getResourceType(), this.clientProjectDiagramService, this.sessionEditorPresenters, this.sessionViewerPresenters, (DMNProjectEditorMenuSessionItems)this.getMenuSessionItems(), (Event)this.onDiagramFocusEvent, (Event)this.onDiagramLostFocusEvent, (Event)this.refreshFormPropertiesEvent, this.projectMessagesListener, this.diagramClientErrorHandler, this.translationService, this.xmlEditorView, this.projectDiagramResourceServiceCaller, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, this.decisionNavigatorDock, this.layoutHelper, this.dataTypesPage){
            {
                this.fileMenuBuilder = DMNDiagramEditorTest.this.fileMenuBuilder;
                this.workbenchContext = DMNDiagramEditorTest.this.workbenchContext;
                this.projectController = DMNDiagramEditorTest.this.projectController;
                this.versionRecordManager = DMNDiagramEditorTest.this.versionRecordManager;
                DMNDiagramEditorTest.this.sessionEditorPresenters = DMNDiagramEditorTest.this.sessionEditorPresenters;
                this.alertsButtonMenuItemBuilder = DMNDiagramEditorTest.this.alertsButtonMenuItemBuilder;
                this.kieView = DMNDiagramEditorTest.this.kieView;
                this.overviewWidget = DMNDiagramEditorTest.this.overviewWidget;
                this.notification = DMNDiagramEditorTest.this.notification;
            }
        });
        return this.diagramEditor;
    }

    protected AbstractProjectEditorMenuSessionItems getMenuSessionItems() {
        return this.dmnProjectMenuSessionItems;
    }

    @Test
    public void testOnStartup() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superDoStartUp(this.filePath, this.currentPlace);
        this.diagramEditor.onStartup(this.filePath, this.currentPlace);
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superDoStartUp(this.filePath, this.currentPlace);
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).init("LibraryPerspective");
    }

    @Test
    public void testOnClose() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superOnClose();
        this.diagramEditor.onClose();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superOnClose();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).close();
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock)).resetContent();
    }

    @Test
    public void testInitialiseKieEditorForSession() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superInitialiseKieEditorForSession((ProjectDiagram)Matchers.any());
        this.diagramEditor.initialiseKieEditorForSession(this.diagram);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).addPage((Page)this.dataTypesPage);
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNotNull() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        this.open();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.decisionNavigatorDock});
        ((DecisionNavigatorDock)inOrder.verify((Object)this.decisionNavigatorDock)).setupDiagram((Diagram)this.diagram);
        ((DecisionNavigatorDock)inOrder.verify((Object)this.decisionNavigatorDock)).setupCanvasHandler((CanvasHandler)Matchers.eq((Object)this.canvasHandler));
        ((DecisionNavigatorDock)inOrder.verify((Object)this.decisionNavigatorDock)).open();
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.expressionEditor)).setToolbarStateHandler((ToolbarStateHandler)Matchers.any(ProjectToolbarStateHandler.class));
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).reload();
        ((LayoutHelper)Mockito.verify((Object)this.layoutHelper)).applyLayout((Diagram)this.diagram);
    }

    @Test
    public void testOnDiagramLoadWhenCanvasHandlerIsNull() {
        this.diagramEditor.onDiagramLoad();
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.expressionEditor, (VerificationMode)Mockito.never())).setToolbarStateHandler((ToolbarStateHandler)Matchers.any(ProjectToolbarStateHandler.class));
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).setupCanvasHandler((CanvasHandler)Matchers.any());
        ((DecisionNavigatorDock)Mockito.verify((Object)this.decisionNavigatorDock, (VerificationMode)Mockito.never())).open();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage, (VerificationMode)Mockito.never())).reload();
    }

    @Test
    public void testOnFocus() {
        ((DMNDiagramEditor)Mockito.doNothing().when((Object)this.diagramEditor)).superDoFocus();
        this.diagramEditor.onFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).superDoFocus();
        ((DMNDiagramEditor)Mockito.verify((Object)this.diagramEditor)).onDiagramLoad();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onFocus();
    }

    @Test
    public void testOnLostFocus() {
        this.diagramEditor.onLostFocus();
        ((DataTypesPage)Mockito.verify((Object)this.dataTypesPage)).onLostFocus();
    }

    @Test
    public void testOnEditExpressionEvent() {
        Mockito.when((Object)this.editExpressionEvent.getSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnEditorSession);
        Mockito.when((Object)this.dmnEditorSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        this.open();
        this.diagramEditor.onEditExpressionEvent(this.editExpressionEvent);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)Matchers.any(NavigateToExpressionEditorCommand.class));
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        this.diagramEditor.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((MultiPageEditor)Mockito.verify((Object)this.multiPage)).selectPage(2);
    }
}

