/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.project.client.editor.DMNProjectDiagramEditorMenuItemsBuilder;
import org.kie.workbench.common.dmn.project.client.editor.DMNProjectEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.session.DMNEditorSessionCommands;
import org.kie.workbench.common.stunner.core.client.session.command.impl.PerformAutomaticLayoutCommand;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNProjectEditorMenuSessionItemsTest {
    @Mock
    private FileMenuBuilder fileMenuBuilder;
    @Mock
    private DMNProjectDiagramEditorMenuItemsBuilder builder;
    @Mock
    private DMNEditorSessionCommands sessionCommands;

    @Test
    public void testPopulateMenu() {
        DMNProjectEditorMenuSessionItems menuItems = (DMNProjectEditorMenuSessionItems)Mockito.spy((Object)new DMNProjectEditorMenuSessionItems(this.builder, this.sessionCommands));
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ((DMNProjectEditorMenuSessionItems)Mockito.doNothing().when((Object)menuItems)).superPopulateMenu((FileMenuBuilder)Matchers.any());
        ((DMNProjectEditorMenuSessionItems)Mockito.doReturn((Object)menuItem).when((Object)menuItems)).newPerformAutomaticLayout();
        menuItems.populateMenu(this.fileMenuBuilder);
        ((DMNProjectEditorMenuSessionItems)Mockito.verify((Object)menuItems)).addPerformAutomaticLayout((FileMenuBuilder)Matchers.any());
    }

    @Test
    public void testEnableMenu() {
        this.testMenu(true);
    }

    @Test
    public void testDisableMenu() {
        this.testMenu(false);
    }

    private void testMenu(boolean enabled) {
        DMNProjectEditorMenuSessionItems menuItems = (DMNProjectEditorMenuSessionItems)Mockito.spy((Object)new DMNProjectEditorMenuSessionItems(this.builder, this.sessionCommands));
        ((DMNProjectEditorMenuSessionItems)Mockito.doNothing().when((Object)menuItems)).superSetEnabled(enabled);
        menuItems.setEnabled(enabled);
        ((DMNProjectEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(PerformAutomaticLayoutCommand.class, enabled);
    }
}

