/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.DomGlobal;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPage;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypesPage;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.project.client.editor.DMNProjectEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.editor.ProjectToolbarStateHandler;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.annotation.DiagramEditor;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.layout.LayoutHelper;
import org.kie.workbench.common.stunner.core.client.components.layout.OpenDiagramLayoutExecutor;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectEditorMenuSessionItems;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnLostFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@DiagramEditor
@WorkbenchEditor(identifier="DMNDiagramEditor", supportedTypes={DMNDiagramResourceType.class})
public class DMNDiagramEditor
extends AbstractProjectDiagramEditor<DMNDiagramResourceType> {
    public static final String EDITOR_ID = "DMNDiagramEditor";
    private static final int DATA_TYPES_PAGE_INDEX = 2;
    private final SessionManager sessionManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    private final DecisionNavigatorDock decisionNavigatorDock;
    private final LayoutHelper layoutHelper;
    private final DataTypesPage dataTypesPage;
    private final OpenDiagramLayoutExecutor openDiagramLayoutExecutor;
    private final IncludedModelsPage includedModelsPage;
    private final IncludedModelsPageStateProviderImpl importsPageProvider;

    @Inject
    public DMNDiagramEditor(AbstractProjectDiagramEditor.View view, DocumentationView documentationView, PlaceManager placeManager, ErrorPopupPresenter errorPopupPresenter, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, SavePopUpPresenter savePopUpPresenter, DMNDiagramResourceType resourceType, ClientProjectDiagramService projectDiagramServices, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, DMNProjectEditorMenuSessionItems menuSessionItems, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, ProjectMessagesListener projectMessagesListener, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService, TextEditorView xmlEditorView, Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DecisionNavigatorDock decisionNavigatorDock, LayoutHelper layoutHelper, DataTypesPage dataTypesPage, OpenDiagramLayoutExecutor openDiagramLayoutExecutor, IncludedModelsPage includedModelsPage, IncludedModelsPageStateProviderImpl importsPageProvider) {
        super(view, documentationView, placeManager, errorPopupPresenter, changeTitleNotificationEvent, savePopUpPresenter, (ClientResourceType)resourceType, projectDiagramServices, editorSessionPresenterInstances, viewerSessionPresenterInstances, (AbstractProjectEditorMenuSessionItems)menuSessionItems, onDiagramFocusEvent, onDiagramLostFocusEvent, projectMessagesListener, diagramClientErrorHandler, translationService, xmlEditorView, projectDiagramResourceServiceCaller);
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.decisionNavigatorDock = decisionNavigatorDock;
        this.layoutHelper = layoutHelper;
        this.dataTypesPage = dataTypesPage;
        this.openDiagramLayoutExecutor = openDiagramLayoutExecutor;
        this.includedModelsPage = includedModelsPage;
        this.importsPageProvider = importsPageProvider;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.superDoStartUp(path, place);
        this.decisionNavigatorDock.init("LibraryPerspective");
    }

    protected String getDiagramParsingErrorMessage(DiagramParsingException e) {
        return this.getTranslationService().getValue("DMNDiagramParsingErrorMessage");
    }

    protected void initialiseKieEditorForSession(ProjectDiagram diagram) {
        this.superInitialiseKieEditorForSession(diagram);
        this.kieView.getMultiPage().addPage((Page)this.dataTypesPage);
        this.kieView.getMultiPage().addPage((Page)this.includedModelsPage);
    }

    public void showDocks() {
        super.showDocks();
        this.decisionNavigatorDock.open();
    }

    public void hideDocks() {
        super.hideDocks();
        this.decisionNavigatorDock.close();
        this.decisionNavigatorDock.resetContent();
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        this.kieView.getMultiPage().selectPage(2);
    }

    void superInitialiseKieEditorForSession(ProjectDiagram diagram) {
        super.initialiseKieEditorForSession(diagram);
    }

    public void open(ProjectDiagram diagram) {
        this.layoutHelper.applyLayout((Diagram)diagram, (LayoutExecutor)this.openDiagramLayoutExecutor);
        super.open(diagram);
    }

    @OnOpen
    public void onOpen() {
        super.doOpen();
    }

    @OnClose
    public void onClose() {
        this.superDoClose();
        this.dataTypesPage.disableShortcuts();
        super.onClose();
    }

    protected void onDiagramLoad() {
        Optional<CanvasHandler> canvasHandler = Optional.ofNullable(this.getCanvasHandler());
        canvasHandler.ifPresent(c -> {
            ExpressionEditorView.Presenter expressionEditor = ((DMNSession)this.sessionManager.getCurrentSession()).getExpressionEditor();
            expressionEditor.setToolbarStateHandler((ToolbarStateHandler)new ProjectToolbarStateHandler(this.getMenuSessionItems()));
            this.decisionNavigatorDock.setupCanvasHandler(c);
            this.dataTypesPage.reload();
            this.includedModelsPage.setup(this.importsPageProvider.withDiagram(c.getDiagram()));
        });
    }

    @OnFocus
    public void onFocus() {
        this.superDoFocus();
        this.onDiagramLoad();
        this.dataTypesPage.onFocus();
        this.dataTypesPage.enableShortcuts();
    }

    @OnLostFocus
    public void onLostFocus() {
        super.doLostFocus();
        this.dataTypesPage.onLostFocus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        super.getMenus(menusConsumer);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentDiagramHash()));
    }

    protected String getEditorIdentifier() {
        return EDITOR_ID;
    }

    public void onDataTypeEditModeToggle(@Observes DataTypeEditModeToggleEvent event) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)this.getOnDataTypeEditModeToggleCallback(event), (double)250.0, (Object[])new Object[0]);
    }

    DomGlobal.SetTimeoutCallbackFn getOnDataTypeEditModeToggleCallback(DataTypeEditModeToggleEvent event) {
        return e -> {
            if (event.isEditModeEnabled()) {
                this.disableMenuItem(MenuItems.SAVE);
            } else {
                this.enableMenuItem(MenuItems.SAVE);
            }
        };
    }

    void onEditExpressionEvent(@Observes EditExpressionEvent event) {
        if (this.isSameSession(event.getSession())) {
            DMNSession session = (DMNSession)this.sessionManager.getCurrentSession();
            ExpressionEditorView.Presenter expressionEditor = session.getExpressionEditor();
            this.sessionCommandManager.execute((Object)session.getCanvasHandler(), (Command)new NavigateToExpressionEditorCommand(expressionEditor, this.getSessionPresenter(), this.sessionManager, this.sessionCommandManager, this.refreshFormPropertiesEvent, event.getNodeUUID(), event.getHasExpression(), event.getHasName(), event.isOnlyVisualChangeAllowed()));
        }
    }

    void superDoFocus() {
        super.doFocus();
    }

    void superDoClose() {
        super.doClose();
    }

    void superDoStartUp(ObservablePath path, PlaceRequest place) {
        super.doStartUp(path, place);
    }
}

