/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.service;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModelsService;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.types.DMNParseService;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.api.editors.types.DMNValidationService;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.api.editors.types.TimeZoneService;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.uberfire.backend.vfs.Path;

@Dependent
public class DMNClientServicesProxyImpl
implements DMNClientServicesProxy {
    private final WorkspaceProjectContext projectContext;
    private final Caller<DMNIncludedModelsService> includedModelsService;
    private final Caller<DMNParseService> parserService;
    private final Caller<DMNValidationService> validationService;
    private final Caller<TimeZoneService> timeZoneService;

    @Inject
    public DMNClientServicesProxyImpl(WorkspaceProjectContext projectContext, Caller<DMNIncludedModelsService> includedModelsService, Caller<DMNParseService> parserService, Caller<DMNValidationService> validationService, Caller<TimeZoneService> timeZoneService) {
        this.projectContext = projectContext;
        this.includedModelsService = includedModelsService;
        this.parserService = parserService;
        this.validationService = validationService;
        this.timeZoneService = timeZoneService;
    }

    public void loadModels(Path path, ServiceCallback<List<IncludedModel>> callback) {
        ((DMNIncludedModelsService)this.includedModelsService.call(this.onSuccess(callback), this.onError(callback))).loadModels(path, this.getWorkspaceProject());
    }

    public void loadNodesFromImports(List<DMNIncludedModel> includedModels, ServiceCallback<List<DMNIncludedNode>> callback) {
        ((DMNIncludedModelsService)this.includedModelsService.call(this.onSuccess(callback), this.onError(callback))).loadNodesFromImports(this.getWorkspaceProject(), includedModels);
    }

    public void loadPMMLDocumentsFromImports(Path path, List<PMMLIncludedModel> includedModels, ServiceCallback<List<PMMLDocumentMetadata>> callback) {
        ((DMNIncludedModelsService)this.includedModelsService.call(this.onSuccess(callback), this.onError(callback))).loadPMMLDocumentsFromImports(path, this.getWorkspaceProject(), includedModels);
    }

    public void loadItemDefinitionsByNamespace(String modelName, String namespace, ServiceCallback<List<ItemDefinition>> callback) {
        ((DMNIncludedModelsService)this.includedModelsService.call(this.onSuccess(callback), this.onError(callback))).loadItemDefinitionsByNamespace(this.getWorkspaceProject(), modelName, namespace);
    }

    public void parseFEELList(String source, ServiceCallback<List<String>> callback) {
        ((DMNParseService)this.parserService.call(this.onSuccess(callback), this.onError(callback))).parseFEELList(source);
    }

    public void parseRangeValue(String source, ServiceCallback<RangeValue> callback) {
        ((DMNParseService)this.parserService.call(this.onSuccess(callback), this.onError(callback))).parseRangeValue(source);
    }

    public void isValidVariableName(String source, ServiceCallback<Boolean> callback) {
        ((DMNValidationService)this.validationService.call(this.onSuccess(callback), this.onError(callback))).isValidVariableName(source);
    }

    public void getTimeZones(ServiceCallback<List<DMNSimpleTimeZone>> callback) {
        ((TimeZoneService)this.timeZoneService.call(this.onSuccess(callback), this.onError(callback))).getTimeZones();
    }

    <T> RemoteCallback<T> onSuccess(ServiceCallback<T> callback) {
        return arg_0 -> callback.onSuccess(arg_0);
    }

    <T> ErrorCallback<Boolean> onError(ServiceCallback<T> callback) {
        return (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        };
    }

    private WorkspaceProject getWorkspaceProject() {
        return this.projectContext.getActiveWorkspaceProject().orElse(null);
    }
}

